/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.java;

import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.soda.devicekit.generator.model.java.JavaKeywords;

public class CodeUtilities {
    public static String betterDescriptionFromProjectName(String projectName, String prefix) {
        String data = projectName.substring(prefix.length() + 1);
        StringBuffer buffer = new StringBuffer(64);
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            if (last) {
                if (i > 0) {
                    buffer.append(' ');
                }
                buffer.append(Character.toUpperCase(character));
            } else if (character != '.') {
                buffer.append(character);
            }
            last = character == '.';
            ++i;
        }
        return buffer.toString();
    }

    public static String betterName(String data, boolean caps) {
        StringBuffer buffer = new StringBuffer(64);
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (!last && upper) {
                buffer.append(' ');
            }
            if (i > 0 || !caps) {
                buffer.append(Character.toLowerCase(character));
            } else {
                buffer.append(Character.toUpperCase(character));
            }
            last = upper;
            ++i;
        }
        return buffer.toString();
    }

    public static String betterNameFromProjectName(String projectName, String prefix) {
        String data = projectName.substring(prefix.length() + 1);
        StringBuffer buffer = new StringBuffer(64);
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            if (last) {
                buffer.append(Character.toUpperCase(character));
            } else if (character != '.') {
                buffer.append(character);
            }
            last = character == '.';
            ++i;
        }
        return buffer.toString();
    }

    public static String fieldName(String key) {
        return CodeUtilities.validIdentifier(key, false);
    }

    public static String fieldReference(String key, boolean lazy) {
        StringBuffer buffer = new StringBuffer(128);
        CodeUtilities.fieldReference(key, lazy, buffer);
        return buffer.toString();
    }

    public static void fieldReference(String key, boolean lazy, StringBuffer buffer) {
        if (lazy) {
            buffer.append("get");
            buffer.append(CodeUtilities.methodName(key));
            buffer.append("()");
        } else {
            buffer.append("this.");
            buffer.append(CodeUtilities.fieldName(key));
        }
    }

    public static boolean isJavaKeyword(String segment) {
        String[] keywords = JavaKeywords.keywords;
        int i = 0;
        while (i < keywords.length) {
            if (segment.equalsIgnoreCase(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String methodName(String key) {
        return CodeUtilities.validIdentifier(key, true);
    }

    public static String staticFieldName(String key) {
        return CodeUtilities.validIdentifier(key, true);
    }

    public static String staticFieldName(String key, boolean allUpper) {
        if (allUpper) {
            return CodeUtilities.validStaticIdentifier(key);
        }
        return CodeUtilities.validIdentifier(key, true);
    }

    public static String validIdentifier(String key, boolean upperCase) {
        String result;
        char[] characters = key.toCharArray();
        StringBuffer buffer = new StringBuffer(characters.length + 1);
        if (characters.length > 0) {
            char character = characters[0];
            if (Character.isLetter(character)) {
                if (upperCase) {
                    buffer.append(Character.toUpperCase(character));
                } else {
                    buffer.append(Character.toLowerCase(character));
                }
            } else {
                buffer.append('a');
            }
            int i = 1;
            while (i < characters.length) {
                character = characters[i];
                if (Character.isJavaIdentifierPart(character)) {
                    buffer.append(character);
                } else {
                    buffer.append('_');
                }
                ++i;
            }
        }
        if (!JavaConventions.validateFieldName((String)(result = buffer.toString())).isOK()) {
            buffer.append('_');
        }
        return buffer.toString();
    }

    public static String validStaticIdentifier(String key) {
        String result;
        char[] characters = key.toCharArray();
        StringBuffer buffer = new StringBuffer(characters.length + 1);
        if (characters.length > 0) {
            char character = characters[0];
            if (Character.isLetter(character)) {
                buffer.append(Character.toUpperCase(character));
            } else {
                buffer.append('A');
            }
            int i = 1;
            while (i < characters.length) {
                character = characters[i];
                if (Character.isJavaIdentifierPart(character)) {
                    if (Character.isUpperCase(character)) {
                        buffer.append('_');
                    }
                    buffer.append(Character.toUpperCase(character));
                } else {
                    buffer.append('_');
                }
                ++i;
            }
        }
        if (!JavaConventions.validateFieldName((String)(result = buffer.toString())).isOK()) {
            buffer.append('_');
        }
        return buffer.toString();
    }
}

