/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.templates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.feature.DeviceKitTemplateContent;
import org.eclipse.soda.devicekit.generator.templates.GeneratorContextType;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;

public class GeneratorTemplates {
    private static final String VENDOR = DeviceKitPreferenceInitializer.getPreferenceString((String)"vendor");
    private static final String VERSION = DeviceKitPreferenceInitializer.getPreferenceString((String)"version");
    private static final String PROVIDER = DeviceKitPreferenceInitializer.getPreferenceString((String)"provider");
    public static final TemplateStore templateStore = GeneratorPlugin.getDefault().getTemplateStore();
    public static DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());

    public static String getAbout() {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.legal/about.html");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(GeneratorTemplates.getTemplateVariables(-1));
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getCopyright() {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.legal/copyright.txt");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(GeneratorTemplates.getTemplateVariables(-1));
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getCopyright(Map map) {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.legal/copyright.txt");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getCopyright(int createYear) {
        return GeneratorTemplates.getCopyright(GeneratorTemplates.getTemplateVariables(createYear));
    }

    public static String getCopyrightCodeString(Map map) {
        String[] strings = GeneratorTemplates.getCopyrightStrings(map);
        StringBuffer buffer = new StringBuffer(1024);
        int length = strings.length;
        int max = 0;
        int i = 0;
        while (i < length) {
            max = Math.max(max, String.valueOf(strings[i]).length());
            ++i;
        }
        buffer.append("/****");
        int j = 0;
        while (j < max) {
            buffer.append('*');
            ++j;
        }
        buffer.append("\r\n");
        i = 0;
        while (i < length) {
            String comment = String.valueOf(strings[i]);
            int size = comment.length();
            buffer.append(" * ");
            if (size > 0) {
                buffer.append(comment);
            }
            int j2 = 0;
            while (j2 < max - size) {
                buffer.append(' ');
                ++j2;
            }
            buffer.append(" *\r\n");
            ++i;
        }
        buffer.append(" **");
        j = 0;
        while (j < max) {
            buffer.append('*');
            ++j;
        }
        buffer.append("*/\r\n");
        return buffer.toString();
    }

    public static String getCopyrightLine(Map map) {
        String[] strings = GeneratorTemplates.getCopyrightStrings(map);
        if (strings.length > 0) {
            return strings[0];
        }
        return "";
    }

    public static String getCopyrightPropertyString(Map map) {
        String[] copyrightStrings = GeneratorTemplates.getCopyrightStrings(map);
        int max = 0;
        int i = 0;
        while (i < copyrightStrings.length) {
            max = Math.max(max, String.valueOf(copyrightStrings[i]).length());
            ++i;
        }
        StringBuffer buffer = new StringBuffer(1024);
        int j = 0;
        while (j < max + 4) {
            buffer.append('#');
            ++j;
        }
        buffer.append("\r\n");
        int i2 = 0;
        while (i2 < copyrightStrings.length) {
            buffer.append('#');
            buffer.append(' ');
            int size = copyrightStrings[i2].length();
            if (size > 0) {
                buffer.append(copyrightStrings[i2]);
            }
            int j2 = 0;
            while (j2 < max - size) {
                buffer.append(' ');
                ++j2;
            }
            buffer.append(" #\r\n");
            ++i2;
        }
        j = 0;
        while (j < max + 4) {
            buffer.append('#');
            ++j;
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    public static String[] getCopyrightStrings(Map map) {
        String copyright = GeneratorTemplates.getCopyright(map).trim();
        return GeneratorTemplates.getStrings(copyright);
    }

    public static String getCopyrightXmlString(Map map) {
        String[] strings = GeneratorTemplates.getCopyrightStrings(map);
        return GeneratorTemplates.getXmlString(strings);
    }

    public static String getFeature(Map map) {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.feature");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getFeatureBuildProperties(Map map) {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.feature.build.properties");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getFeatureFeatureProperties(Map map) {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.feature.feature.properties");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getLicense(Map map) {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.license");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getPackageHtml(Map map) {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.code/package.html");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getResults(String key, Map map) {
        String fullKey = "org.eclipse.soda.devicekit.generator.templates." + key;
        TemplatePersistenceData templateData = templateStore.getTemplateData(fullKey);
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            System.err.println("Key not found " + fullKey);
            e.printStackTrace();
            return "";
        }
    }

    public static String[] getStrings(String copyright) {
        BufferedReader reader = new BufferedReader(new StringReader(copyright));
        Vector<String> list = new Vector<String>(10);
        boolean more = true;
        while (more) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return new String[0];
            }
            if (line == null) {
                more = false;
                continue;
            }
            list.add(line);
        }
        int size = list.size();
        String[] results = new String[size];
        results = list.toArray(results);
        return results;
    }

    public static Map getTemplateVariables(int createYear) {
        int currentYear = Calendar.getInstance().get(1);
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("year", String.valueOf(currentYear));
        if (createYear >= 1970 & createYear <= 3000 && createYear != currentYear) {
            map.put("years", String.valueOf(String.valueOf(createYear)) + ", " + String.valueOf(currentYear));
        } else {
            map.put("years", String.valueOf(currentYear));
        }
        map.put("vendor", VENDOR);
        map.put("vendors", VENDOR);
        map.put("version", VERSION);
        map.put("provider", PROVIDER);
        map.put("copyright_properties", GeneratorTemplates.getCopyrightPropertyString(map));
        map.put("copyright_xml", GeneratorTemplates.getCopyrightXmlString(map));
        map.put("copyright_line", GeneratorTemplates.getCopyrightLine(map));
        return map;
    }

    public static String getWarning(Map map) {
        TemplatePersistenceData templateData = templateStore.getTemplateData("org.eclipse.soda.devicekit.generator.templates.warning");
        DeviceKitTemplateContent context = new DeviceKitTemplateContent(new GeneratorContextType());
        try {
            context.addVariables(map);
            return context.evaluate(templateData.getTemplate()).getString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateData.getTemplate().getPattern();
        }
    }

    public static String getXmlString(String[] strings) {
        StringBuffer buffer = new StringBuffer(1024);
        int length = strings.length;
        int max = 0;
        int i = 0;
        while (i < length) {
            max = Math.max(max, String.valueOf(strings[i]).length());
            ++i;
        }
        i = 0;
        while (i < length) {
            String comment = String.valueOf(strings[i]);
            int size = comment.length();
            buffer.append("<!-- ");
            if (size > 0) {
                buffer.append(comment);
            }
            int j = 0;
            while (j < max - size) {
                buffer.append(' ');
                ++j;
            }
            buffer.append(" -->\r\n");
            ++i;
        }
        return buffer.toString();
    }

    public static String getXmlWarning(Map map) {
        String[] data = GeneratorTemplates.getStrings(GeneratorTemplates.getWarning(map));
        return GeneratorTemplates.getXmlString(data);
    }
}

