/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.util.DkPackageSearchRequestor;

public class DeviceKitEclipseUtilities
extends DeviceKitUtilities {
    public static IJavaElement[] collectSourceFoldersFromWorkspace() throws JavaModelException {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IJavaProject jProject = DeviceKitEclipseUtilities.getJavaProjectFromProject(projects[i]);
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int j = 0;
            while (j < roots.length) {
                if (roots[j].getKind() == 1) {
                    result.add(roots[j]);
                }
                ++j;
            }
            ++i;
        }
        IJavaElement[] elements = new IJavaElement[result.size()];
        result.toArray(elements);
        return elements;
    }

    public static IPackageFragment getDkPackageFragement(IJavaProject project, String pack, boolean sourceFolder, String sfName) throws Exception {
        IPackageFragment frag;
        if (!sourceFolder) {
            IPackageFragmentRoot firstRoot = null;
            IPackageFragmentRoot sameProject = null;
            Vector<IPackageFragmentRoot> sourceRoots = new Vector<IPackageFragmentRoot>();
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1) {
                    IPackageFragment packFrag;
                    sourceRoots.addElement(roots[i]);
                    if (firstRoot == null) {
                        firstRoot = roots[i];
                    }
                    if (sameProject == null && roots[i].getJavaProject().equals(project)) {
                        sameProject = roots[i];
                    }
                    if ((packFrag = roots[i].getPackageFragment(pack)) != null && packFrag.exists()) {
                        return roots[i].getPackageFragment(pack);
                    }
                }
                ++i;
            }
            String projectName = project.getElementName();
            int i2 = 0;
            while (i2 < sourceRoots.size()) {
                IPackageFragmentRoot currRoot = (IPackageFragmentRoot)sourceRoots.elementAt(i2);
                if (projectName.equals(currRoot.getElementName())) {
                    return currRoot.createPackageFragment(pack, false, null);
                }
                ++i2;
            }
            if (sameProject != null) {
                return sameProject.createPackageFragment(pack, false, null);
            }
            if (firstRoot != null) {
                return firstRoot.createPackageFragment(pack, false, null);
            }
            IFolder folder = project.getProject().getFolder(project.getElementName());
            if (folder != null && !folder.exists()) {
                folder.create(false, true, null);
            }
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)folder);
            return root.createPackageFragment(pack, false, null);
        }
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        IPackageFragmentRoot matchingName = null;
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1 && roots[i].getElementName().equals(sfName)) {
                matchingName = roots[i];
                break;
            }
            ++i;
        }
        if (matchingName == null || !matchingName.exists()) {
            IProject proj = project.getProject();
            IFolder folder = proj.getFolder(sfName);
            if (folder == null || !folder.exists()) {
                folder.create(false, true, null);
            }
            matchingName = project.getPackageFragmentRoot((IResource)folder);
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
            IClasspathEntry[] cp = project.getRawClasspath();
            IClasspathEntry[] newCp = new IClasspathEntry[cp.length + 1];
            System.arraycopy(cp, 0, newCp, 0, cp.length);
            newCp[newCp.length - 1] = entry;
            project.setRawClasspath(newCp, null);
        }
        if ((frag = matchingName.getPackageFragment(pack)) == null || !frag.exists()) {
            matchingName.createPackageFragment(pack, true, null);
        }
        return frag;
    }

    public static IPackageFragment getDkPackageFragment(IJavaProject project, IJavaProject defaultProject, String pack) throws Exception {
        if (project != null && project.exists()) {
            IPackageFragment[] frags = project.getPackageFragments();
            int i = 0;
            while (i < frags.length) {
                if (pack.equals(frags[i].getElementName())) {
                    return frags[i];
                }
                ++i;
            }
        }
        SearchPattern pattern = SearchPattern.createPattern((String)pack, (int)2, (int)0, (int)0);
        IJavaElement[] elements = DeviceKitEclipseUtilities.collectSourceFoldersFromWorkspace();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (boolean)false);
        SearchEngine searchEngine = new SearchEngine();
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchParticipant[] participants = new SearchParticipant[]{participant};
        DkPackageSearchRequestor rq = new DkPackageSearchRequestor();
        searchEngine.search(pattern, participants, scope, (SearchRequestor)rq, null);
        IPackageFragment[] results = rq.getResults();
        if (results.length > 0) {
            return results[0];
        }
        System.out.checkError();
        return DeviceKitEclipseUtilities.getDkPackageFragement(project, pack, false, null);
    }

    public static IJavaProject getJavaProjectFromProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    public static IFile getManifest(IContainer resource) throws CoreException {
        IResource[] res = resource.members();
        int i = 0;
        while (i < res.length) {
            IFile file;
            if (res[i].getName().equals("META-INF")) {
                IFolder metaInf = (IFolder)res[i];
                return metaInf.getFile("MANIFEST.MF");
            }
            if (res[i] instanceof IContainer && (file = DeviceKitEclipseUtilities.getManifest((IContainer)res[i])) != null) {
                return file;
            }
            ++i;
        }
        return null;
    }
}

