/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.util.TransportComparer;
import org.eclipse.soda.devicekit.generator.util.TransportHolder;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;

public class PreGenElementHolder {
    private boolean exists = true;
    private String className;
    private DeviceKitTagModel model;
    private String pack;
    private int tagCode;
    private TransportComparer tc;
    private TransportHolder classInfo;
    private List methods;
    private List fields;
    private IJavaProject baseProject;

    public PreGenElementHolder(DeviceKitTagModel model, int tagCode, IJavaProject baseProject) {
        this.model = model;
        this.tagCode = tagCode;
        this.baseProject = baseProject;
        this.tc = new TransportComparer();
        try {
            this.getOriginalElements();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean exists() {
        return this.exists;
    }

    public TransportHolder getClassInfo() {
        return this.classInfo;
    }

    private String getClassName() {
        return this.className;
    }

    public List getFields() {
        return this.fields;
    }

    public List getMethods() {
        return this.methods;
    }

    private void getOriginalElements() throws Exception {
        Vector elements = this.model.getRoot().getAllChildrenWithTagCode(this.tagCode);
        if (elements.size() == 0) {
            return;
        }
        TagElement element = (TagElement)elements.elementAt(0);
        String packBase = element.getPackageBase();
        this.setClassName(DeviceKitUtilities.getClassNameFromTagElement(element));
        this.setPackage(DkUtilities.getPackageFromClassName(this.getClassName(), packBase));
        IType type = this.baseProject.findType(String.valueOf(this.pack) + '.' + this.className);
        if (type != null) {
            ICompilationUnit cu = type.getCompilationUnit();
            if (cu.exists()) {
                this.getOriginalElements(cu);
            } else {
                this.setExists(false);
            }
        } else {
            this.setExists(false);
        }
    }

    private void getOriginalElements(ICompilationUnit cu) throws Exception {
        IType type = cu.getType(this.getClassName());
        List fields = this.tc.getOriginalFields(type);
        this.setFields(fields);
        List methods = this.tc.getOriginalMethods(type);
        this.setMethods(methods);
        this.classInfo = new TransportHolder(type.getPackageFragment(), type.getElementName());
    }

    public List getOriginalFields() {
        return this.fields;
    }

    public List getOriginalMethods() {
        return this.methods;
    }

    private void setClassName(String className) {
        this.className = className;
    }

    private void setExists(boolean exists) {
        this.exists = exists;
    }

    public void setFields(List fields) {
        this.fields = fields;
    }

    public void setMethods(List methods) {
        this.methods = methods;
    }

    private void setPackage(String pack) {
        this.pack = pack;
    }
}

