/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.visitor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;

public class Visitor
extends ASTVisitor
implements Comparator {
    protected String[] references = null;
    private long thisCount = 0L;
    private long superCount = 0L;
    private long throwCount = 0L;
    private String logMember = "";
    protected CompilationUnit compilationUnitNode;
    protected TypeDeclaration typeDeclarationNode;
    private String source = "";
    private int current = 0;
    private boolean pseudo = false;
    protected boolean copyrightFound = false;
    private StringWriter stringWriter = new StringWriter();
    private PrintWriter printWriter = null;
    protected boolean endOfStatement = false;
    int indentLevel = 0;
    boolean newLine = true;
    private String packageName = "";

    public String addBlanks(String data) {
        StringBuffer buffer = new StringBuffer();
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (!last && upper) {
                buffer.append(' ');
            }
            buffer.append(character);
            last = upper;
            ++i;
        }
        return buffer.toString();
    }

    public void check(FieldDeclaration node) {
        boolean check = true;
        if (this.logMember.endsWith("Device") || this.logMember.endsWith("DeviceService")) {
            check = false;
        }
        if (check) {
            int modifiers = node.getModifiers();
            Iterator it = node.fragments().iterator();
            while (it.hasNext()) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
                SimpleName fieldSimpleName = f.getName();
                String simple = fieldSimpleName.getIdentifier();
                if (Modifier.isStatic((int)modifiers)) {
                    if (Modifier.isFinal((int)modifiers)) {
                        if (simple.toUpperCase().equals(simple)) continue;
                        this.logWarning("Code", "static final field not uppercase " + simple);
                        continue;
                    }
                    if (Character.isUpperCase(simple.charAt(0))) continue;
                    this.logWarning("Code", "static field first char not uppercase " + simple);
                    continue;
                }
                if (!Character.isUpperCase(simple.charAt(0))) continue;
                this.logWarning("Code", "field first char not lowercase " + simple);
            }
        }
    }

    public void checkCopyright(ASTNode node) {
        String comment = this.getMissingComments(node, true);
        int createYear = this.containsCopyright(comment);
        String copyright = GeneratorTemplates.getCopyrightCodeString(GeneratorTemplates.getTemplateVariables(createYear));
        if (comment.length() > 0) {
            boolean printComment = true;
            if (!this.copyrightFound) {
                if (createYear == -1) {
                    try {
                        this.println(copyright);
                        printComment = false;
                        this.copyrightFound = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.println(copyright);
                        this.copyrightFound = true;
                        printComment = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (printComment) {
                this.printComment(comment);
            }
        } else if (createYear == -1) {
            try {
                this.println(copyright);
                this.copyrightFound = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int compare(Object arg0, Object arg1) {
        int type1;
        ASTNode body0 = (ASTNode)arg0;
        ASTNode body1 = (ASTNode)arg1;
        int type0 = body0.getNodeType();
        if (type0 == (type1 = body1.getNodeType())) {
            switch (type0) {
                case 23: {
                    FieldDeclaration field0 = (FieldDeclaration)arg0;
                    FieldDeclaration field1 = (FieldDeclaration)arg1;
                    int mod0 = field0.getModifiers();
                    int mod1 = field1.getModifiers();
                    if (Modifier.isStatic((int)mod0)) {
                        if (Modifier.isStatic((int)mod1)) {
                            if (Modifier.isFinal((int)mod0)) {
                                return -1;
                            }
                            if (Modifier.isFinal((int)mod1)) {
                                return 1;
                            }
                        }
                        return -1;
                    }
                    if (Modifier.isStatic((int)mod1)) {
                        return 1;
                    }
                    return 0;
                }
                case 31: {
                    MethodDeclaration method0 = (MethodDeclaration)arg0;
                    MethodDeclaration method1 = (MethodDeclaration)arg1;
                    int mod0 = method0.getModifiers();
                    int mod1 = method1.getModifiers();
                    if (method0.isConstructor()) {
                        if (!method1.isConstructor()) {
                            return -1;
                        }
                    } else if (method1.isConstructor()) {
                        return 1;
                    }
                    if (Modifier.isStatic((int)mod0)) {
                        if (!Modifier.isStatic((int)mod1)) {
                            return -1;
                        }
                    } else if (Modifier.isStatic((int)mod1)) {
                        return 1;
                    }
                    return method0.getName().getIdentifier().compareTo(method1.getName().getIdentifier());
                }
            }
        } else {
            switch (type0) {
                case 28: 
                case 55: {
                    return -1;
                }
                case 31: {
                    if (type1 == 23) {
                        return 1;
                    }
                }
                case 23: {
                    if (type1 != 28) break;
                    return 1;
                }
                default: {
                    throw new RuntimeException(Integer.toString(type0));
                }
            }
            return -1;
        }
        return 0;
    }

    public int containsCopyright(String data) {
        int createYear = -1;
        int currentYear = Calendar.getInstance().get(1);
        String oldString = new String(data);
        StringTokenizer tokenizer = new StringTokenizer(oldString, " ,", true);
        String previousToken = "";
        while (tokenizer.hasMoreTokens()) {
            int temp;
            String createYearMaybe;
            String token = tokenizer.nextToken();
            String lcToken = token.toLowerCase();
            if ("copyright".equals(lcToken)) {
                createYear = 0;
            } else if (",".equals(token)) {
                try {
                    createYearMaybe = previousToken;
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("All".equals(token) || "IBM".equals(token)) {
                if (createYear < 1980) {
                    try {
                        createYearMaybe = previousToken;
                        temp = Integer.parseInt(createYearMaybe);
                        if (temp <= currentYear && temp > 1980) {
                            createYear = temp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if ("(c)".equals(token) && createYear < 1980) {
                try {
                    tokenizer.nextToken();
                    createYearMaybe = tokenizer.nextToken();
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (Exception exception) {}
            }
            if (lcToken.endsWith("*/")) break;
            if (" ".equals(token) || ",".equals(token)) continue;
            previousToken = token;
        }
        return createYear;
    }

    public StringWriter createStringWriter() {
        return new StringWriter(40960);
    }

    public void generateJavadoc(TypeDeclaration node, Hashtable table) {
        Vector vector;
        int size;
        this.println("\t/**");
        Object value = table.get("@lines");
        if (value instanceof Vector && (size = (vector = (Vector)value).size()) > 0) {
            int i = 0;
            while (i < size) {
                this.print("\t ");
                this.println(vector.elementAt(i));
                ++i;
            }
        }
        this.print("\t * @author ");
        this.println(DeviceKitPreferenceInitializer.getPreferenceString((String)"vendor"));
        this.print("\t * @version ");
        this.println(DeviceKitPreferenceInitializer.getPreferenceString((String)"version"));
        this.println("\t */");
    }

    public void generateJavadoc(MethodDeclaration node, Hashtable table) {
        Vector vector;
        int size;
        String propertyName = "";
        Type type = node.getReturnType();
        String typeName = type.toString();
        ITypeBinding btype = type.resolveBinding();
        if (btype != null) {
            typeName = btype.getName();
        }
        this.println("\t/**");
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        int numberParameters = node.parameters().size();
        boolean firstFlag = false;
        Object value = table.get("@lines");
        if (value instanceof Vector && (size = (vector = (Vector)value).size()) > 0) {
            firstFlag = true;
            int i = 0;
            while (i < size) {
                this.print("\t ");
                this.println(vector.elementAt(i));
                ++i;
            }
        }
        if (!firstFlag) {
            if (node.isConstructor()) {
                if (numberParameters == 0) {
                    this.println("\t * Constructs an instance of this class.");
                } else {
                    this.print("\t * Constructs an instance of this class from the specified ");
                    this.generateParameterList(node);
                    if (numberParameters == 1) {
                        this.println(" parameter.");
                    } else {
                        this.println(" parameters.");
                    }
                }
            } else {
                boolean output = false;
                switch (numberParameters) {
                    case 0: {
                        String betterName;
                        if (methodName.startsWith("get")) {
                            String betterName2;
                            if (typeName.equals("void")) break;
                            this.print("\t * Gets the ");
                            propertyName = betterName2 = this.parameterName(methodName.substring(3), false);
                            this.print(betterName2);
                            if (typeName.equals(methodName.substring(3))) {
                                this.println(" value.");
                            } else {
                                this.print(" (");
                                this.print(typeName);
                                this.println(") value.");
                            }
                            output = true;
                            break;
                        }
                        if (typeName.equals("boolean")) {
                            String betterName3;
                            if (methodName.startsWith("is")) {
                                String betterName4;
                                this.print("\t * Gets the ");
                                propertyName = betterName4 = this.parameterName(methodName.substring(2), false);
                                this.print(betterName4);
                                this.println(" (boolean) value.");
                                output = true;
                                break;
                            }
                            if (!methodName.startsWith("has")) break;
                            this.print("\t * Gets the ");
                            propertyName = betterName3 = this.parameterName(methodName.substring(3), false);
                            this.print(betterName3);
                            this.println(" (boolean) value.");
                            output = true;
                            break;
                        }
                        if (!methodName.startsWith("to")) break;
                        this.print("\t * Returns the ");
                        propertyName = betterName = this.parameterName(methodName.substring(2), false);
                        this.print(betterName);
                        if (typeName.equals(methodName.substring(2))) {
                            this.println(" value.");
                        } else {
                            this.print(" (");
                            this.print(typeName);
                            this.println(") value.");
                        }
                        output = true;
                        break;
                    }
                    case 1: {
                        String betterName;
                        if (!methodName.startsWith("set")) break;
                        this.print("\t * Sets the ");
                        propertyName = betterName = this.parameterName(methodName.substring(3), false);
                        this.print(betterName);
                        this.println(" value.");
                        output = true;
                        break;
                    }
                }
                if (!output) {
                    this.print("\t * ");
                    String bmethod = this.methodName(methodName, true);
                    this.print(bmethod);
                    if (numberParameters > 0) {
                        this.print(" with the specified ");
                        this.generateParameterList(node);
                        if (numberParameters == 1) {
                            this.print(" parameter");
                        } else {
                            this.print(" parameters");
                        }
                    }
                    if (!"void".equals(typeName)) {
                        this.print(" and return the ");
                        this.print(typeName);
                        this.print(" result");
                    }
                    this.println(".");
                }
            }
        }
        value = table.get("@param");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            SimpleName parameterName = v.getName();
            value = table.get(parameterName.getIdentifier());
            if (value != null) continue;
            this.print("\t * @param\t");
            Type ptype = v.getType();
            String ptypeName = ptype.toString();
            ITypeBinding brtype = ptype.resolveBinding();
            if (brtype != null) {
                ptypeName = brtype.getName();
            }
            this.print(parameterName.getIdentifier());
            this.print('\t');
            String betterName = this.parameterName(parameterName.toString(), false);
            this.print("The ");
            this.print(betterName);
            this.print(" (<code>");
            this.print(ptypeName);
            this.print("</code>) parameter");
            this.print('.');
            this.println();
        }
        value = table.get("@return");
        if (!node.isConstructor() && !"void".equals(typeName) && value == null) {
            this.print("\t * @return\t");
            if (propertyName.length() > 0) {
                this.print("The ");
                this.print(propertyName);
                this.print(" (<code>");
                this.print(typeName);
                this.print("</code>) value");
            } else {
                this.print("Results of the ");
                String bmethod = this.methodName(methodName, false);
                this.print(bmethod);
                this.print(" (<code>");
                this.print(typeName);
                this.print("</code>) value");
            }
            this.print('.');
            this.println();
        }
        if ((value = table.get("@throws")) == null && !node.thrownExceptions().isEmpty()) {
            it = node.thrownExceptions().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                String exceptionName = n.toString();
                IBinding etype = n.resolveBinding();
                if (etype != null) {
                    exceptionName = etype.getName();
                }
                this.print("\t * @throws\t");
                this.print(exceptionName);
                String betterName = this.addBlanks(exceptionName);
                if (!betterName.equals(exceptionName)) {
                    this.print(' ');
                    this.print(betterName);
                }
                this.print('.');
                this.println();
            }
        }
        if ((value = table.get("@see")) == null) {
            this.generateSee(node);
        }
        this.println("\t */");
    }

    public void generateJavadoc(FieldDeclaration node, Hashtable table) {
        int tsize = table.size();
        this.println("\t/**");
        if (tsize == 0) {
            Type type = node.getType();
            String typeName = type.toString();
            ITypeBinding btype = type.resolveBinding();
            if (btype != null) {
                typeName = btype.getName();
            }
            if (!"void".equals(typeName)) {
                int modifiers = node.getModifiers();
                this.print("\t * Define the ");
                Iterator it = node.fragments().iterator();
                while (it.hasNext()) {
                    VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
                    SimpleName fieldSimpleName = f.getName();
                    String simple = fieldSimpleName.getIdentifier();
                    String betterName = this.parameterName(simple, false);
                    this.print(betterName);
                    if (it.hasNext()) {
                        this.print(", ");
                    }
                    if (Modifier.isStatic((int)modifiers)) {
                        if (Modifier.isFinal((int)modifiers)) {
                            if (simple.toUpperCase().equals(simple)) continue;
                            this.logWarning("Code", "static final field not uppercase " + simple);
                            continue;
                        }
                        if (Character.isUpperCase(simple.charAt(0))) continue;
                        this.logWarning("Code", "static field first char not uppercase " + simple);
                        continue;
                    }
                    if (!Character.isUpperCase(simple.charAt(0))) continue;
                    this.logWarning("Code", "field first char not lowercase " + simple);
                }
                this.print(" (");
                this.print(typeName);
                this.print(") ");
                if (Modifier.isStatic((int)modifiers) && Modifier.isFinal((int)modifiers)) {
                    this.print("constant.");
                } else {
                    this.print("field.");
                }
                this.println();
            }
        } else {
            int modifiers;
            Vector vector;
            int size;
            Object value = table.get("@lines");
            if (value instanceof Vector && (size = (vector = (Vector)value).size()) > 0) {
                int i = 0;
                while (i < size) {
                    this.print("\t ");
                    this.println(vector.elementAt(i));
                    ++i;
                }
            }
            if (Modifier.isStatic((int)(modifiers = node.getModifiers()))) {
                Modifier.isFinal((int)modifiers);
            }
        }
        this.println("\t */");
    }

    public void generateParameterList(MethodDeclaration node) {
        int size = node.parameters().size();
        int i = 0;
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            SimpleName parameterName = v.getName();
            if (i > 0) {
                if (i == size - 1) {
                    this.print(" and ");
                } else {
                    this.print(", ");
                }
            }
            String betterName = this.parameterName(parameterName.toString(), false);
            this.print(betterName);
            ++i;
        }
    }

    public void generateSee(MethodDeclaration node) {
        TypeDeclaration type = this.getTypeDeclarationNode();
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        String endingName = this.getEnding(methodName);
        List list = type.bodyDeclarations();
        int size = list.size();
        BodyDeclaration[] bd = new BodyDeclaration[size];
        list.toArray(bd);
        Arrays.sort(bd, this);
        int i = 0;
        while (i < size) {
            BodyDeclaration d = bd[i];
            if (d instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)d;
                if (!d.equals((Object)node) && !this.isPrivate(methodDeclaration.getModifiers())) {
                    SimpleName simpleMethodNameNode = methodDeclaration.getName();
                    String methodNameNode = simpleMethodNameNode.getIdentifier();
                    if (methodName.equals(methodNameNode)) {
                        this.print("\t * @see\t\t#");
                        this.generateSeeReference(methodDeclaration);
                        this.println();
                    } else if (endingName.length() > 0 && methodNameNode.endsWith(endingName)) {
                        this.print("\t * @see\t\t#");
                        this.generateSeeReference(methodDeclaration);
                        this.println();
                    }
                }
            }
            ++i;
        }
    }

    public void generateSeeReference(MethodDeclaration node) {
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        this.print(methodName);
        this.print('(');
        int count = 0;
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            Type ptype = v.getType();
            String ptypeName = ptype.toString();
            ITypeBinding brtype = ptype.resolveBinding();
            if (brtype != null) {
                ptypeName = brtype.getName();
            }
            if (count > 0) {
                this.print(',');
            }
            this.print(ptypeName);
            ++count;
        }
        this.print(')');
    }

    public CompilationUnit getCompilationUnitNode() {
        return this.compilationUnitNode;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getEnding(String data) {
        StringBuffer buffer = new StringBuffer();
        boolean found = false;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (found || upper) {
                buffer.append(character);
                found = true;
            }
            ++i;
        }
        return buffer.toString();
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    protected Hashtable getJavadocLines(String data) {
        Vector<String> first = new Vector<String>();
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        Vector<String> vector = new Vector<String>(20);
        StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
        int lineNumber = 0;
        boolean firstFlag = true;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            boolean add = true;
            if (token.equals("*") || token.equals("*/") || token.equals("/**") || token.equals("* @return")) {
                add = false;
            } else if (token.equals("* To change the template for this generated type comment go to") || token.equals("* Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments")) {
                add = false;
            } else if (token.startsWith("* @return") || token.startsWith("* @param") || token.startsWith("* @version") || token.startsWith("* @author") || token.startsWith("* @throws")) {
                firstFlag = false;
                StringTokenizer tokenizerLine = new StringTokenizer(token, " \t");
                int count = tokenizerLine.countTokens();
                if (count > 2) {
                    tokenizerLine.nextToken();
                    String type = tokenizerLine.nextToken();
                    String value = tokenizerLine.nextToken();
                    table.put(type, value);
                    if ("@param".equals(type)) {
                        table.put(value, value);
                    }
                }
                if (count <= 3) {
                    add = false;
                }
            } else if (token.startsWith("* @see")) {
                String seeReference;
                int index = token.indexOf(32, 4);
                add = false;
                if (index > 0 && !(seeReference = token.substring(index).trim()).startsWith("#")) {
                    add = true;
                }
            } else if (token.startsWith("* @value")) {
                add = false;
            } else if (token.endsWith(" method comment.")) {
                add = false;
            }
            if (!add) continue;
            if (firstFlag) {
                first.addElement(token);
            }
            vector.addElement(token);
            if (lineNumber == 0 && token.indexOf(46) == -1) {
                this.logWarning("Javadoc", "Bad first javadoc line.");
            }
            ++lineNumber;
        }
        if (vector.size() == 0) {
            return new Hashtable();
        }
        table.put("@lines", vector);
        table.put("@first", first);
        return table;
    }

    protected String getMissingComments(ASTNode node, boolean update) {
        int current;
        String comment = "";
        int start = node.getStartPosition();
        if (start - (current = this.getCurrent()) > 5) {
            comment = this.getSource().substring(current, start);
        }
        if (update) {
            this.setCurrent(start + node.getLength());
        } else {
            this.setCurrent(start);
        }
        return comment;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public PrintWriter getPrintWriter() {
        if (this.printWriter == null) {
            this.stringWriter = this.createStringWriter();
            this.printWriter = new PrintWriter(this.stringWriter);
        }
        return this.printWriter;
    }

    public String getPropertyName(String name) {
        char[] characters = name.toCharArray();
        if (characters.length > 0) {
            characters[0] = Character.toLowerCase(characters[0]);
            return new String(characters);
        }
        return name;
    }

    public String[] getReferences() {
        return this.references;
    }

    public String getSource() {
        return this.source;
    }

    public StringWriter getStringWriter() {
        return this.stringWriter;
    }

    public long getSuperCount() {
        return this.superCount;
    }

    public long getThisCount() {
        return this.thisCount;
    }

    public long getThrowCount() {
        return this.throwCount;
    }

    public TypeDeclaration getTypeDeclarationNode() {
        return this.typeDeclarationNode;
    }

    public void indent() {
        ++this.indentLevel;
    }

    protected boolean isAbstract(int modifiers) {
        return Modifier.isAbstract((int)modifiers);
    }

    protected boolean isPrivate(int modifiers) {
        return Modifier.isPrivate((int)modifiers);
    }

    public boolean isPseudo() {
        return this.pseudo;
    }

    protected boolean isStatic(int modifiers) {
        return Modifier.isStatic((int)modifiers);
    }

    public void logWarning(String type, String message) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("Warning: ");
        buffer.append(type);
        buffer.append(' ');
        buffer.append(this.logMember);
        buffer.append(' ');
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    public String methodName(String data, boolean caps) {
        StringBuffer buffer = new StringBuffer();
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (!last && upper) {
                buffer.append(' ');
            }
            if (i > 0 || !caps) {
                buffer.append(Character.toLowerCase(character));
            } else {
                buffer.append(Character.toUpperCase(character));
            }
            last = upper;
            ++i;
        }
        return buffer.toString();
    }

    public String parameterName(String data, boolean caps) {
        StringBuffer buffer = new StringBuffer();
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (!last && upper) {
                buffer.append(' ');
            }
            if (character != '_') {
                if (i > 0 || !caps) {
                    buffer.append(Character.toLowerCase(character));
                } else {
                    buffer.append(Character.toUpperCase(character));
                }
            }
            last = upper;
            ++i;
        }
        return buffer.toString();
    }

    public void print(char character) {
        this.printIndent();
        this.getPrintWriter().print(character);
        this.endOfStatement = false;
    }

    public void print(String data) {
        this.printIndent();
        this.getPrintWriter().print(data);
        this.endOfStatement = false;
    }

    public void print(Object data) {
        this.printIndent();
        this.getPrintWriter().print(String.valueOf(data));
        this.endOfStatement = false;
    }

    public void printComment(String data) {
        this.print(data);
    }

    public void printEndOfStatement() {
        this.print(";");
        this.endOfStatement = true;
    }

    public void printEndOfStatementLine() {
        this.println(";");
        this.endOfStatement = true;
    }

    public void printIndent() {
        if (this.newLine) {
            int i = 0;
            while (i < this.indentLevel) {
                this.printRaw('\t');
                ++i;
            }
            this.newLine = false;
        }
    }

    protected void printJavadoc(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            if (token.equals("*")) continue;
            this.printIndent();
            if (token.startsWith("*")) {
                this.print(' ');
            }
            this.println(token);
        }
    }

    public void printKeyword(String data) {
        this.print(data);
    }

    protected void printLiteral(String string) {
        this.print(string);
    }

    protected void printMethod(String string) {
        this.print(string);
    }

    void printModifiers(int modifiers) {
        this.printIndent();
        if (Modifier.isPublic((int)modifiers)) {
            this.printKeyword("public ");
        }
        if (Modifier.isProtected((int)modifiers)) {
            this.printKeyword("protected ");
        }
        if (Modifier.isPrivate((int)modifiers)) {
            this.printKeyword("private ");
        }
        if (Modifier.isStatic((int)modifiers)) {
            this.printKeyword("static ");
        }
        if (Modifier.isAbstract((int)modifiers)) {
            this.printKeyword("abstract ");
        }
        if (Modifier.isFinal((int)modifiers)) {
            this.printKeyword("final ");
        }
        if (Modifier.isSynchronized((int)modifiers)) {
            this.printKeyword("synchronized ");
        }
        if (Modifier.isVolatile((int)modifiers)) {
            this.printKeyword("volatile ");
        }
        if (Modifier.isNative((int)modifiers)) {
            this.printKeyword("native ");
        }
        if (Modifier.isStrictfp((int)modifiers)) {
            this.printKeyword("strictfp ");
        }
        if (Modifier.isTransient((int)modifiers)) {
            this.printKeyword("transient ");
        }
    }

    public void printPackage(String data) {
        this.print(data);
    }

    public void printRaw(char character) {
        this.getPrintWriter().print(character);
        this.endOfStatement = false;
    }

    public void printSpace() {
        this.print(' ');
    }

    public void printType(String data) {
        this.print(data);
    }

    public void printType(String data, String packageName) {
        this.print(data);
    }

    protected void printVariable(String string) {
        this.print(string);
    }

    public void println(String data) {
        this.printIndent();
        this.getPrintWriter().println(data);
        this.endOfStatement = false;
        this.newLine = true;
    }

    public void println(Object data) {
        this.printIndent();
        this.getPrintWriter().println(String.valueOf(data));
        this.endOfStatement = false;
        this.newLine = true;
    }

    public void println() {
        this.printIndent();
        this.getPrintWriter().println();
        this.endOfStatement = false;
        this.newLine = true;
    }

    public void setCompilationUnitNode(CompilationUnit unit) {
        this.compilationUnitNode = unit;
    }

    public void setCurrent(int start) {
        this.current = start;
    }

    public void setCurrent(ASTNode node) {
        this.setCurrent(node.getStartPosition());
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setLogMember(MethodDeclaration node) {
        StringBuffer buffer = new StringBuffer(200);
        if (this.typeDeclarationNode != null) {
            buffer.append(this.typeDeclarationNode.getName().getIdentifier());
            buffer.append('.');
        }
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        buffer.append(methodName);
        buffer.append('(');
        int index = 0;
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            Type ptype = v.getType();
            String ptypeName = ptype.toString();
            ITypeBinding brtype = ptype.resolveBinding();
            if (brtype != null) {
                ptypeName = brtype.getName();
            }
            if (index > 0) {
                buffer.append(',');
            }
            buffer.append(ptypeName);
            ++index;
        }
        buffer.append(')');
        this.logMember = buffer.toString();
    }

    public void setLogMember(TypeDeclaration node) {
        StringBuffer buffer = new StringBuffer(200);
        if (node != null) {
            buffer.append(node.getName().getIdentifier());
        }
        this.logMember = buffer.toString();
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setPseudo(boolean pseudo) {
        this.pseudo = pseudo;
    }

    public void setReferences(String[] set) {
        this.references = set;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setStringWriter(StringWriter stringWriter) {
        this.stringWriter = stringWriter;
    }

    public void setSuperCount(long superCount) {
        this.superCount = superCount;
    }

    public void setThisCount(long l) {
        this.thisCount = l;
    }

    public void setThrowCount(long l) {
        this.throwCount = l;
    }

    public void setTypeDeclarationNode(TypeDeclaration declaration) {
        this.typeDeclarationNode = declaration;
    }

    public String toString() {
        return this.getStringWriter().toString();
    }

    public void unindent() {
        --this.indentLevel;
    }

    protected boolean updateMissingComments(ASTNode node, boolean update) {
        int current;
        boolean result = false;
        int start = node.getStartPosition();
        if (start - (current = this.getCurrent()) > 5) {
            String comment = this.getSource().substring(current, start);
            if (comment.startsWith("/*") || comment.startsWith("\r\n/*")) {
                this.printComment(comment);
            } else {
                this.print(comment);
            }
            result = true;
        }
        if (update) {
            this.setCurrent(start + node.getLength());
        } else {
            this.setCurrent(start);
        }
        return result;
    }

    public void updateSuperCount() {
        ++this.superCount;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.print('{');
        Iterator it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration b = (BodyDeclaration)it.next();
            b.accept((ASTVisitor)this);
        }
        this.print('}');
        return false;
    }

    public boolean visit(ArrayAccess node) {
        node.getArray().accept((ASTVisitor)this);
        this.print('[');
        node.getIndex().accept((ASTVisitor)this);
        this.print(']');
        return false;
    }

    public boolean visit(ArrayCreation node) {
        this.print("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept((ASTVisitor)this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.print('[');
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            this.print(']');
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.print("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        this.print('{');
        boolean first = true;
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            if (!first) {
                this.print(", ");
            }
            first = false;
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        this.print('}');
        return false;
    }

    public boolean visit(ArrayType node) {
        node.getComponentType().accept((ASTVisitor)this);
        this.print("[]");
        return false;
    }

    public boolean visit(AssertStatement node) {
        this.printKeyword("assert ");
        node.getExpression().accept((ASTVisitor)this);
        if (node.getMessage() != null) {
            this.print(" : ");
            node.getMessage().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept((ASTVisitor)this);
        this.printSpace();
        this.print(node.getOperator().toString());
        this.printSpace();
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Block node) {
        this.println(" {");
        this.indent();
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept((ASTVisitor)this);
        }
        this.unindent();
        this.printIndent();
        this.println("}");
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.printKeyword("true");
        } else {
            this.printKeyword("false");
        }
        return false;
    }

    public boolean visit(BreakStatement node) {
        this.printKeyword("break");
        if (node.getLabel() != null) {
            this.print(' ');
            node.getLabel().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(CastExpression node) {
        this.print('(');
        node.getType().accept((ASTVisitor)this);
        this.print(')');
        node.getExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CatchClause node) {
        this.printKeyword("catch ");
        this.print('(');
        int modifiers = node.getException().getModifiers();
        if (!Modifier.isFinal((int)modifiers)) {
            this.printKeyword("final ");
        }
        node.getException().accept((ASTVisitor)this);
        this.print(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        this.print(node.getEscapedValue());
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("new ");
        node.getName().accept((ASTVisitor)this);
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(CompilationUnit node) {
        ImportDeclaration d;
        this.compilationUnitNode = node;
        if (node.getPackage() != null) {
            node.getPackage().accept((ASTVisitor)this);
        }
        Iterator it = node.imports().iterator();
        while (it.hasNext()) {
            d = (ImportDeclaration)it.next();
            d.accept((ASTVisitor)this);
        }
        it = node.types().iterator();
        while (it.hasNext()) {
            d = (TypeDeclaration)it.next();
            d.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept((ASTVisitor)this);
        this.print("?");
        node.getThenExpression().accept((ASTVisitor)this);
        this.print(":");
        node.getElseExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        this.print("this(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.println(");");
        return false;
    }

    public boolean visit(ContinueStatement node) {
        this.printKeyword("continue");
        if (node.getLabel() != null) {
            this.print(' ');
            node.getLabel().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(DoStatement node) {
        this.printKeyword("do ");
        node.getBody().accept((ASTVisitor)this);
        this.printKeyword(" while ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.println(");");
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.logWarning("Code", "Empty statement");
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(FieldAccess node) {
        node.getExpression().accept((ASTVisitor)this);
        this.print('.');
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        boolean comments = false;
        this.check(node);
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        if (node.getJavadoc() != null) {
            Hashtable table = this.getJavadocLines(node.getJavadoc().getComment());
            this.generateJavadoc(node, table);
        } else if (!comments) {
            this.generateJavadoc(node, new Hashtable());
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(ForStatement node) {
        Expression e;
        Iterator it;
        this.printKeyword("for ");
        this.print('(');
        if (node.initializers().size() > 0) {
            it = node.initializers().iterator();
            while (it.hasNext()) {
                e = (Expression)it.next();
                e.accept((ASTVisitor)this);
            }
            if (!this.endOfStatement) {
                this.printEndOfStatement();
                this.print(' ');
            }
        } else {
            this.printEndOfStatement();
            this.print(' ');
        }
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.printEndOfStatement();
        this.print(' ');
        it = node.updaters().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        this.print(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(IfStatement node) {
        this.printKeyword("if ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        node.getThenStatement().accept((ASTVisitor)this);
        if (node.getElseStatement() != null) {
            this.printKeyword(" else ");
            node.getElseStatement().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        if (!this.copyrightFound) {
            this.checkCopyright((ASTNode)node);
        }
        this.printKeyword("import ");
        if (node.isOnDemand()) {
            Name name = node.getName();
            if (name.isSimpleName()) {
                this.printPackage(((SimpleName)name).getIdentifier());
            } else {
                name.accept((ASTVisitor)this);
            }
            this.print(".*");
        } else {
            Name name = node.getName();
            if (name.isSimpleName()) {
                this.printType(((SimpleName)name).getIdentifier());
            } else {
                this.printPackage(((QualifiedName)name).getQualifier().toString());
                this.print('.');
                this.printType(((QualifiedName)name).getName().getIdentifier());
            }
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.print(' ');
        this.print(node.getOperator().toString());
        this.print(' ');
        node.getRightOperand().accept((ASTVisitor)this);
        Iterator it = node.extendedOperands().iterator();
        while (it.hasNext()) {
            this.print(node.getOperator().toString());
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.printKeyword(" instanceof ");
        node.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Initializer node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.getModifiers());
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Javadoc node) {
        this.printIndent();
        this.printJavadoc(node.getComment());
        return false;
    }

    public boolean visit(LabeledStatement node) {
        node.getLabel().accept((ASTVisitor)this);
        this.print(": ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        TypeDeclaration type;
        ASTNode parent;
        long thisCount = this.getThisCount();
        long throwCount = this.getThrowCount();
        long superCount = this.getSuperCount();
        boolean setMethod = false;
        this.setLogMember(node);
        boolean comments = false;
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        if (node.getJavadoc() != null) {
            Hashtable table = this.getJavadocLines(node.getJavadoc().getComment());
            this.generateJavadoc(node, table);
        } else if (!comments) {
            this.generateJavadoc(node, new Hashtable());
        }
        int modifiers = node.getModifiers();
        if (node.isConstructor() && Modifier.isPublic((int)modifiers) && (parent = node.getParent()) instanceof TypeDeclaration && Modifier.isAbstract((int)(type = (TypeDeclaration)parent).getModifiers())) {
            modifiers = modifiers ^ 1 | 4;
        }
        this.printModifiers(modifiers);
        if (!node.isConstructor()) {
            node.getReturnType().accept((ASTVisitor)this);
            this.print(' ');
        }
        node.getName().accept((ASTVisitor)this);
        String methodName = node.getName().getIdentifier();
        if (methodName.startsWith("set")) {
            if (node.parameters().size() == 1) {
                String propertyName;
                SingleVariableDeclaration v = (SingleVariableDeclaration)node.parameters().get(0);
                String name = v.getName().getIdentifier();
                if (!name.equals(propertyName = this.getPropertyName(methodName.substring(3)))) {
                    this.logWarning("Code", "Bad set parameter name " + name + " should be " + propertyName);
                }
                setMethod = true;
            }
        } else if (methodName.startsWith("get")) {
            node.parameters().size();
        }
        this.print('(');
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        boolean throwsFlag = false;
        if (!node.thrownExceptions().isEmpty()) {
            throwsFlag = true;
            this.printKeyword(" throws ");
            Iterator it2 = node.thrownExceptions().iterator();
            while (it2.hasNext()) {
                Name n = (Name)it2.next();
                n.accept((ASTVisitor)this);
                if (!it2.hasNext()) continue;
                this.print(", ");
            }
            this.print(' ');
        }
        boolean abstractFlag = false;
        if (node.getBody() == null) {
            this.printEndOfStatementLine();
            abstractFlag = true;
        } else if (this.isPseudo()) {
            this.println(" {");
            this.println("   /* No Source */}");
        } else {
            node.getBody().accept((ASTVisitor)this);
        }
        if (this.typeDeclarationNode != null) {
            abstractFlag = this.typeDeclarationNode.isInterface();
        }
        if (!abstractFlag) {
            if (!this.isStatic(node.getModifiers()) && !this.isAbstract(node.getModifiers()) && setMethod && thisCount == this.getThisCount() && superCount == this.getSuperCount()) {
                this.logWarning("Code", "No references to this or super in method.");
            }
            if (!throwsFlag && throwCount != this.getThrowCount()) {
                this.logWarning("Code", "Missing throws on method declaration.");
            }
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.print('.');
        }
        node.getName().accept((ASTVisitor)this);
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.print("null");
        return false;
    }

    public boolean visit(NumberLiteral node) {
        this.print(node.getToken());
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        String packageName;
        String comment = this.getMissingComments((ASTNode)node, true);
        this.printKeyword("package ");
        Name name = node.getName();
        if (name instanceof SimpleName) {
            packageName = ((SimpleName)name).getIdentifier();
            this.setPackageName(packageName);
            this.printPackage(packageName);
        } else {
            if (name instanceof QualifiedName) {
                packageName = ((QualifiedName)name).getFullyQualifiedName();
                this.setPackageName(packageName);
            }
            name.accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        if (comment.length() > 0) {
            int createYear = this.containsCopyright(comment);
            if (createYear > -1) {
                try {
                    this.println(GeneratorTemplates.getCopyrightCodeString(GeneratorTemplates.getTemplateVariables(createYear)));
                    this.copyrightFound = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.println(comment);
            }
        }
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(')');
        return false;
    }

    public boolean visit(PostfixExpression node) {
        node.getOperand().accept((ASTVisitor)this);
        this.print(node.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression node) {
        this.print(node.getOperator().toString());
        node.getOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.printKeyword(node.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(QualifiedName node) {
        Name qname = node.getQualifier();
        qname.accept((ASTVisitor)this);
        this.print('.');
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.printKeyword("return");
        if (node.getExpression() != null) {
            this.print(' ');
            node.getExpression().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(SimpleName node) {
        IPackageBinding packageBinding;
        ITypeBinding typeBinding = node.resolveTypeBinding();
        if (typeBinding != null && (packageBinding = typeBinding.getPackage()) != null) {
            this.printType(node.getIdentifier(), packageBinding.getName());
            return false;
        }
        IBinding binding = node.resolveBinding();
        if (binding != null) {
            switch (binding.getKind()) {
                case 4: {
                    this.printMethod(binding.getName());
                    return false;
                }
                case 3: {
                    this.printVariable(node.getIdentifier());
                    return false;
                }
            }
        }
        this.print(node.getIdentifier());
        return false;
    }

    public boolean visit(SimpleType node) {
        ITypeBinding type = node.getName().resolveTypeBinding();
        if (!type.isTopLevel()) {
            this.printType(type.getDeclaringClass().getName());
            this.print('.');
            this.printType(type.getName());
        } else {
            this.printType(type.getName());
        }
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        node.getName().accept((ASTVisitor)this);
        if (node.getInitializer() != null) {
            this.print("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.printLiteral(node.getEscapedValue());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.updateSuperCount();
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("super");
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.println(");");
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        this.updateSuperCount();
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("super.");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        this.updateSuperCount();
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.print('.');
        }
        this.print("super.");
        node.getName().accept((ASTVisitor)this);
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        return false;
    }

    public boolean visit(SwitchCase node) {
        if (node.isDefault()) {
            this.printKeyword("default");
        } else {
            this.printKeyword("case ");
            node.getExpression().accept((ASTVisitor)this);
        }
        this.print(": ");
        return false;
    }

    public boolean visit(SwitchStatement node) {
        this.printKeyword("switch ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        this.print('{');
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept((ASTVisitor)this);
        }
        this.print('}');
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        this.printKeyword("synchronized ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("this");
        ++this.thisCount;
        return false;
    }

    public boolean visit(ThrowStatement node) {
        this.printKeyword("throw ");
        node.getExpression().accept((ASTVisitor)this);
        this.printEndOfStatementLine();
        ++this.throwCount;
        return false;
    }

    public boolean visit(TryStatement node) {
        this.print("try ");
        node.getBody().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.catchClauses().iterator();
        while (it.hasNext()) {
            CatchClause cc = (CatchClause)it.next();
            cc.accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            this.print(" finally ");
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.setLogMember(node);
        this.typeDeclarationNode = node;
        if (!this.copyrightFound) {
            this.checkCopyright((ASTNode)node);
        }
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        if (node.getJavadoc() != null) {
            Hashtable table = this.getJavadocLines(node.getJavadoc().getComment());
            this.generateJavadoc(node, table);
        } else {
            this.generateJavadoc(node, new Hashtable());
        }
        this.printModifiers(node.getModifiers());
        this.printKeyword(node.isInterface() ? "interface " : "class ");
        node.getName().accept((ASTVisitor)this);
        this.print(' ');
        if (node.getSuperclass() != null) {
            this.printKeyword("extends ");
            node.getSuperclass().accept((ASTVisitor)this);
            this.print(' ');
        }
        if (!node.superInterfaces().isEmpty()) {
            this.printKeyword(node.isInterface() ? "extends " : "implements ");
            Iterator it = node.superInterfaces().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.print(", ");
            }
            this.print(' ');
        }
        this.println(" {");
        this.indent();
        List list = node.bodyDeclarations();
        int size = list.size();
        ASTNode[] bd = new ASTNode[size];
        list.toArray(bd);
        Arrays.sort(bd, this);
        int i = 0;
        while (i < size) {
            ASTNode d = bd[i];
            if (i == 0) {
                this.setCurrent(d.getStartPosition());
            }
            d.accept((ASTVisitor)this);
            ++i;
        }
        this.unindent();
        this.println();
        this.printIndent();
        this.println("}");
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        node.getTypeDeclaration().accept((ASTVisitor)this);
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(TypeLiteral node) {
        Type type = node.getType();
        type.accept((ASTVisitor)this);
        this.printKeyword(".class");
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept((ASTVisitor)this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.print("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.print(" = ");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.printKeyword("while ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }
}

