/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.bundle;

import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.service.log.LogService;

public abstract class DeviceBundle
extends BaseBundleActivator
implements BundleActivator {
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    private TransportService transport = null;
    private DeviceService device;

    public void activate() {
        NotificationService notificationService;
        TransportService transport = this.getTransport();
        if (this.device == null) {
            this.setDevice(this.createService(transport));
            if (this.device != null) {
                Hashtable properties = this.createProperties();
                String[] names = this.getExportedServiceNames();
                this.addExportedServices(names, this.device, properties);
            }
        } else {
            this.device.setTransport(transport);
        }
        if ((notificationService = (NotificationService)this.getOptionalImportedService("org.eclipse.soda.dk.notification.service.NotificationService")) != null) {
            this.device.setNotificationService(notificationService);
        }
        this.device.start();
    }

    public Hashtable createProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(37);
        properties.put("id", "#");
        return properties;
    }

    public abstract DeviceService createService(TransportService var1);

    protected void deactivate() {
        DeviceService device = this.getDevice();
        if (device != null) {
            device.exit();
            this.setDevice(null);
        }
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public abstract String[] getExportedServiceNames();

    public String getInterestServiceName() {
        return "";
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICES;
    }

    public TransportService getTransport() {
        if (this.transport == null) {
            return (TransportService)this.getImportedService(this.getInterestServiceName());
        }
        return this.transport;
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        if (this.device != null && service instanceof NotificationService) {
            this.device.setNotificationService((NotificationService)service);
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        if (this.device != null && service instanceof NotificationService) {
            this.device.setNotificationService(null);
        }
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable exception) {
        LogService logService = EscObject.getDefaultLogService();
        logService.log(severity, message, exception);
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }

    public void setTransport(TransportService transport) {
        this.transport = transport;
    }
}

