/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.samples.extension;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soda.devicekit.ui.samples.SampleConstants;
import org.eclipse.soda.devicekit.ui.samples.SamplePlugin;
import org.eclipse.soda.devicekit.ui.samples.extension.WizardContent;
import org.eclipse.soda.devicekit.ui.samples.extension.project.EclipseProject;

public class WizardContentLoader
implements SampleConstants {
    private List entries = new ArrayList();

    private boolean isInstalled(WizardContent wizardContent) {
        EclipseProject[] projects = wizardContent.getEclipseProjects();
        if (projects == null || projects.length == 0) {
            return true;
        }
        int i = 0;
        while (i < projects.length) {
            IProject project;
            String projectName = projects[i].getProjectName();
            if (!"".equals(projectName) && (project = SamplePlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void loadExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if ("wizardcontent".equals(elements[i].getName())) {
                try {
                    this.loadWizardContent(elements[i]);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public WizardContent[] loadWizardContent(String wizardId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.soda.devicekit.ui.samples.wizardcontent");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.loadExtension(extensions[i]);
            ++i;
        }
        WizardContent[] result = new WizardContent[this.entries.size()];
        this.entries.toArray(result);
        return result;
    }

    private void loadWizardContent(IConfigurationElement element) throws IOException, MalformedURLException {
        WizardContent content = new WizardContent();
        String wizard = element.getAttribute("wizard");
        String group = element.getAttribute("group");
        String primary = element.getAttribute("primary");
        String directory = element.getAttribute("directory");
        URL url = FileLocator.resolve((URL)Platform.getBundle((String)element.getContributor().getName()).getEntry("/"));
        content.setWizard(wizard);
        content.setGroup(group);
        content.setPrimary(Boolean.valueOf(primary));
        content.setDirectory(url, directory);
        content.setInstalled(this.isInstalled(content));
        this.entries.add(content);
    }
}

