/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.samples.wizard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soda.devicekit.ui.samples.SamplePlugin;
import org.eclipse.soda.devicekit.ui.samples.extension.WizardContent;
import org.eclipse.soda.devicekit.ui.samples.wizard.ZipInputStreamWrapper;
import org.eclipse.swt.widgets.Shell;

public class ZipToProjectOperation
implements IWorkspaceRunnable {
    public static final int DELETE_PROJECT = 0;
    public static final int DELETE_ALL_PROJECTS = 1;
    public static final int DONT_DELETE_PROJECT = 2;
    public static final int CANCEL_OPERATION = 3;
    private IWorkspaceRoot wsRoot;
    private IProgressMonitor monitor;
    private IJavaProject javaProject;
    boolean allwaysDelete = false;
    boolean success = true;
    private WizardContent[] wizardcontent;

    public ZipToProjectOperation(WizardContent[] wizardcontent, IWorkspaceRoot wsRoot) {
        this.wizardcontent = wizardcontent;
        this.wsRoot = wsRoot;
    }

    protected IProject createProject(String projectName) throws Exception {
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        project.create(null);
        project.open(null);
        return project;
    }

    protected void deleteProject(String projectName) throws Exception {
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        project.delete(true, true, null);
    }

    protected void extractZipContents(File zipFile, IProject project) throws Exception {
        Path zipPath = new Path(zipFile.getAbsolutePath());
        ZipFile zf = new ZipFile(zipPath.toFile());
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            try {
                ZipEntry ze = entries.nextElement();
                if (ze.isDirectory()) {
                    this.makeDirectory(ze.getName(), project);
                    continue;
                }
                this.makeFile(zf, ze, project);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void extractZipContents(ZipInputStream zipInputStream, IProject project) throws Exception {
        ZipEntry ze = zipInputStream.getNextEntry();
        while (ze != null) {
            try {
                if (ze.isDirectory()) {
                    this.makeDirectory(ze.getName(), project);
                } else {
                    this.makeFile(new ZipInputStreamWrapper(zipInputStream), ze, project);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            zipInputStream.closeEntry();
            ze = zipInputStream.getNextEntry();
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return this.wsRoot;
    }

    private int handleExistingProject(String projectName) throws Exception {
        if (this.allwaysDelete) {
            return 1;
        }
        String message = "The project " + projectName + " exists in the workspace.  Would you like to replace its contents?";
        return this.openYesToAllDialog(SamplePlugin.getActiveWorkbenchShell(), "Sample Project Exsists", message);
    }

    private void makeDirectory(String name, IProject project) throws Exception {
        IFolder folder = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (folder == null) {
                folder = project.getFolder(s);
                if (folder.exists()) continue;
                folder.create(true, true, null);
                continue;
            }
            if ((folder = folder.getFolder(s)).exists()) continue;
            folder.create(true, true, null);
        }
    }

    private void makeFile(ZipFile zf, ZipEntry ze, IProject project) throws Exception {
        BufferedInputStream stream = new BufferedInputStream(zf.getInputStream(ze));
        IFolder folder = null;
        StringTokenizer st = new StringTokenizer(ze.getName(), "/");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!st.hasMoreTokens()) {
                IFile file = null;
                file = folder != null ? folder.getFile(s) : project.getFile(s);
                if (file.exists()) continue;
                file.create((InputStream)stream, true, null);
                continue;
            }
            folder = folder != null ? folder.getFolder(s) : project.getProject().getFolder(s);
        }
        ((InputStream)stream).close();
    }

    private void makeFile(InputStream zs, ZipEntry ze, IProject project) throws Exception {
        BufferedInputStream stream = new BufferedInputStream(zs);
        IFolder folder = null;
        StringTokenizer st = new StringTokenizer(ze.getName(), "/");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!st.hasMoreTokens()) {
                IFile file = null;
                file = folder != null ? folder.getFile(s) : project.getFile(s);
                if (file.exists()) continue;
                file.create((InputStream)stream, true, null);
                continue;
            }
            folder = folder != null ? folder.getFolder(s) : project.getProject().getFolder(s);
        }
    }

    private synchronized void makeJavaProject(IProject project) throws Exception {
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(desc, null);
        this.setJavaProject(JavaCore.create((IProject)project));
    }

    private int openYesToAllDialog(Shell parent, String title, String message) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open();
    }

    protected boolean projectExists(String projectName) {
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        return project.exists();
    }

    public void run(IProgressMonitor monitor) {
        this.run_eclipse32(monitor);
    }

    public void run_eclipse32(IProgressMonitor monitor) {
        this.setMonitor(monitor);
        IProject project = null;
        int i = 0;
        while (i < this.wizardcontent.length) {
            if (this.wizardcontent[i].isInstall()) {
                String pluginjardir = this.wizardcontent[i].getPluginjardir();
                String subdir = this.wizardcontent[i].getSubdir();
                try {
                    ZipFile pluginjar = new ZipFile(pluginjardir);
                    Enumeration<? extends ZipEntry> zes = pluginjar.entries();
                    while (zes.hasMoreElements()) {
                        ZipEntry ze = zes.nextElement();
                        String entryName = ze.getName();
                        String projectName = null;
                        if (!entryName.startsWith(subdir) || ze.isDirectory()) continue;
                        int beginIndex = subdir.length() + 1;
                        int endIndex = entryName.indexOf(".zip");
                        if (endIndex <= 0 || (projectName = entryName.substring(beginIndex, endIndex)) == null) continue;
                        if (monitor != null && monitor.isCanceled()) {
                            return;
                        }
                        if (!this.wizardcontent[i].isInstallProject(projectName)) continue;
                        monitor.setTaskName("Creating Sample project: " + projectName);
                        boolean createProject = true;
                        if (this.projectExists(projectName)) {
                            int result = -1;
                            if (this.allwaysDelete) {
                                this.deleteProject(projectName);
                            } else {
                                result = this.handleExistingProject(projectName);
                                switch (result) {
                                    case 1: {
                                        this.allwaysDelete = true;
                                    }
                                    case 0: {
                                        this.deleteProject(projectName);
                                        createProject = true;
                                        break;
                                    }
                                    case 2: {
                                        createProject = false;
                                        monitor.worked(1);
                                        break;
                                    }
                                    case 3: {
                                        this.success = false;
                                        return;
                                    }
                                }
                            }
                        }
                        if (!createProject) continue;
                        project = this.createProject(projectName);
                        ZipInputStream zipInputStream = new ZipInputStream(pluginjar.getInputStream(ze));
                        this.extractZipContents(zipInputStream, project);
                        zipInputStream.close();
                        this.makeJavaProject(project);
                        monitor.worked(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void setJavaProject(IJavaProject project) {
        this.javaProject = project;
    }

    private void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
    }

    public boolean success() {
        return this.success;
    }
}

