/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.adapter.managed;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.adapter.Adapter;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.connection.bundle.ServiceInterestBundle;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public abstract class AdapterManaged
extends ServiceInterestBundle
implements ManagedService {
    private AdapterService adapter;

    public Object createService() {
        DeviceService device = this.getDevice();
        if (this.adapter == null) {
            this.adapter = this.createService(device);
        } else {
            this.adapter.setDevice(device);
        }
        if (this.adapter instanceof Adapter) {
            ((Adapter)this.adapter).setBundleContext(this.getBundleContext());
        }
        this.adapter.start();
        return this.adapter;
    }

    public AdapterService createService(DeviceService device) {
        return null;
    }

    protected void deactivate() {
        if (this.getAdapter() != null) {
            try {
                this.getAdapter().exit();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
        }
    }

    public AdapterService getAdapter() {
        if (this.getService() instanceof AdapterService) {
            return (AdapterService)this.getService();
        }
        return null;
    }

    public DeviceService getDevice() {
        Object intest = this.getInterest();
        if (intest instanceof DeviceService) {
            return (DeviceService)intest;
        }
        return null;
    }

    public String getDeviceServiceName() {
        return "";
    }

    public String getInterestServiceName() {
        return this.getDeviceServiceName();
    }

    public String[] getMatchAdapterClasses() {
        return new String[0];
    }

    public String getServiceName() {
        return AdapterService.SERVICE_NAME;
    }

    public void setInterest(Object interest) {
        super.setInterest(interest);
        AdapterService adapter = this.getAdapter();
        if (adapter != null) {
            adapter.setDevice((DeviceService)interest);
        }
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        if (from != null) {
            Enumeration enumeration = from.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = from.get(key);
                table.put(key, value);
            }
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        AdapterService object;
        AdapterService adapterOld = this.getAdapter();
        if (adapterOld != null) {
            this.removeExportedService(AdapterService.SERVICE_NAME);
            adapterOld.exit();
            this.setService(null);
        }
        if ((object = this.createService(null)) instanceof AdapterService) {
            AdapterService adapterService = object;
            adapterService.setConfigurationInformation(properties);
            try {
                adapterService.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setService(object);
            String[] names = this.getExportedServiceNames();
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            this.addExportedServices(names, object, serviceProperties);
        }
    }
}

