/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.DeviceKitUiPlugin;
import org.eclipse.swt.graphics.Image;

public class DkImages {
    private static final URL BASE_URL = DeviceKitUiPlugin.getDefault().getBundle().getEntry("/");
    public static final String ICONS_PATH = "icons" + File.separator;
    public static final ImageDescriptor DESC_CHANGED_INCLUDE_ICON = DkImages.create(ICONS_PATH, "changed_file_obj.gif");
    public static final ImageDescriptor DESC_INCLUDE_ICON = DkImages.create(ICONS_PATH, "file_obj.gif");
    public static final ImageDescriptor DESC_UNKNOWN_ICON = DkImages.create(ICONS_PATH, "unknown.gif");
    public static final ImageDescriptor DESC_FORM_BANNER = DkImages.create(ICONS_PATH, "form_banner.gif");
    public static final ImageDescriptor DESC_COMMAND_ICON = DkImages.create(ICONS_PATH, "command.gif");
    public static final ImageDescriptor DESC_SIGNAL_ICON = DkImages.create(ICONS_PATH, "signal.gif");
    public static final ImageDescriptor DESC_MEASUREMENT_ICON = DkImages.create(ICONS_PATH, "measurement.gif");
    public static final ImageDescriptor DESC_DEVICE_ICON = DkImages.create(ICONS_PATH, "device.gif");
    public static final ImageDescriptor DESC_CML_ICON = DkImages.create(ICONS_PATH, "dkml.gif");
    public static final ImageDescriptor DESC_TEST_ICON = DkImages.create(ICONS_PATH, "test.gif");
    public static final ImageDescriptor DESC_SORT_ICON = DkImages.create(ICONS_PATH, "sort.gif");
    public static final ImageDescriptor DESC_TRANSPORT_ICON = DkImages.create(ICONS_PATH, "transport.gif");
    public static final ImageDescriptor DESC_TRANSPORTSERVICE_ICON = DkImages.create(ICONS_PATH, "transportservice.gif");
    public static final ImageDescriptor DESC_GRAPH_HOME_TOOL = DkImages.create(ICONS_PATH, "home_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_HOME_TOOL_HOVER = DkImages.create(ICONS_PATH, "home_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_HOME_TOOL_DISABLED = DkImages.create(ICONS_PATH, "home_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_BACK_TOOL = DkImages.create(ICONS_PATH, "backward_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_BACK_TOOL_HOVER = DkImages.create(ICONS_PATH, "backward_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_BACK_TOOL_DISABLED = DkImages.create(ICONS_PATH, "backward_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_FORWARD_TOOL = DkImages.create(ICONS_PATH, "forward_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_FORWARD_TOOL_HOVER = DkImages.create(ICONS_PATH, "forward_nav.gif");
    public static final ImageDescriptor DESC_GRAPH_FORWARD_TOOL_DISABLED = DkImages.create(ICONS_PATH, "forward_nav.gif");
    public static final ImageDescriptor DESC_CML_ERROR_ICON = DkImages.create(ICONS_PATH, "error.gif");
    public static final ImageDescriptor DESC_FILTER_ICON = DkImages.create(ICONS_PATH, "filter.gif");
    public static final ImageDescriptor DESC_UNKNOWNTAG_ICON = DkImages.create(ICONS_PATH, "unknowntag.gif");
    public static final ImageDescriptor DESC_NEW_WIZ_ICON = DkImages.create(ICONS_PATH, "new_wiz.gif");
    public static final ImageDescriptor DESC_CLASSPATH_LOC_ICON = DkImages.create(ICONS_PATH, "cp_loc.gif");
    private static DkImages dkmlImages = new DkImages();
    private Hashtable images = new Hashtable();

    private DkImages() {
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)DkImages.makeImageURL(prefix, name));
    }

    public static DkImages getInstance() {
        return dkmlImages;
    }

    private static URL makeImageURL(String prefix, String name) {
        String path = String.valueOf(prefix) + name;
        URL url = null;
        try {
            url = new URL(BASE_URL, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return url;
    }

    public Image createImage(ImageDescriptor desc) {
        if (this.images.containsKey(desc)) {
            return (Image)this.images.get(desc);
        }
        Image image = desc.createImage();
        this.images.put(desc, image);
        return image;
    }

    public void dispose() {
        Enumeration keys = this.images.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Image image = (Image)this.images.get(key);
            image.dispose();
        }
    }
}

