/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.adapter.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.ui.operation.DeviceKitGenerateOperation;

public class AdapterOperation
extends DeviceKitGenerateOperation {
    public AdapterOperation(Hashtable variables) {
        super(variables);
    }

    protected void addAdapterDkmlBody(IXmlElement dkmlElement) {
        IXmlElement element = dkmlElement.addElement("adapter");
        boolean abstractState = this.createCommonTop(element);
        IXmlElement device = element.addElement("device");
        String simpleName = (String)this.getVariables().get("name");
        String deviceName = String.valueOf(simpleName) + "Device";
        StringBuffer refBuffer = new StringBuffer(128);
        String packageBase = this.getPackageBase();
        refBuffer.append(this.getNewBundleName(deviceName, packageBase));
        refBuffer.append("/dk/device.xml#");
        refBuffer.append(deviceName);
        device.addAttribute("idref", refBuffer.toString());
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected void addAdapterTestDkmlBody(IXmlElement dkmlElement) {
        IXmlElement test = dkmlElement.addElement("adaptertest");
        String name = this.getName();
        this.addCommonTestTop(test);
        IXmlElement adapter = test.addElement("adapter");
        StringBuffer refBuffer = new StringBuffer(128);
        refBuffer.append(this.getProjectName());
        refBuffer.append("/dk/adapter.xml#");
        refBuffer.append(name);
        adapter.addAttribute("idref", refBuffer.toString());
        if (this.doGenerateTestcase()) {
            test.addElement("testcase");
        }
        this.addCommonBundle(test);
    }

    protected void addDkmlBody(IXmlElement element, int type) {
        switch (type) {
            case 0: {
                this.addAdapterDkmlBody(element);
                break;
            }
            case 1: {
                this.addAdapterTestDkmlBody(element);
            }
        }
    }

    protected IFile createDkmlFile(int type, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile;
        InputStream stream = null;
        try {
            String name = "adapter.xml";
            if (type == 1) {
                name = "adapter_test.xml";
            }
            XmlModel model = new XmlModel(name);
            this.populateTemplateModel(model, type);
            String contents = model.getContents();
            stream = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes()));
            IFile file = folder.getFile(name);
            file.create(stream, true, monitor);
            iFile = file;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
        catch (IOException iOException) {}
        return iFile;
    }

    protected String getName() {
        String name = (String)this.getVariables().get("name");
        name = String.valueOf(name) + "Adapter";
        return name;
    }

    protected String[] getRequiredClasses() {
        return new String[0];
    }
}

