/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.generator.metadata.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soda.devicekit.generator.metadata.DeviceKitMetaDataException;
import org.eclipse.soda.devicekit.generator.metadata.MetaDataUtility;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.MethodInformation;
import org.eclipse.soda.devicekit.generator.metadata.processing.MetaDataLoader;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class LaunchJavaAction
implements IObjectActionDelegate {
    private Object[] selections;

    private GeneratedInfo loadGeneratedInfo(IType type) throws DeviceKitMetaDataException {
        if (type == null) {
            return null;
        }
        IResource resource = type.getResource();
        if (resource instanceof IFile) {
            MetaDataLoader loader = new MetaDataLoader((IFile)resource);
            return loader.loadInformation();
        }
        return null;
    }

    public void run(IAction action) {
        if (this.selections == null) {
            return;
        }
        int i = 0;
        while (i < this.selections.length) {
            if (this.selections[i] instanceof IType) {
                IType type = (IType)this.selections[i];
                this.run(type);
            }
            ++i;
        }
    }

    private void run(IType type) {
        try {
            MethodInformation[] allMethods = MetaDataUtility.getAllMethods((IType)type);
            GeneratedInfo info = this.loadGeneratedInfo(type);
            String typeName = type.getElementName();
            String packageName = type.getPackageFragment().getElementName();
            MethodInformation[] customMethods = MetaDataUtility.getCustomMethods((GeneratedInfo)info, (String)packageName, (String)typeName, (MethodInformation[])allMethods);
            int i = 0;
            while (i < customMethods.length) {
                System.out.println("\n" + customMethods[i].getData());
                ++i;
            }
        }
        catch (DeviceKitMetaDataException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection strutSelection = (StructuredSelection)selection;
        this.selections = strutSelection.toArray();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

