/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.ui.DeviceKitUiPlugin;
import org.eclipse.soda.devicekit.ui.operation.GenerateOperation;
import org.eclipse.soda.devicekit.ui.wizard.WizardMessages;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.ui.WorkbenchException;

public abstract class DeviceKitGenerateOperation
implements IWorkspaceRunnable {
    public static final int BASE_TYPE = 0;
    public static final int TEST_TYPE = 1;
    private Hashtable variables;
    private IProgressMonitor monitor;
    private IFolder developmentFolder;
    private List generatedProjects = new ArrayList();
    private DkmlFileFinder finder;

    public DeviceKitGenerateOperation(Hashtable variables) {
        this.variables = variables;
    }

    public void addCommonBundle(IXmlElement element) {
        String managedFactory;
        String managedBundle;
        String bundle = (String)this.getVariables().get("create.bundle");
        if (bundle != null && bundle.equals("true")) {
            element.addElement("bundle");
        }
        if ((managedBundle = (String)this.getVariables().get("create.managed.bundle")) != null && managedBundle.equals("true")) {
            element.addElement("managedbundle");
        }
        if ((managedFactory = (String)this.getVariables().get("create.managed.factory.bundle")) != null && managedFactory.equals("true")) {
            element.addElement("managedfactorybundle");
        }
    }

    public void addCommonTestTop(IXmlElement element) {
        String vendor;
        String version;
        String superClass;
        String abstractString;
        boolean abstractState;
        String nameFull = this.getNameFull();
        String testName = String.valueOf(nameFull) + "Test";
        element.addAttribute("id", testName);
        String packageBase = (String)this.getVariables().get("packagebase");
        if (packageBase != null && packageBase.length() > 0) {
            element.addAttribute("packagebase", packageBase);
        }
        boolean bl = abstractState = (abstractString = (String)this.getVariables().get("abstract")) != null && abstractString.equals("true");
        if (abstractState) {
            element.addAttribute("abstract", Boolean.toString(abstractState));
        }
        if ((superClass = (String)this.getVariables().get("device.superclass")) != null && superClass.trim().length() > 0) {
            element.addAttribute("superclass", superClass);
        }
        String description = this.getDescription();
        IXmlElement desc = element.addElement("description");
        desc.setData(String.valueOf(description) + " Test");
        String provider = (String)this.variables.get("provider");
        if (provider != null && provider.length() > 0) {
            IXmlElement providerelement = element.addElement("provider");
            providerelement.setData(provider);
        }
        if ((version = (String)this.variables.get("version")) != null && version.length() > 0) {
            IXmlElement versionelement = element.addElement("version");
            versionelement.setData(version);
        }
        if ((vendor = (String)this.variables.get("vendor")) != null && vendor.length() > 0) {
            IXmlElement vendorelement = element.addElement("vendor");
            vendorelement.setData(vendor);
        }
    }

    protected abstract void addDkmlBody(IXmlElement var1, int var2);

    protected void addDkmlHeader(XmlModel model) {
        Map map = this.getTemplateVariables();
        String[] copyrightStrings = GeneratorTemplates.getCopyrightStrings((Map)map);
        model.addComments(copyrightStrings);
        String[] warningStrings = GeneratorTemplates.getStrings((String)GeneratorTemplates.getWarning((Map)map));
        model.addComments(warningStrings);
    }

    protected void addGeneratedProjects(IJavaProject javaProject) {
        this.generatedProjects.add(javaProject);
    }

    protected void addSpecification(IXmlElement element) {
        String version;
        String vendor;
        String title;
        String date;
        IXmlElement specification = element.addElement("spec");
        specification.addAttribute("id", "Specification");
        specification.addComment("Protocol Specification");
        String comment = (String)this.getVariables().get("specification.comment");
        if (comment != null && comment.length() > 0) {
            IXmlElement commentElement = specification.addElement("speccomment");
            commentElement.setData(comment);
        }
        if ((date = (String)this.getVariables().get("specification.date")) != null && date.length() > 0) {
            IXmlElement dateElement = specification.addElement("specdate");
            dateElement.setData(date);
        }
        if ((title = (String)this.getVariables().get("specification.title")) != null && title.length() > 0) {
            IXmlElement titleElement = specification.addElement("spectitle");
            titleElement.setData(title);
        }
        if ((vendor = (String)this.getVariables().get("specification.vendor")) != null && vendor.length() > 0) {
            IXmlElement vendorElement = specification.addElement("specvendor");
            vendorElement.setData(vendor);
        }
        if ((version = (String)this.getVariables().get("specification.version")) != null && version.length() > 0) {
            IXmlElement versionElement = specification.addElement("specversion");
            versionElement.setData(version);
        }
    }

    public boolean createCommonTop(IXmlElement element) {
        String vendor;
        String version;
        String superClass;
        String abstractString;
        boolean abstractState;
        String nameFull = this.getNameFull();
        element.addAttribute("id", nameFull);
        String packageBase = (String)this.getVariables().get("packagebase");
        if (packageBase != null && packageBase.length() > 0) {
            element.addAttribute("packagebase", packageBase);
        }
        boolean bl = abstractState = (abstractString = (String)this.getVariables().get("abstract")) != null && abstractString.equals("true");
        if (abstractState) {
            element.addAttribute("abstract", Boolean.toString(abstractState));
        }
        if ((superClass = (String)this.getVariables().get("device.superclass")) != null && superClass.trim().length() > 0) {
            element.addAttribute("superclass", superClass);
        }
        String description = this.getDescription();
        IXmlElement desc = element.addElement("description");
        desc.setData(description);
        String provider = (String)this.variables.get("provider");
        if (provider != null && provider.length() > 0) {
            IXmlElement providerelement = element.addElement("provider");
            providerelement.setData(provider);
        }
        if ((version = (String)this.variables.get("version")) != null && version.length() > 0) {
            IXmlElement versionelement = element.addElement("version");
            versionelement.setData(version);
        }
        if ((vendor = (String)this.variables.get("vendor")) != null && vendor.length() > 0) {
            IXmlElement vendorelement = element.addElement("vendor");
            vendorelement.setData(vendor);
        }
        this.addSpecification(element);
        return abstractState;
    }

    protected abstract IFile createDkmlFile(int var1, IFolder var2, IProgressMonitor var3) throws CoreException;

    protected IJavaProject createJavaProject(String name, IProgressMonitor monitor, boolean testProject) throws CoreException, IOException {
        IWorkspace workspace = DeviceKitUiPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(name);
        project.create((IProgressMonitor)new SubProgressMonitor(monitor, 3));
        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 3));
        IFolder sourceFolder = null;
        if (this.useEclipse32Names()) {
            String sfName = this.getNewSourceFolderName();
            sourceFolder = project.getFolder(sfName);
        } else {
            sourceFolder = project.getFolder(name);
        }
        sourceFolder.create(true, true, monitor);
        IJavaProject jProject = JavaCore.create((IProject)project);
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        CoreUtility.addDeviceKitNatureToProject((IProject)project, (IProgressMonitor)monitor);
        CoreUtility.createSettings((IContainer)project, null);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IClasspathEntry entry = null;
        String jre = "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/OSGi%Minimum-1.1";
        if (project.getName().endsWith(".test")) {
            jre = "org.eclipse.jdt.launching.JRE_CONTAINER";
        }
        entry = JavaCore.newContainerEntry((IPath)new Path(jre));
        list.add(entry);
        entry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
        list.add(entry);
        IPath path = sourceFolder.getFullPath();
        path = path.makeAbsolute();
        entry = JavaCore.newSourceEntry((IPath)path);
        list.add(entry);
        IClasspathEntry[] entries = new IClasspathEntry[list.size()];
        list.toArray(entries);
        jProject.setRawClasspath(entries, monitor);
        String developmentName = null;
        if (this.useEclipse32Names()) {
            developmentName = this.getNewDevelopmentName();
        } else {
            String develUnformatted = WizardMessages.getInstance().getString("DeviceKitGenerateOperation.development.folder");
            developmentName = Nls.format((String)develUnformatted, (Object)name);
        }
        this.developmentFolder = project.getFolder((IPath)new Path(developmentName));
        CoreUtility.createFolder((IFolder)this.developmentFolder, (boolean)true, (boolean)true, null);
        if (testProject) {
            entries = new IClasspathEntry[list.size()];
            list.toArray(entries);
            jProject.setRawClasspath(entries, monitor);
        } else {
            entries = new IClasspathEntry[list.size()];
            list.toArray(entries);
            jProject.setRawClasspath(entries, monitor);
        }
        CoreUtility.createCopyrightFile((IContainer)jProject.getProject(), (IProgressMonitor)monitor);
        CoreUtility.createAboutFile((IContainer)jProject.getProject(), (IProgressMonitor)monitor);
        CoreUtility.createCvsIgnoreFile((IContainer)jProject.getProject(), (IProgressMonitor)monitor);
        CoreUtility.createEscPropertiesFile((IContainer)jProject.getProject(), (IProgressMonitor)monitor);
        CoreUtility.createBuildPropertiesFile((IProject)jProject.getProject(), (IProgressMonitor)monitor);
        monitor.worked(3);
        return jProject;
    }

    protected boolean doGenerateMain() {
        return true;
    }

    protected boolean doGenerateTest() {
        String test = (String)this.variables.get("create.test");
        boolean result = test == null || test.equals("true");
        return result;
    }

    protected boolean doGenerateTestcase() {
        String test = (String)this.variables.get("create.testcase");
        boolean result = test == null || test.equals("true");
        return result;
    }

    protected void generate(IFile file) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.monitor, 3);
        subMonitor.beginTask(file.toString(), 0);
        GenerateOperation op = new GenerateOperation(this.getVariables(), new IFile[]{file});
        op.setGenerateManifest(true);
        op.setMethodProperties(this.getVariables());
        op.setRequiredClasses(this.getRequiredClasses());
        op.run((IProgressMonitor)subMonitor);
        this.monitor.worked(3);
    }

    public void generateMain(IProgressMonitor monitor) throws Exception {
        if (this.doGenerateMain()) {
            IProject project;
            String coreName = this.getNameFull();
            if (this.useEclipse32Names()) {
                String packageBase = this.getPackageBase();
                coreName = this.getNewBundleName(coreName, packageBase);
            }
            if (!(project = CoreUtility.getProject((String)coreName)).exists()) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 3);
                subMonitor.beginTask("create Projects", 0);
                IJavaProject coreProject = this.createJavaProject(coreName, (IProgressMonitor)subMonitor, false);
                this.addGeneratedProjects(coreProject);
                if (this.developmentFolder != null && this.developmentFolder.exists()) {
                    IFile file = this.createDkmlFile(0, this.developmentFolder, monitor);
                    CoreUtility.createCopyrightFile((IContainer)this.developmentFolder, (IProgressMonitor)monitor);
                    this.generate(file);
                }
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
            }
        }
    }

    public void generateTest(IProgressMonitor monitor) throws Exception {
        if (this.doGenerateTest()) {
            try {
                IProject project;
                String coreName = this.getNameFull();
                String testName = String.valueOf(coreName) + "Test";
                if (this.useEclipse32Names()) {
                    String packageBase = this.getPackageBase();
                    coreName = this.getNewBundleName(coreName, packageBase);
                    testName = this.getNewBundleName(testName, packageBase);
                }
                if (!(project = CoreUtility.getProject((String)testName)).exists()) {
                    IJavaProject testProject = this.createJavaProject(testName, (IProgressMonitor)new SubProgressMonitor(monitor, 3), true);
                    this.addGeneratedProjects(testProject);
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    if (this.developmentFolder != null && this.developmentFolder.exists()) {
                        IFile file = this.createDkmlFile(1, this.developmentFolder, monitor);
                        CoreUtility.createCopyrightFile((IContainer)this.developmentFolder, (IProgressMonitor)monitor);
                        this.generate(file);
                    }
                }
            }
            catch (Exception e) {
                throw new WorkbenchException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String getDefaultDescription() {
        String name = this.getName();
        return this.spaceAtCaps(name);
    }

    public String getDescription() {
        String description = (String)this.getVariables().get("description");
        if (description == null || description.trim().length() == 0) {
            return this.getDefaultDescription();
        }
        return description;
    }

    public DkmlFileFinder getFinder() {
        if (this.finder == null) {
            this.finder = new DkmlFileFinder();
        }
        return this.finder;
    }

    public List getGeneratedProjects() {
        return this.generatedProjects;
    }

    protected abstract String getName();

    protected String getNameFull() {
        return this.getName();
    }

    protected String getNewBundleName(String className, String packageBase) {
        String packageName = DeviceKitUtilities.getPackageFromClassName((String)className, (String)packageBase);
        return packageName;
    }

    private String getNewDevelopmentName() {
        return "dk";
    }

    private String getNewSourceFolderName() {
        return "src";
    }

    protected String getPackageBase() {
        String packageBase = (String)this.variables.get("packagebase");
        return packageBase;
    }

    public String getProjectName() {
        String className = this.getNameFull();
        String packageBase = this.getPackageBase();
        return this.getNewBundleName(className, packageBase);
    }

    protected abstract String[] getRequiredClasses();

    protected Map getTemplateVariables() {
        HashMap<String, String> map = new HashMap<String, String>(101);
        String year = String.valueOf(Calendar.getInstance().get(1));
        map.put("year", year);
        map.put("years", year);
        String vendor = (String)this.variables.get("vendor");
        map.put("vendor", vendor);
        map.put("vendors", vendor);
        String provider = (String)this.variables.get("provider");
        map.put("provider", provider);
        String packagebase = (String)this.variables.get("packagebase");
        map.put("packagebase", packagebase);
        String version = (String)this.variables.get("version");
        map.put("version", version);
        return map;
    }

    public Hashtable getVariables() {
        return this.variables;
    }

    protected void handleError(Exception e) throws CoreException {
        throw new WorkbenchException(e.getMessage(), (Throwable)e);
    }

    protected void initialize() {
        if (this.monitor != null) {
            String taskName = WizardMessages.getInstance().getString("DeviceKitGenerateOperation.task.name");
            this.monitor.beginTask(taskName, 100);
        }
    }

    protected void populateTemplateModel(XmlModel model, int type) {
        this.addDkmlHeader(model);
        IXmlElement dkmlElement = model.addElement("dkml");
        this.addDkmlBody(dkmlElement, type);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        try {
            this.initialize();
            if (this.monitor.isCanceled()) {
                return;
            }
            this.generateMain(monitor);
            if (this.monitor.isCanceled()) {
                return;
            }
            this.generateTest(monitor);
            String name = (String)this.getVariables().get("name");
            if (this.useEclipse32Names()) {
                String packageBase = this.getPackageBase();
                name = this.getNewBundleName(name, packageBase);
            }
            CoreUtility.createWorkingSetBase((String)name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkbenchException(e.getMessage(), (Throwable)e);
        }
    }

    public void setFinder(DkmlFileFinder finder) {
        this.finder = finder;
    }

    protected void setGeneratedProjects(List generatedProjects) {
        this.generatedProjects = generatedProjects;
    }

    protected String spaceAtCaps(String string) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            if (i > 0 && Character.isUpperCase(string.charAt(i))) {
                buffer.append(' ');
            }
            buffer.append(string.charAt(i));
            ++i;
        }
        return buffer.toString();
    }

    protected boolean useEclipse32Names() {
        return GeneratorPlugin.useEclipse32Names();
    }
}

