/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.soda.devicekit.DeviceKitPlugin;

public class DkPreferences {
    public static final String[] DEF_DEV_SUPERS = new String[0];
    public static final String[] DEF_TRAN_SUPERS = new String[0];
    public static final String[] DEF_TRAN_SERVICES = new String[0];
    public static final String[] DEF_TRAN_IMPLS = new String[0];

    public static String fixSlashes(String string) {
        return string.replace('\\', '/');
    }

    public static String[] getDefault(String key) {
        IPreferenceStore store = DkPreferences.getStore();
        String value = store.getDefaultString(key);
        if (value != null) {
            return DkPreferences.parsePrefArray(value);
        }
        return new String[0];
    }

    public static boolean getDefaultBoolean(String key) {
        IPreferenceStore store = DkPreferences.getStore();
        boolean value = store.getDefaultBoolean(key);
        return value;
    }

    public static String[] getDefaultClasspathLocations() {
        String[] variables = JavaCore.getClasspathVariableNames();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < variables.length) {
            String varName = variables[i];
            IPath path = JavaCore.getClasspathVariable((String)varName);
            if (path.toFile().exists()) {
                File bundleFiles;
                String pathString = path.makeAbsolute().toString();
                list.add(DkPreferences.fixSlashes(pathString));
                File file = new File(pathString);
                if (file.exists() && (bundleFiles = new File(file, "bundlefiles")).exists()) {
                    list.add(DkPreferences.fixSlashes(bundleFiles.getAbsolutePath()));
                }
            }
            ++i;
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static boolean getPreferenceBoolean(String key) {
        IPreferenceStore store = DkPreferences.getStore();
        return store.getBoolean(key);
    }

    public static String getPreferenceString(String key) {
        IPreferenceStore store = DkPreferences.getStore();
        return store.getString(key);
    }

    public static IPreferenceStore getStore() {
        return DeviceKitPlugin.getDefault().getPreferenceStore();
    }

    public static void initDefaultPreferences() {
        IPreferenceStore store = DkPreferences.getStore();
        store.setDefault("preference_page.PackageBase", "org.eclipse.soda.sk");
        store.setDefault("preference_page.Vendor", "");
        store.setDefault("preference_page.Provider", "Eclipse.org");
        store.setDefault("preference_page.Name", "");
        store.setDefault("preference_page.Version", "1.0.0");
        store.setDefault("preference_page.Format", true);
        store.setDefault("preference_page.OrganizeImports", true);
        store.setDefault("preference_page.Schema", true);
        store.setDefault("preference_page.IveAttrs", false);
        store.setDefault("preference_page.IveRes", false);
        store.setDefault("device.preference_page.SuperClasses", DkPreferences.makePrefString(DEF_DEV_SUPERS));
        store.setDefault("transport.preference_page.SuperClasses", DkPreferences.makePrefString(DEF_TRAN_SUPERS));
        store.setDefault("device.preference_page.TransportServices", DkPreferences.makePrefString(DEF_TRAN_SERVICES));
        store.setDefault("device.preference_page.TransportImplementations", DkPreferences.makePrefString(DEF_TRAN_IMPLS));
        store.setDefault("classpath.preference_page.Locations", DkPreferences.makePrefString(DkPreferences.getDefaultClasspathLocations()));
        store.setDefault("classpath.preference_page.SearchProjects", true);
    }

    protected static String makePrefString(String[] entries) {
        StringBuffer buffer = new StringBuffer(entries.length * 30);
        int i = 0;
        while (i < entries.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(entries[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] parsePrefArray(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        String[] result = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String token;
            result[count] = token = tokenizer.nextToken();
            ++count;
        }
        return result;
    }

    public static void setPreference(String key, String[] values) {
        DkPreferences.setPreference(key, DkPreferences.makePrefString(values));
    }

    public static void setPreference(String key, boolean value) {
        IPreferenceStore store = DkPreferences.getStore();
        store.setValue(key, value);
    }

    public static void setPreference(String key, String value) {
        IPreferenceStore store = DkPreferences.getStore();
        store.setValue(key, value);
    }
}

