/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testagent.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.ui.operation.DeviceKitGenerateOperation;

public class TestAgentOperation
extends DeviceKitGenerateOperation {
    public TestAgentOperation(Hashtable variables) {
        super(variables);
    }

    protected void addDkmlBody(IXmlElement element, int type) {
        switch (type) {
            case 0: {
                this.addTestAgentDkmlBody(element);
                break;
            }
            case 1: {
                this.addProfileTestDkmlBody(element);
            }
        }
    }

    protected void addProfileTestDkmlBody(IXmlElement element) {
        IXmlElement test = element.addElement("testagenttest");
        String name = this.getName();
        this.addCommonTestTop(test);
        IXmlElement profile = test.addElement("testagent");
        StringBuffer refBuffer = new StringBuffer(128);
        refBuffer.append(this.getProjectName());
        refBuffer.append("/dk/testagent.xml#");
        refBuffer.append(name);
        profile.addAttribute("idref", refBuffer.toString());
        if (this.doGenerateTestcase()) {
            test.addElement("testcase");
        }
        this.addCommonBundle(test);
    }

    protected void addTestAgentDkmlBody(IXmlElement dkmlElement) {
        String baseName = (String)this.getVariables().get("name");
        IXmlElement element = dkmlElement.addElement("testagent");
        boolean abstractState = this.createCommonTop(element);
        IXmlElement testcase = element.addElement("testcase");
        testcase.addAttribute("id", String.valueOf(baseName) + "Testcase");
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected IFile createDkmlFile(int type, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile;
        InputStream stream = null;
        try {
            String name = "testagent.xml";
            if (type == 1) {
                name = "testagent_test.xml";
            }
            XmlModel model = new XmlModel(name);
            this.populateTemplateModel(model, type);
            String contents = model.getContents();
            stream = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes()));
            IFile file = folder.getFile(name);
            file.create(stream, true, monitor);
            iFile = file;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
        catch (IOException iOException) {}
        return iFile;
    }

    protected boolean doGenerateTest() {
        return false;
    }

    public String getName() {
        String name = (String)this.getVariables().get("name");
        name = String.valueOf(name) + "TestAgent";
        return name;
    }

    protected String[] getRequiredClasses() {
        return new String[0];
    }
}

