/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import org.eclipse.soda.devicekit.ui.transport.wizard.DeviceKitConnectionPage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class SerialConnectionPage
extends DeviceKitConnectionPage {
    private IWizardMessages messages;
    private String defaultMessage;

    public SerialConnectionPage(String pageName, IWizardMessages messages, String defaultMessage, DeviceKitPage previousPage) {
        super(pageName, previousPage);
        this.messages = messages;
        this.defaultMessage = defaultMessage;
        this.setTitle(messages.getString("transport"));
        this.setMessage(defaultMessage);
    }

    public void createCustom(Composite composite) {
        Text comPortText = this.createTextControl(composite, "connection.com.port");
        String defaultPort = this.messages.getString("connection.com.port.default");
        comPortText.setText(defaultPort);
        String[] baudRates = this.messages.getStringAsArray("connection.baud.rate.combo");
        Combo baudRatesCombo = this.createComboControl(composite, "connection.baud.rate", baudRates, 2056);
        baudRatesCombo.select(baudRates.length - 1);
        String[] dataBits = this.messages.getStringAsArray("connection.data.bits.combo");
        Combo dataBitsCombo = this.createComboControl(composite, "connection.data.bits", dataBits, 2056);
        dataBitsCombo.select(dataBits.length - 1);
        String[] parity = this.messages.getStringAsArray("connection.parity.combo");
        Combo parityCombo = this.createComboControl(composite, "connection.parity", parity, 2056);
        parityCombo.select(0);
        String[] stopBits = this.messages.getStringAsArray("connection.stop.bits.combo");
        Combo stopBitsCombo = this.createComboControl(composite, "connection.stop.bits", stopBits, 2056);
        stopBitsCombo.select(0);
        this.createCheckBoxControl(composite, "connection.hardware.flow.control");
        this.createCheckBoxControl(composite, "connection.software.flow.control");
        Text readTotalText = this.createTextControl(composite, "connection.read.total.timeout");
        String defaultReadTotal = this.messages.getString("connection.read.total.timeout.default");
        readTotalText.setText(defaultReadTotal);
        Text readIntervalText = this.createTextControl(composite, "connection.read.interval.timeout");
        String defaultReadInterval = this.messages.getString("connection.read.interval.timeout.default");
        readIntervalText.setText(defaultReadInterval);
        Text writeTotalText = this.createTextControl(composite, "connection.write.total.timeout");
        String defaultWriteTotal = this.messages.getString("connection.write.total.timeout.default");
        writeTotalText.setText(defaultWriteTotal);
    }

    protected String getKey() {
        return "serial";
    }

    public String getString(String key) {
        return this.messages.getString(key);
    }

    protected boolean updatePageErrors() {
        if (!this.isNumberTextEntry("connection.com.port", false)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.read.total.timeout", false)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.read.interval.timeout", false)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.write.total.timeout", false)) {
            return false;
        }
        this.update(true, false, null, this.defaultMessage);
        return true;
    }
}

