/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import org.eclipse.soda.devicekit.ui.transport.wizard.DeviceKitConnectionPage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TcpipServerConnectionPage
extends DeviceKitConnectionPage {
    private IWizardMessages messages;
    private String defaultMessage;

    public TcpipServerConnectionPage(String pageName, IWizardMessages messages, String defaultMessage, DeviceKitPage previousPage) {
        super(pageName, previousPage);
        this.messages = messages;
        this.defaultMessage = defaultMessage;
        this.setTitle(messages.getString("transport"));
        this.setMessage(defaultMessage);
    }

    public void createCustom(Composite composite) {
        this.createTextControl(composite, "connection.host");
        this.createTextControl(composite, "connection.remote.port");
        this.createTextControl(composite, "connection.local.port");
        this.createTextControl(composite, "connection.linger");
    }

    protected String getKey() {
        return "tcpip";
    }

    public String getString(String key) {
        return this.messages.getString(key);
    }

    protected boolean updatePageErrors() {
        String value;
        Text hostText = (Text)this.getWidget("connection.host");
        if (hostText != null && (value = hostText.getText()).length() == 0) {
            String message = this.messages.getString("connection.host.empty");
            this.update(false, false, null, message);
            return false;
        }
        if (!this.isNumberTextEntry("connection.remote.port", true)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.local.port", true)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.linger", true)) {
            return false;
        }
        this.update(true, false, null, this.defaultMessage);
        return true;
    }
}

