/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.transport.wizard.DeviceKitConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.FileConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.RandomAccessFileConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.SerialConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.TcpipConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.TcpipServerConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.TransportMessages;
import org.eclipse.soda.devicekit.ui.transport.wizard.UrlConnectionPage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitBasePage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TransportDetailsPage
extends DeviceKitBasePage {
    private static IWizardMessages messages = TransportMessages.getInstance();
    private WizardPage nextPage;
    private String custom;
    private String file;
    private String randomaccessfile;
    private String none;
    private String serial;
    private String tcpip;
    private String tcpipserver;
    private String url;
    private DeviceKitConnectionPage filePage;
    private DeviceKitConnectionPage randomaccessfilePage;
    private DeviceKitConnectionPage serialPage;
    private DeviceKitConnectionPage tcpipPage;
    private DeviceKitConnectionPage tcpipserverPage;
    private DeviceKitConnectionPage urlPage;

    public TransportDetailsPage(String pageName) {
        super(messages.getString("new.transport"));
        this.custom = messages.getString("custom");
        this.file = messages.getString("file");
        this.none = messages.getString("none");
        this.randomaccessfile = messages.getString("randomaccessfile");
        this.serial = messages.getString("serial");
        this.tcpip = messages.getString("tcpip");
        this.tcpipserver = messages.getString("tcpipserver");
        this.url = messages.getString("url");
        this.setTitle(messages.getString("transport"));
    }

    public TransportDetailsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private boolean connectionOk() {
        this.updateConnection();
        Combo connection = (Combo)this.getWidget("connection");
        String value = connection.getItem(connection.getSelectionIndex());
        if (this.none.equals(value)) {
            return true;
        }
        if (this.custom.equals(value)) {
            Text customText = (Text)this.getWidget("custom.connection.implementation");
            String custom = customText.getText();
            if (custom.trim().length() == 0) {
                String message = this.getString("custom.connection.implementation.empty");
                this.update(false, false, null, message);
                return false;
            }
            this.update(true, false, null, null);
            return true;
        }
        this.update(false, true, null, null);
        return false;
    }

    protected void createCommonControl(Composite composite) {
    }

    protected void createCustomControl(Composite composite) {
        this.createTextControl(composite, "response.timeout");
        Combo combo = this.createComboControl(composite, "connection", this.getConnections(), 2060);
        combo.select(0);
        Text customImpl = this.createTextControl(composite, "custom.connection.implementation");
        customImpl.setEnabled(false);
        this.createComboControl(composite, "superclass", this.getSuperclass(), 2060);
        this.createOptions(composite);
    }

    protected void createOptions(Composite composite) {
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TransportDetailsPage.this.handleButtonSelection();
            }
        };
        String labelString = this.getString("options");
        Button button = this.createCheckBoxControl(composite, "abstract.transport", labelString);
        button.setEnabled(false);
        button.addSelectionListener(listener);
        button = this.createCheckBoxControl(composite, "processInput");
        button.setSelection(true);
        button = this.createCheckBoxControl(composite, "write");
        button.setSelection(true);
    }

    protected String[] getConnections() {
        return new String[]{this.none, this.custom, this.file, this.randomaccessfile, this.serial, this.tcpip, this.tcpipserver, this.url};
    }

    protected DeviceKitConnectionPage getFileConnectionPage() {
        if (this.filePage == null) {
            this.filePage = new FileConnectionPage("", messages, this.getDefaultMessage(), this);
            this.filePage.setWizard(this.getWizard());
        }
        return this.filePage;
    }

    protected String getKey() {
        return "transport";
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    protected DeviceKitConnectionPage getRandomAccessFileConnectionPage() {
        if (this.randomaccessfilePage == null) {
            this.randomaccessfilePage = new RandomAccessFileConnectionPage("", messages, this.getDefaultMessage(), this);
            this.randomaccessfilePage.setWizard(this.getWizard());
        }
        return this.randomaccessfilePage;
    }

    protected DeviceKitConnectionPage getSerialConnectionPage() {
        if (this.serialPage == null) {
            this.serialPage = new SerialConnectionPage("", messages, this.getDefaultMessage(), this);
            this.serialPage.setWizard(this.getWizard());
        }
        return this.serialPage;
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            return super.getString(key);
        }
    }

    protected String[] getSuperclass() {
        String value = DeviceKitPreferenceInitializer.getPreferenceString((String)"transport.superclass");
        if (value != null) {
            return DeviceKitPreferenceInitializer.parsePrefArray((String)value);
        }
        return new String[0];
    }

    protected DeviceKitConnectionPage getTcpipConnectionPage() {
        if (this.tcpipPage == null) {
            this.tcpipPage = new TcpipConnectionPage("", messages, this.getDefaultMessage(), this);
            this.tcpipPage.setWizard(this.getWizard());
        }
        return this.tcpipPage;
    }

    protected DeviceKitConnectionPage getTcpipServerConnectionPage() {
        if (this.tcpipserverPage == null) {
            this.tcpipserverPage = new TcpipServerConnectionPage("", messages, this.getDefaultMessage(), this);
            this.tcpipserverPage.setWizard(this.getWizard());
        }
        return this.tcpipserverPage;
    }

    protected DeviceKitConnectionPage getUrlConnectionPage() {
        if (this.urlPage == null) {
            this.urlPage = new UrlConnectionPage("", messages, this.getDefaultMessage(), this);
            this.urlPage.setWizard(this.getWizard());
        }
        return this.urlPage;
    }

    public Hashtable getVariables() {
        if (this.getNextPage() != null) {
            return this.mergeVariableTables();
        }
        return super.getVariables();
    }

    protected void handleButtonSelection() {
        Button createTest = (Button)this.getWidget("create.test");
        Button abstractTransport = (Button)this.getWidget("abstract.transport");
        if (createTest == null || abstractTransport == null) {
            return;
        }
        boolean createTestValue = createTest.getSelection();
        boolean abstractTransportValue = abstractTransport.getSelection();
        if (createTestValue) {
            abstractTransport.setSelection(false);
            abstractTransport.setEnabled(false);
        } else if (abstractTransportValue) {
            createTest.setSelection(false);
            createTest.setEnabled(false);
        } else {
            abstractTransport.setEnabled(true);
            createTest.setEnabled(true);
        }
    }

    public boolean isDisplayTest() {
        return false;
    }

    private Hashtable mergeVariableTables() {
        DeviceKitPage page = (DeviceKitPage)this.getNextPage();
        Hashtable transportVariables = super.getVariables();
        Hashtable conVariables = page.getVariables();
        Enumeration conKeys = conVariables.keys();
        while (conKeys.hasMoreElements()) {
            Object conKey = conKeys.nextElement();
            Object conValue = conVariables.get(conKey);
            transportVariables.put(conKey, conValue);
        }
        return transportVariables;
    }

    private boolean responseTimeOutOk() {
        return this.isNumberTextEntry("response.timeout", true);
    }

    protected void setNextPage(DeviceKitConnectionPage page) {
        if (page == null) {
            this.nextPage = page;
        } else if (!((Object)((Object)page)).equals(this.nextPage)) {
            this.nextPage = page;
        }
    }

    private void updateConnection() {
        Combo connection = (Combo)this.getWidget("connection");
        String selection = connection.getItem(connection.getSelectionIndex());
        Text customConnection = (Text)this.getWidget("custom.connection.implementation");
        if (this.custom.equals(selection)) {
            customConnection.setEnabled(true);
            this.setNextPage(null);
        } else if (this.none.equals(selection)) {
            customConnection.setEnabled(false);
            this.setNextPage(null);
        } else {
            customConnection.setEnabled(false);
            if (this.file.equals(selection)) {
                this.setNextPage(this.getFileConnectionPage());
            } else if (this.randomaccessfile.equals(selection)) {
                this.setNextPage(this.getRandomAccessFileConnectionPage());
            } else if (this.serial.equals(selection)) {
                this.setNextPage(this.getSerialConnectionPage());
            } else if (this.tcpip.equals(selection)) {
                this.setNextPage(this.getTcpipConnectionPage());
            } else if (this.tcpipserver.equals(selection)) {
                this.setNextPage(this.getTcpipServerConnectionPage());
            } else if (this.url.equals(selection)) {
                this.setNextPage(this.getUrlConnectionPage());
            }
        }
    }

    protected boolean updatePageErrors() {
        if (!this.responseTimeOutOk()) {
            return false;
        }
        if (!this.connectionOk()) {
            return false;
        }
        this.update(true, this.getNextPage() != null, null, null);
        return true;
    }
}

