/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.utility.action;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soda.devicekit.ui.utility.action.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SourceDialog
extends MessageDialog {
    private Composite composite;
    private Map controls = new Hashtable();
    private Properties properties = new Properties();

    public SourceDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public SourceDialog(Shell parentShell) {
        this(parentShell, Messages.getString("SourceDialog.0"), null, Messages.getString("SourceDialog.1"), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
    }

    public void computeProperties() {
        Iterator iterator = this.getControls().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Button) {
                Boolean state = ((Button)value).getSelection() ? Boolean.TRUE : Boolean.FALSE;
                this.properties.put(key, state);
                continue;
            }
            this.properties.put(key, Boolean.TRUE);
        }
    }

    public Button createCheckBox(Composite contents, String fieldName) {
        GridData data;
        String labelString = this.getResourceString(String.valueOf(fieldName) + ".title");
        if (labelString != null && labelString.length() > 0 && !labelString.startsWith("!")) {
            Label label = new Label(contents, 16384);
            label.setText("");
            data = new GridData(4);
            data.widthHint = 300;
            data.horizontalSpan = 3;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
            label = new Label(contents, 16384);
            label.setText(labelString);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
        }
        Button button = new Button(contents, 32);
        button.setText(this.getResourceString(fieldName));
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        button.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        button.setSelection(true);
        this.getProperties().put(fieldName, Boolean.TRUE);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SourceDialog.this.computeProperties();
            }
        });
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.composite.setLayout((Layout)layout);
        Object[] buttonNames = this.getButtonNames();
        Arrays.sort(buttonNames);
        int i = 0;
        while (i < buttonNames.length) {
            this.put((String)buttonNames[i], (Control)this.createCheckBox(this.getComposite(), (String)buttonNames[i]));
            ++i;
        }
        Dialog.applyDialogFont((Control)parent);
        return this.composite;
    }

    public String[] getButtonNames() {
        return new String[]{"project", "package", "c", "h", "makefiles", "txt", "html", "java", "manifest", "properties", "xml"};
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Map getControls() {
        return this.controls;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getResourceString(String string) {
        return Messages.getString(string);
    }

    public void put(String key, Control control) {
        this.controls.put(key, control);
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setControls(Map controls) {
        this.controls = controls;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

