/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.utility.operation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.soda.devicekit.generator.html.PackageHtmlGenerator;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.visitor.JavadocVisitor;
import org.eclipse.soda.devicekit.generator.visitor.Visitor;
import org.eclipse.soda.devicekit.ui.utility.operation.SourceOperation;
import org.eclipse.soda.devicekit.util.CoreUtility;

public class FixSourceOperation
extends SourceOperation
implements Comparator {
    static final String[] specialKeys = new String[]{"Bundle-Copyright", "Bundle-Description", "Bundle-Name", "Bundle-Vendor"};

    public FixSourceOperation() {
    }

    public FixSourceOperation(Map map) {
        this.getProperties().putAll((Map<?, ?>)map);
    }

    public int compare(Object arg0, Object arg1) {
        String name0 = String.valueOf(arg0);
        if (name0.startsWith("Manifest-")) {
            return -1;
        }
        String name1 = String.valueOf(arg1);
        if (name1.startsWith("Manifest-")) {
            return 1;
        }
        return name0.compareTo(name1);
    }

    public String compilationUnit(CompilationUnit cu, String source, String[] references) {
        Visitor visitor = this.getVisitor();
        visitor.setPseudo(false);
        visitor.setSource(source);
        visitor.setReferences(references);
        try {
            cu.accept((ASTVisitor)visitor);
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        return visitor.toString();
    }

    protected Visitor getVisitor() {
        return new JavadocVisitor();
    }

    public void outputTo(Manifest manifest, IFile file) throws Exception {
        IProject project = file.getProject();
        IFile propertiesFile = project.getFile("OSGI-INF/l10n/bundle.properties");
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            FileInputStream lfis = new FileInputStream(propertiesFile.getRawLocation().toFile());
            BufferedInputStream inStream = new BufferedInputStream(lfis, 4096);
            properties.load(inStream);
        }
        FileOutputStream fout = new FileOutputStream(file.getRawLocation().toFile());
        BufferedOutputStream os = new BufferedOutputStream(fout);
        Attributes attributes = manifest.getMainAttributes();
        Set<Object> set = attributes.keySet();
        Object[] keys = new Object[set.size()];
        keys = set.toArray(keys);
        Arrays.sort(keys, this);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            String pkey = String.valueOf(key).toLowerCase().replace('-', '.');
            Object value = attributes.get(key);
            if (Arrays.binarySearch(specialKeys, key.toString()) >= 0) {
                properties.put(pkey, value);
                this.outputTo(os, String.valueOf(key), "%" + pkey);
            } else {
                this.outputTo(os, String.valueOf(key), String.valueOf(value));
            }
            ++i;
        }
        os.close();
        this.saveAllDirectory("OSGI-INF/l10n/bundle.properties", project);
        this.processPropertiesFile(propertiesFile, properties);
        IFile propertiesFileEn = project.getFile("OSGI-INF/l10n/bundle_en.properties");
        this.processPropertiesFile(propertiesFileEn, properties);
    }

    public void outputTo(OutputStream s, String key, String value) throws Exception {
        String output = value.trim();
        if (output.length() > 0) {
            s.write(key.getBytes());
            s.write(": ".getBytes());
            if (output.length() + 1 < 70) {
                s.write(output.getBytes());
                s.write(13);
                s.write(10);
            } else {
                int i = 0;
                while (i < output.length()) {
                    if (output.charAt(i) == '\n') {
                        s.write(13);
                        s.write(10);
                        s.write(32);
                    } else if (output.charAt(i) != '\r') {
                        s.write(output.charAt(i));
                        if (output.charAt(i) == ',') {
                            s.write(13);
                            s.write(10);
                            s.write(32);
                        }
                    }
                    ++i;
                }
                s.write(13);
                s.write(10);
            }
        }
    }

    public void processCodeFile(IFile file) {
        try {
            StringBuffer buffer = new StringBuffer(4096);
            StringBuffer copyrightBuffer = new StringBuffer(4096);
            InputStream is = file.getContents();
            String data = new String(this.readData(is));
            boolean found = false;
            StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String trimToken = token.trim();
                if (!found) {
                    if (trimToken.startsWith("*") || trimToken.startsWith("/*") || trimToken.startsWith("//")) {
                        copyrightBuffer.append(token);
                        copyrightBuffer.append("\r\n");
                        continue;
                    }
                    if (copyrightBuffer.length() > 0) {
                        String oldCopyright = copyrightBuffer.toString();
                        int createYear = this.containsCopyright(oldCopyright);
                        buffer.append(this.getCopyrightStringCode(createYear));
                        found = true;
                    }
                    buffer.append(token);
                    buffer.append("\r\n");
                    continue;
                }
                buffer.append(token);
                buffer.append("\r\n");
            }
            String newData = buffer.toString();
            if (!data.equals(newData)) {
                byte[] dataBytes = newData.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processCompilationUnit(ICompilationUnit compilationUnit, boolean refresh) {
        try {
            if (this.isJava()) {
                String oldString;
                String data = oldString = compilationUnit.getSource();
                CompilationUnit cu = null;
                cu = AST.parseCompilationUnit((ICompilationUnit)compilationUnit, (boolean)true);
                if (data != null) {
                    String packageName = compilationUnit.getParent().getElementName();
                    data = this.compilationUnit(cu, compilationUnit.getSource(), new String[0]);
                    packageName = packageName.replace('.', '/');
                    if (!(data = this.format(data)).equals(oldString)) {
                        ByteArrayInputStream source = new ByteArrayInputStream(data.getBytes());
                        ((IFile)compilationUnit.getResource()).setContents((InputStream)source, true, true, this.getProgressMonitor());
                    }
                }
                compilationUnit.close();
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    protected void processCopyrightFile(IFile file) {
        try {
            InputStream is = file.getContents();
            String data = new String(this.readData(is));
            int createYear = this.containsCopyright(data);
            String copyright = GeneratorTemplates.getCopyright((int)createYear);
            if (!data.equals(copyright)) {
                byte[] dataBytes = copyright.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean processFile(IFile file, boolean b) {
        if (file.exists()) {
            String name = file.getName();
            if ("copyright.txt".equals(name)) {
                if (this.isTxt()) {
                    this.processCopyrightFile(file);
                }
            } else if (String.valueOf(file.getFileExtension()).endsWith("properties")) {
                if (this.isProperties()) {
                    this.processPropertiesFile(file);
                }
            } else if ("MANIFEST.MF".equals(name)) {
                if (this.isManifest()) {
                    this.processManifest(file);
                }
            } else if (name.endsWith(".c")) {
                if (this.isC()) {
                    this.processCodeFile(file);
                }
            } else if (name.endsWith(".h")) {
                if (this.isH()) {
                    this.processCodeFile(file);
                }
            } else if (name.endsWith(".xml")) {
                if (this.isXml()) {
                    this.processXmlFile(file);
                }
            } else if (name.endsWith(".html")) {
                if (this.isHtml()) {
                    this.processXmlFile(file);
                }
            } else if ((name.endsWith("makefile") || name.startsWith("makefile")) && this.isMakefiles()) {
                this.processMakefileFile(file);
            }
        }
        return true;
    }

    public void processJavaPackage(IPackageFragment javaPackage, boolean refresh) {
        try {
            if (this.isPackage() && javaPackage.exists() && javaPackage.containsJavaResources()) {
                PackageHtmlGenerator packageHtmlGenerator = new PackageHtmlGenerator(javaPackage);
                packageHtmlGenerator.generate();
            }
        }
        catch (JavaModelException exception) {
            exception.printStackTrace();
        }
        super.processJavaPackage(javaPackage, refresh);
    }

    public void processJavaProject(IJavaProject javaProject, boolean refresh) {
        super.processJavaProject(javaProject, refresh);
        if (this.isProject()) {
            IProject project = javaProject.getProject();
            try {
                CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void processMakefileFile(IFile file) {
        try {
            StringBuffer buffer = new StringBuffer(4096);
            StringBuffer copyrightBuffer = new StringBuffer(4096);
            InputStream is = file.getContents();
            String data = new String(this.readData(is));
            boolean found = false;
            StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String trimToken = token.trim();
                if (!found) {
                    if (trimToken.startsWith("#")) {
                        copyrightBuffer.append(token);
                        copyrightBuffer.append("\r\n");
                        continue;
                    }
                    if (copyrightBuffer.length() > 0) {
                        String oldCopyright = copyrightBuffer.toString();
                        int createYear = this.containsCopyright(oldCopyright);
                        buffer.append(this.getCopyrightStringProperties(createYear));
                        found = true;
                    }
                    buffer.append(token);
                    buffer.append("\r\n");
                    continue;
                }
                buffer.append(token);
                buffer.append("\r\n");
            }
            String newData = buffer.toString();
            if (!data.equals(newData)) {
                byte[] dataBytes = newData.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processManifest(IFile file) {
        block28: {
            try {
                String betterName;
                IFile locFile;
                if (!this.isManifest()) break block28;
                int betterCreateYear = -1;
                FileInputStream fis = new FileInputStream(file.getRawLocation().toFile());
                BufferedInputStream is = new BufferedInputStream(fis, 4096);
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                Set<Object> keys = attributes.keySet();
                Object[] objects = keys.toArray();
                boolean changed = false;
                Properties properties = new Properties();
                if (objects == null) break block28;
                IProject project = file.getProject();
                String key = "Bundle-Localization";
                String value = attributes.getValue(key);
                boolean delete = false;
                if (value == null) {
                    value = "OSGI-INF/l10n/bundle.properties";
                } else {
                    value = String.valueOf(value) + ".properties";
                    attributes.remove(key);
                    delete = true;
                }
                if (value != null && (locFile = project.getFile(value)).exists()) {
                    FileInputStream lfis = new FileInputStream(locFile.getRawLocation().toFile());
                    BufferedInputStream inStream = new BufferedInputStream(lfis, 4096);
                    properties.load(inStream);
                    inStream.close();
                    FileInputStream lfis2 = new FileInputStream(locFile.getRawLocation().toFile());
                    BufferedInputStream inStream2 = new BufferedInputStream(lfis2, 4096);
                    String data = new String(this.readData(inStream2));
                    betterCreateYear = this.containsCopyright(data);
                    inStream2.close();
                    if (locFile.exists() && delete) {
                        try {
                            locFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    changed = true;
                }
                if ((value = attributes.getValue(key = "Bundle-Version")) == null) {
                    attributes.putValue(key, String.valueOf(this.getVersion()) + ".qualifier");
                    changed = true;
                } else if (!(String.valueOf(this.getVersion()) + ".qualifier").equals(value)) {
                    attributes.putValue(key, String.valueOf(this.getVersion()) + ".qualifier");
                    changed = true;
                }
                key = "Bundle-Copyright";
                value = attributes.getValue(key);
                if (value == null) {
                    attributes.putValue(key, this.getCopyrightLine());
                    changed = true;
                } else {
                    String mergedCopyright;
                    int createYear;
                    if (value.startsWith("%")) {
                        if ((value = properties.getProperty(value.substring(1))) == null) {
                            value = attributes.getValue(key);
                        }
                        attributes.putValue(key, this.getCopyrightLine());
                    }
                    if ((createYear = this.containsCopyright(value)) < 1970) {
                        createYear = betterCreateYear;
                    }
                    if (!(mergedCopyright = GeneratorTemplates.getCopyrightLine((Map)GeneratorTemplates.getTemplateVariables((int)createYear))).equals(value)) {
                        attributes.putValue(key, mergedCopyright);
                        changed = true;
                    }
                }
                key = "Bundle-Vendor";
                value = attributes.getValue(key);
                if (value == null) {
                    attributes.putValue(key, this.getProvider());
                    changed = true;
                } else if (!this.getProvider().equals(value)) {
                    attributes.putValue(key, this.getProvider());
                    changed = true;
                }
                key = "Bundle-Name";
                value = attributes.getValue(key);
                if (value == null) {
                    betterName = CodeUtilities.betterNameFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    attributes.putValue(key, betterName);
                    changed = true;
                } else {
                    if (value.startsWith("%")) {
                        if ((value = properties.getProperty(value.substring(1))) == null) {
                            value = attributes.getValue(key);
                            attributes.putValue(key, value);
                        }
                        attributes.putValue(key, value);
                    }
                    betterName = CodeUtilities.betterNameFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    attributes.putValue(key, betterName);
                    changed = true;
                }
                key = "Bundle-Description";
                value = attributes.getValue(key);
                if (value == null) {
                    betterName = CodeUtilities.betterDescriptionFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    attributes.putValue(key, betterName);
                    changed = true;
                } else {
                    if (value.startsWith("%") && (value = properties.getProperty(value.substring(1))) == null) {
                        value = attributes.getValue(key);
                    }
                    betterName = CodeUtilities.betterDescriptionFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    attributes.putValue(key, betterName);
                }
                is.close();
                if (changed) {
                    this.outputTo(manifest, file);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void processPropertiesFile(IFile file) {
        try {
            if (this.isProperties()) {
                String name = file.getName();
                IProject project = file.getProject();
                InputStream is = file.getContents();
                String data = new String(this.readData(is));
                int createYear = this.containsCopyright(data);
                String copyright = GeneratorTemplates.getCopyrightPropertyString((Map)GeneratorTemplates.getTemplateVariables((int)createYear));
                StringBuffer buffer = new StringBuffer(4096);
                buffer.append(copyright);
                Properties properties = new Properties();
                InputStream inStream = file.getContents();
                properties.load(inStream);
                if (name.equals("build.properties")) {
                    String binIncludes = properties.getProperty("bin.includes", ".,META-INF/,OSGI-INF/,copyright.txt,about.html");
                    if (binIncludes.indexOf("OSGI-INF/") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)new NullProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",OSGI-INF/";
                    }
                    if (binIncludes.indexOf("copyright.txt") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)new NullProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",copyright.txt";
                    }
                    if (binIncludes.indexOf("about.html") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)new NullProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",about.html";
                    }
                    properties.put("bin.includes", binIncludes);
                }
                FixSourceOperation.outputPropertiesTo(buffer, properties);
                String newData = buffer.toString();
                if (!data.equals(newData)) {
                    byte[] dataBytes = newData.getBytes();
                    ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                    file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processPropertiesFile(IFile file, Properties properties) {
        try {
            String name;
            if (this.isProperties() && (name = file.getName()).toLowerCase().equals(name)) {
                if (file.exists()) {
                    InputStream is = file.getContents(true);
                    String data = new String(this.readData(is));
                    int createYear = this.containsCopyright(data);
                    String copyright = GeneratorTemplates.getCopyrightPropertyString((Map)GeneratorTemplates.getTemplateVariables((int)createYear));
                    StringBuffer buffer = new StringBuffer(4096);
                    buffer.append(copyright);
                    FixSourceOperation.outputPropertiesTo(buffer, properties);
                    String newData = buffer.toString();
                    if (!data.equals(newData)) {
                        byte[] dataBytes = newData.getBytes();
                        ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                        file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else {
                    String copyright = GeneratorTemplates.getCopyrightPropertyString((Map)GeneratorTemplates.getTemplateVariables((int)-1));
                    StringBuffer buffer = new StringBuffer(4096);
                    buffer.append(copyright);
                    FixSourceOperation.outputPropertiesTo(buffer, properties);
                    String newData = buffer.toString();
                    byte[] dataBytes = newData.getBytes();
                    ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                    file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processXmlFile(IFile file) {
        try {
            boolean devicekit = file.getParent().getName().equals("dk");
            StringBuffer buffer = new StringBuffer(4096);
            StringBuffer copyrightBuffer = new StringBuffer(4096);
            InputStream is = file.getContents();
            String data = new String(this.readData(is));
            boolean found = false;
            StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String trimToken = token.trim();
                if (!found) {
                    if (trimToken.startsWith("<!--")) {
                        copyrightBuffer.append(token);
                        copyrightBuffer.append("\r\n");
                        continue;
                    }
                    if (copyrightBuffer.length() > 0) {
                        String oldCopyright = copyrightBuffer.toString();
                        int createYear = this.containsCopyright(oldCopyright);
                        buffer.append(this.getCopyrightXmlString(createYear));
                        if (devicekit || oldCopyright.indexOf("WARNING") >= 0) {
                            buffer.append(GeneratorTemplates.getXmlWarning((Map)GeneratorTemplates.getTemplateVariables((int)createYear)));
                        }
                        found = true;
                    }
                    buffer.append(token);
                    buffer.append("\r\n");
                    continue;
                }
                buffer.append(token);
                buffer.append("\r\n");
            }
            String newData = buffer.toString();
            if (!data.equals(newData)) {
                byte[] dataBytes = newData.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

