/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.utility.operation;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Hashtable;
import org.eclipse.soda.devicekit.ui.utility.operation.TemplateInputStream;

public class Template {
    private static Template current = new Template();
    private Hashtable variables = new Hashtable();
    private Hashtable entities = new Hashtable();

    public static Template getCurrent() {
        return current;
    }

    public void addEntity(String key, String value) {
        this.getEntities().put(key, value);
        this.getEntities().put(key.toLowerCase(), value.toLowerCase());
        this.getEntities().put(key.toUpperCase(), value.toUpperCase());
    }

    public void addVariable(String key, String value) {
        this.getVariables().put(key, value);
        this.getVariables().put(key.toLowerCase(), value.toLowerCase());
        this.getVariables().put(key.toUpperCase(), value.toUpperCase());
    }

    public Hashtable getEntities() {
        return this.entities;
    }

    public String getEntity(String key) {
        return (String)this.getEntities().get(key);
    }

    public String getVariable(String key) {
        return (String)this.getVariables().get(key);
    }

    public Hashtable getVariables() {
        return this.variables;
    }

    public void setEntities(Hashtable entities) {
        this.entities = entities;
    }

    public void setVariables(Hashtable variables) {
        this.variables = variables;
    }

    public InputStream template(String name) throws Exception {
        String day;
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            int index = name.indexOf(92);
            if (index > 0) {
                return this.template(name.substring(index + 1));
            }
            throw new RuntimeException("Can not open template: " + name);
        }
        TemplateInputStream ssiStream = new TemplateInputStream(in);
        ssiStream.setVariables(this.getVariables());
        ssiStream.setEntities(this.getEntities());
        String year = Integer.toString(Calendar.getInstance().get(1));
        ssiStream.addEntity("Year", year);
        String month = Integer.toString(Calendar.getInstance().get(2) + 1);
        ssiStream.addEntity("Month", month);
        if (month.length() < 2) {
            month = "0" + month;
        }
        if ((day = Integer.toString(Calendar.getInstance().get(5))).length() < 2) {
            day = "0" + day;
        }
        ssiStream.addEntity("Day", day);
        ssiStream.addEntity("Date", String.valueOf(year) + "/" + month + "/" + day);
        return ssiStream;
    }
}

