/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.wizard;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.model.java.JavaKeywords;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.ui.wizard.WizardMessages;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.soda.devicekit.util.VersionValidator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class DeviceKitBasePage
extends DeviceKitPage {
    private static IWizardMessages messages = WizardMessages.getInstance();

    public DeviceKitBasePage(String pageName) {
        super(pageName);
    }

    public DeviceKitBasePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createAnyImplementation(Composite composite) {
    }

    protected void createCommonControl(Composite composite) {
        String[] keys = this.getCommonTextKeys();
        int i = 0;
        while (i < keys.length) {
            if (i == 0) {
                Text text;
                String[] nameChoices = this.getNameChoices();
                if (nameChoices.length == 0) {
                    text = this.createTextControl(composite, keys[i]);
                    text.setFocus();
                } else {
                    text = this.createComboControl(composite, keys[i], nameChoices, 2048);
                    text.setFocus();
                }
                this.createAnyImplementation(composite);
            } else {
                this.createTextControl(composite, keys[i]);
            }
            ++i;
        }
    }

    protected void createCommonOptions(Composite composite) {
        String labelString = this.getString("options");
        final Button button = this.createCheckBoxControl(composite, "abstract", labelString);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean state = button.getSelection();
                ((Button)DeviceKitBasePage.this.getWidget("create.bundle")).setSelection(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.bundle")).setSelection(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.factory.bundle")).setSelection(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.bundle")).setEnabled(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.bundle")).setEnabled(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.factory.bundle")).setEnabled(!state);
            }
        });
        if (this.isDisplayTest()) {
            this.createCheckBoxControl(composite, "create.test");
        }
        this.createCheckBoxControl(composite, "create.testcase");
        this.createCheckBoxControl(composite, "create.bundle");
        this.createCheckBoxControl(composite, "create.managed.bundle");
        this.createCheckBoxControl(composite, "create.managed.factory.bundle");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setMessage(this.getDefaultMessage());
        Composite composite = new Composite(parent, 0);
        Dialog.applyDialogFont((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createCommonControl(composite);
        this.createCustomControl(composite);
        this.updatePageCompletion();
        Dialog.applyDialogFont((Control)composite);
        composite.layout(true);
        this.setControl((Control)composite);
        parent.layout(true);
        parent.redraw();
    }

    protected abstract void createCustomControl(Composite var1);

    public String[] getChoices(String[] choices, String[] exists) {
        if (exists.length > 0) {
            String[] validChoices = new String[]{};
            int i = 0;
            while (i < choices.length) {
                if (Arrays.binarySearch(exists, choices[i]) < 0) {
                    String[] newChoices = new String[validChoices.length + 1];
                    System.arraycopy(validChoices, 0, newChoices, 0, validChoices.length);
                    newChoices[validChoices.length] = choices[i];
                    validChoices = newChoices;
                }
                ++i;
            }
            return validChoices;
        }
        return choices;
    }

    protected String[] getCommonTextKeys() {
        return COMMON_TEXT_KEYS;
    }

    protected String getDefaultMessage() {
        String unformattedMessage = this.getString("default.message");
        String name = this.getWidgetText("name");
        String message = "";
        String type = this.getString(this.getKey());
        name = String.valueOf(name) + type;
        if (GeneratorPlugin.useEclipse32Names()) {
            name = this.transformToNewName(name);
        }
        message = Nls.format((String)unformattedMessage, (Object[])new String[]{type, name});
        if (this.canFlipToNextPage()) {
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append(message);
            buffer.append("\r\n");
            buffer.append("Please go to the next page.");
            return buffer.toString();
        }
        return message;
    }

    public String[] getNameChoices() {
        return new String[0];
    }

    public String[] getNameShortAdapter() {
        return this.getNamesShort("Adapter");
    }

    public String[] getNameShortAdapterChoices() {
        return this.getChoices(this.getNameShortDevice(), this.getNameShortAdapter());
    }

    public String[] getNameShortAdapterTest() {
        return this.getNamesShort("AdapterTest", "adapter_test");
    }

    public String[] getNameShortAdapterTestChoices() {
        return this.getChoices(this.getNameShortAdapter(), this.getNameShortAdapterTest());
    }

    public String[] getNameShortAgent() {
        return this.getNamesShort("Agent");
    }

    public String[] getNameShortDevice() {
        return this.getNamesShort("Device");
    }

    public String[] getNameShortDeviceChoices() {
        return this.getChoices(this.getNameShortTransport(), this.getNameShortDevice());
    }

    public String[] getNameShortDeviceTest() {
        return this.getNamesShort("DeviceTest", "device_test");
    }

    public String[] getNameShortDeviceTestChoices() {
        return this.getChoices(this.getNameShortDevice(), this.getNameShortDeviceTest());
    }

    public String[] getNameShortProfile() {
        return this.getNamesShort("Profile");
    }

    public String[] getNameShortProfileTest() {
        return this.getNamesShort("ProfileTest", "profile_test");
    }

    public String[] getNameShortProfileTestChoices() {
        return this.getChoices(this.getNameShortProfile(), this.getNameShortProfileTest());
    }

    public String[] getNameShortTransport() {
        return this.getNamesShort("Transport");
    }

    public String[] getNameShortTransportTest() {
        return this.getNamesShort("TransportTest", "transport_test");
    }

    public String[] getNameShortTransportTestChoices() {
        return this.getChoices(this.getNameShortTransport(), this.getNameShortTransportTest());
    }

    public String[] getNamesShort(String type) {
        return this.getNamesShort(type, type.toLowerCase());
    }

    public String[] getNamesShort(String type, String filename) {
        try {
            DkmlFileFinder finder = this.getFinder();
            String[] names = finder.getNames(filename);
            Object[] shortNames = new String[names.length];
            int i = 0;
            while (i < names.length) {
                shortNames[i] = names[i].endsWith(type) ? names[i].substring(0, names[i].length() - type.length()) : names[i];
                ++i;
            }
            Arrays.sort(shortNames);
            return shortNames;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    protected String getPackageBase() {
        Text packageBaseText = (Text)this.getWidget("packagebase");
        if (packageBaseText == null) {
            return new String();
        }
        return packageBaseText.getText();
    }

    public String getString(String key) {
        return messages.getString(key);
    }

    public String getWidgetText(String id) {
        Widget widget = this.getWidget(id);
        if (widget instanceof Text) {
            return ((Text)widget).getText();
        }
        if (widget instanceof Combo) {
            return ((Combo)widget).getText();
        }
        return "";
    }

    public boolean isDisplayTest() {
        return !this.isTest();
    }

    protected boolean isJavaKeyword(String segment) {
        String[] keywords = JavaKeywords.keywords;
        int i = 0;
        while (i < keywords.length) {
            if (segment.equalsIgnoreCase(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean nameOk() {
        String value = this.getWidgetText("name");
        String typeName = this.getTypeName();
        if (value.length() == 0) {
            String message = this.getString("name.empty");
            this.update(false, false, null, message);
            return false;
        }
        if (value.indexOf(46) > 0) {
            String errorMessage = this.getString("name.error");
            this.update(false, false, errorMessage, null);
            return false;
        }
        if (value.endsWith(typeName)) {
            String errorMessage = this.getString("name.end");
            this.update(false, false, errorMessage, null);
            return false;
        }
        if (!this.validName(value)) {
            return false;
        }
        if (this.projectExists(String.valueOf(value) + typeName)) {
            String errorMessageUnformatted = this.getString("project.already.exists");
            String errorMessage = Nls.format((String)errorMessageUnformatted, (Object[])new String[]{String.valueOf(value) + typeName});
            this.update(false, false, errorMessage, null);
            return false;
        }
        return true;
    }

    protected boolean packageBaseOk() {
        String packageBase = this.getPackageBase();
        if (packageBase.trim().length() > 0) {
            IStatus status = JavaConventions.validatePackageName((String)packageBase);
            boolean valid = status.isOK();
            if (!valid) {
                String errorMessage = status.getMessage();
                this.update(false, false, errorMessage, null);
                return false;
            }
        } else {
            String errorMessage = this.getString("packagebase.empty");
            this.update(false, false, null, errorMessage);
            return false;
        }
        return true;
    }

    protected String transformToNewName(String oldName) {
        String packageBase = this.getPackageBase();
        return DeviceKitUtilities.getPackageFromClassName((String)oldName, (String)packageBase);
    }

    protected boolean updatePageErrors() {
        if (!this.nameOk()) {
            return false;
        }
        if (!this.packageBaseOk()) {
            return false;
        }
        if (!this.versionOk()) {
            return false;
        }
        this.update(true, this.getNextPage() != null, null, null);
        return true;
    }

    protected boolean validName(String name) {
        int length = name.length();
        if (length > 0) {
            if (this.isJavaKeyword(name)) {
                String unformattedErrorMessage = this.getString("java.keyword");
                String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)name);
                this.update(false, false, errorMessage, null);
                return false;
            }
            if (!Character.isUpperCase(name.charAt(0))) {
                String unformattedErrorMessage = this.getString("invalid.start");
                String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)name);
                this.update(false, false, errorMessage, null);
                return false;
            }
            StringBuffer buffer = new StringBuffer(name.length());
            int i = 0;
            while (i < name.length()) {
                boolean invalidCharacter;
                char c = name.charAt(i);
                if (i == name.length() - 1 && Character.isLowerCase(c)) {
                    buffer.append(c);
                }
                if (Character.isUpperCase(c) && i != 0 || i == name.length() - 1) {
                    if (this.isJavaKeyword(buffer.toString())) {
                        String unformattedErrorMessage = this.getString("java.keyword");
                        String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)buffer.toString());
                        this.update(false, false, errorMessage, null);
                        return false;
                    }
                    buffer = new StringBuffer(name.length());
                }
                buffer.append(c);
                boolean bl = invalidCharacter = c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z';
                if (GeneratorPlugin.useEclipse32Names() && c == '.') {
                    invalidCharacter = false;
                }
                if (invalidCharacter) {
                    String unformattedErrorMessage = this.getString("invalid.char");
                    String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)new Character(c));
                    this.update(false, false, errorMessage, null);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean versionOk() {
        Text versionText = (Text)this.getWidget("version");
        if (versionText == null) {
            return false;
        }
        String version = versionText.getText();
        if (version.trim().length() > 0) {
            boolean valid = VersionValidator.isValidVersion((String)version);
            if (!valid) {
                String errorMessage = this.getString("version.invalid");
                this.update(false, false, errorMessage, null);
                return false;
            }
        } else {
            String errorMessage = this.getString("version.empty");
            this.update(false, false, null, errorMessage);
            return false;
        }
        return true;
    }
}

