/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.soda.devicekit.ui.common.wizard.SpecPage;
import org.eclipse.soda.devicekit.ui.operation.ComputeClassPathOperation;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.ui.wizard.WizardMessages;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;
import org.eclipse.soda.devicekit.util.ProjectUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class DeviceKitWizard
extends Wizard {
    private DkmlFileFinder finder;

    public DeviceKitWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addSpecPage() {
        this.addPage((IWizardPage)new SpecPage("spec"));
    }

    protected void executeComputeClassPath(IJavaProject jProject) throws InterruptedException, InvocationTargetException {
        block1: {
            boolean done;
            String[] oldErrors;
            String[] newErrors;
            int count = 0;
            if (!jProject.exists()) break block1;
            do {
                oldErrors = ProjectUtil.getProjectErrors((IJavaProject)jProject);
                ComputeClassPathOperation op = new ComputeClassPathOperation(jProject, true);
                this.getContainer().run(false, true, (IRunnableWithProgress)op);
            } while ((newErrors = ProjectUtil.getProjectErrors((IJavaProject)jProject)).length != 0 && (newErrors.length != oldErrors.length || !(done = ProjectUtil.compareErrors((String[])oldErrors, (String[])newErrors))) && ++count < 5);
        }
    }

    protected void executeComputeImports(IJavaProject jProject) throws InterruptedException, InvocationTargetException {
    }

    protected void executeOrganizeImports(IJavaProject jProject) throws InterruptedException, InvocationTargetException {
    }

    protected ICompilationUnit[] getCompilationUnits(IJavaProject proj) throws JavaModelException {
        Vector<ICompilationUnit> vCus = new Vector<ICompilationUnit>();
        IPackageFragmentRoot[] roots = proj.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getJavaProject() == proj) {
                IJavaElement[] children = roots[i].getChildren();
                int j = 0;
                while (j < children.length) {
                    IPackageFragment pack;
                    if (children[j] instanceof IPackageFragment && (pack = (IPackageFragment)children[j]).getKind() == 1) {
                        ICompilationUnit[] pCus = pack.getCompilationUnits();
                        int k = 0;
                        while (k < pCus.length) {
                            vCus.add(pCus[k]);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] cus = new ICompilationUnit[vCus.size()];
        vCus.copyInto(cus);
        return cus;
    }

    public DkmlFileFinder getFinder() {
        if (this.finder == null) {
            this.finder = new DkmlFileFinder();
        }
        return this.finder;
    }

    public abstract IWorkspaceRunnable getOperation();

    public String getWindowTitle() {
        return this.getWizardTitle();
    }

    public abstract String getWizardTitle();

    protected boolean handleError(Throwable t) {
        t.printStackTrace();
        IWizardMessages messages = WizardMessages.getInstance();
        String message = t.getMessage();
        if (message == null || message.length() == 0) {
            message = t.toString();
        }
        if (t instanceof CoreException) {
            ErrorDialog.openError((Shell)this.getShell(), (String)messages.getString("devicekit.error"), null, (IStatus)((CoreException)t).getStatus());
            return false;
        }
        Throwable newT = t;
        if (t instanceof InvocationTargetException) {
            newT = ((InvocationTargetException)t).getTargetException();
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)messages.getString("devicekit.error"), (String)newT.toString(), (IStatus)new Status(4, "org.eclipse.ui", 0, message, newT));
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void performExtraOperations(List projects) throws InterruptedException, InvocationTargetException {
        if (projects != null) {
            int i = 0;
            while (i < projects.size()) {
                IJavaProject jProject = (IJavaProject)projects.get(i);
                if (jProject.exists()) {
                    this.executeComputeClassPath(jProject);
                    this.executeOrganizeImports(jProject);
                    this.executeComputeImports(jProject);
                }
                ++i;
            }
        }
    }

    public boolean performFinish() {
        final IWorkspaceRunnable fop = this.getOperation();
        WorkspaceModifyOperation mop = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    fop.run(monitor);
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RuntimeException(exception.toString());
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)mop);
        }
        catch (Exception e) {
            return this.handleError(e);
        }
        return true;
    }

    public void setFinder(DkmlFileFinder finder) {
        this.finder = finder;
    }
}

