/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.profile.test.agent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.profile.test.agent.ProfileAbstractTestCase;
import org.eclipse.soda.dk.rfid.inventory.profile.test.agent.RfidInventoryProfileTestAgent;
import org.eclipse.soda.dk.testagent.util.NotificationProbe;

public abstract class RfidInventoryProfileAbstractTestCase
extends ProfileAbstractTestCase {
    protected static final int DEFAULT_TAG_READ_DURATION = 3000;
    protected static final String AND_EXPRESSION = "(&(i1=true)(b32=true)(l2=1))";
    protected static final String OR_EXPRESSION = "(|(i32=true)(b1=true))";
    protected static final String INVALID_EXPRESSION = "i1=true";
    protected static final String INVALID_MASK = "a,0";
    protected static final long BIT_1 = 1L;
    protected static final long BIT_2 = 2L;
    protected static final long BIT_32 = Integer.MIN_VALUE;
    protected String readerIdProperty;
    protected String tagListProperty;
    protected String tagMaskProperty;
    protected int readDurationProperty;
    protected String rfidInventoryProfileServiceStatusExternalKey;
    protected String rfidInventoryProfileServiceCapabilitiesExternalKey;
    protected String rfidInventoryProfileServiceConfigurationExternalKey;
    protected String rfidInventoryProfileServiceTagReadingExpressionExternalKey;
    protected String rfidInventoryProfileServiceTagReadingExternalKey;
    protected String rfidInventoryProfileServiceTagAggregatingExpressionExternalKey;
    protected String rfidInventoryProfileServiceTagAggregatingExternalKey;
    protected String rfidInventoryProfileServiceTagMaskSettingExternalKey;
    protected String rfidInventoryProfileServiceDuplicateFilteringExternalKey;
    protected String rfidInventoryProfileServiceDuplicateFilteringExpressionExternalKey;
    protected String rfidInventoryProfileServiceAggregationMaskSettingExternalKey;
    protected String rfidInventoryProfileServiceDataExtensionsExternalKey;
    protected String rfidInventoryProfileServiceTagReportExternalKey;
    protected String rfidInventoryProfileServiceTagAggregationReportExternalKey;
    protected String gpioProfileServiceInputExternalKey;
    protected String controlProfileServiceBitsExternalKey;
    protected String controlProfileServiceLongsExternalKey;
    protected Set configuredTags;
    protected Set interestedTags;

    public RfidInventoryProfileAbstractTestCase(String name) {
        super(name);
    }

    protected int countTagAggregationReports() {
        NotificationProbe probe = this.getProbe();
        return probe.countKeyPublished(this.rfidInventoryProfileServiceTagAggregationReportExternalKey);
    }

    protected int countTagReports() {
        NotificationProbe probe = this.getProbe();
        return probe.countKeyPublished(this.rfidInventoryProfileServiceTagReportExternalKey);
    }

    protected String getAggregationMaskSetting() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidInventoryProfileServiceAggregationMaskSettingExternalKey);
    }

    protected ArrayList getAllTagAggregationReports() {
        NotificationProbe probe = this.getProbe();
        return probe.getAllPublishedValues(this.rfidInventoryProfileServiceTagAggregationReportExternalKey, "value");
    }

    protected ArrayList getAllTagReports() {
        NotificationProbe probe = this.getProbe();
        return probe.getAllPublishedValues(this.rfidInventoryProfileServiceTagReportExternalKey, "value");
    }

    protected Map getBitsData(long bits) {
        long b = bits;
        HashMap<String, Boolean> value = new HashMap<String, Boolean>();
        int i = 1;
        while (i <= 32) {
            Boolean bitValue = (b & 1L) == 0L ? Boolean.FALSE : Boolean.TRUE;
            value.put("b" + i, bitValue);
            b >>>= 1;
            ++i;
        }
        return value;
    }

    protected Dictionary getCapabilities() throws InterruptedException {
        return (Dictionary)this.getMeasurement(this.rfidInventoryProfileServiceCapabilitiesExternalKey, "RfidInventoryProfile/Capabilities");
    }

    protected Dictionary getConfiguration() throws InterruptedException {
        return (Dictionary)this.getMeasurement(this.rfidInventoryProfileServiceConfigurationExternalKey, "RfidInventoryProfile/Configuration");
    }

    protected Map getDataExtensions() throws InterruptedException {
        return (Map)this.getMeasurement(this.rfidInventoryProfileServiceDataExtensionsExternalKey);
    }

    protected Boolean getDuplicateFiltering() throws InterruptedException {
        return (Boolean)this.getMeasurement(this.rfidInventoryProfileServiceDuplicateFilteringExternalKey);
    }

    protected String getDuplicateFilteringExpression() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidInventoryProfileServiceDuplicateFilteringExpressionExternalKey);
    }

    protected String[] getExternalKeys() {
        return super.getExternalKeys();
    }

    protected Map getInputsData(long bits) {
        long b = bits;
        HashMap<String, Boolean> value = new HashMap<String, Boolean>();
        int i = 1;
        while (i <= 32) {
            Boolean bitValue = (b & 1L) == 0L ? Boolean.FALSE : Boolean.TRUE;
            value.put("i" + i, bitValue);
            b >>>= 1;
            ++i;
        }
        return value;
    }

    protected void getKeysAndSettingsFromProperties() {
        super.getKeysAndSettingsFromProperties();
        this.rfidInventoryProfileServiceStatusExternalKey = this.prependPrefix("RfidInventoryProfile/Status");
        this.rfidInventoryProfileServiceCapabilitiesExternalKey = this.prependPrefix("RfidInventoryProfile/Capabilities");
        this.rfidInventoryProfileServiceConfigurationExternalKey = this.prependPrefix("RfidInventoryProfile/Configuration");
        this.rfidInventoryProfileServiceTagReadingExpressionExternalKey = this.prependPrefix("RfidInventory/TagReadingExpression");
        this.rfidInventoryProfileServiceTagReadingExternalKey = this.prependPrefix("RfidInventory/TagReading");
        this.rfidInventoryProfileServiceTagAggregatingExpressionExternalKey = this.prependPrefix("RfidInventory/TagAggregatingExpression");
        this.rfidInventoryProfileServiceTagAggregatingExternalKey = this.prependPrefix("RfidInventory/TagAggregating");
        this.rfidInventoryProfileServiceTagMaskSettingExternalKey = this.prependPrefix("RfidInventory/TagMaskSetting");
        this.rfidInventoryProfileServiceDuplicateFilteringExternalKey = this.prependPrefix("RfidInventory/DuplicateFiltering");
        this.rfidInventoryProfileServiceDuplicateFilteringExpressionExternalKey = this.prependPrefix("RfidInventory/DuplicateFilteringExpression");
        this.rfidInventoryProfileServiceAggregationMaskSettingExternalKey = this.prependPrefix("RfidInventory/AggregationMaskSetting");
        this.rfidInventoryProfileServiceDataExtensionsExternalKey = this.prependPrefix("RfidInventory/DataExtensions");
        this.rfidInventoryProfileServiceTagReportExternalKey = this.prependPrefix("RfidInventory/TagReport");
        this.rfidInventoryProfileServiceTagAggregationReportExternalKey = this.prependPrefix("RfidInventory/TagAggregationReport");
        this.gpioProfileServiceInputExternalKey = this.prependPrefix("Gpio/Input");
        this.controlProfileServiceBitsExternalKey = this.prependPrefix("Control/Bits");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix("Control/Longs");
        this.readerIdProperty = this.getString("expected.readerid", this.prefixProperty);
        this.tagListProperty = this.getString("taglist", "");
        this.tagMaskProperty = this.getString("tagmask", "");
        this.readDurationProperty = this.getInt("read.duration.ms", 3000);
        this.setConfiguredTags();
        this.setInterestedTags();
    }

    protected Map getLastTagAggregationReport() {
        NotificationProbe probe = this.getProbe();
        return (Map)probe.getLastPublishedValue(this.rfidInventoryProfileServiceTagAggregationReportExternalKey, "value");
    }

    protected Map getLastTagReport() {
        NotificationProbe probe = this.getProbe();
        return (Map)probe.getLastPublishedValue(this.rfidInventoryProfileServiceTagReportExternalKey, "value");
    }

    protected Map getLongsData(long bits) {
        long b = bits;
        HashMap<String, Long> value = new HashMap<String, Long>();
        int i = 1;
        while (i <= 32) {
            Long bitValue = new Long((b & 1L) == 0L ? 0 : 1);
            value.put("l" + i, bitValue);
            b >>>= 1;
            ++i;
        }
        return value;
    }

    public NotificationService getNotificationService() {
        return super.getNotificationService();
    }

    protected Dictionary getStatus() throws InterruptedException {
        return (Dictionary)this.getMeasurement(this.rfidInventoryProfileServiceStatusExternalKey);
    }

    protected Boolean getTagAggregating() throws InterruptedException {
        return (Boolean)this.getMeasurement(this.rfidInventoryProfileServiceTagAggregatingExternalKey);
    }

    protected String getTagAggregatingExpression() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidInventoryProfileServiceTagAggregatingExpressionExternalKey);
    }

    protected String getTagMaskSetting() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidInventoryProfileServiceTagMaskSettingExternalKey);
    }

    protected Boolean getTagReading() throws InterruptedException {
        return (Boolean)this.getMeasurement(this.rfidInventoryProfileServiceTagReadingExternalKey);
    }

    protected String getTagReadingExpression() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidInventoryProfileServiceTagReadingExpressionExternalKey);
    }

    protected List getTagsFromTagAggregationReports(Map expectedDataExtensions) {
        ArrayList tagReports = this.getAllTagAggregationReports();
        List tags = this.verifyTagReads(tagReports, expectedDataExtensions);
        return tags;
    }

    protected List getTagsFromTagReports(Map expectedDataExtensions) {
        ArrayList tagReports = this.getAllTagReports();
        List tags = this.verifyTagReads(tagReports, expectedDataExtensions);
        return tags;
    }

    protected String readAggregationMaskSetting() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidInventoryProfileServiceAggregationMaskSettingExternalKey);
    }

    protected void readAndVerifyTags(Set expectedTags, Map expectedDataExtensions, boolean noDuplicatesAllowed) throws InterruptedException {
        this.writeTagReading(Boolean.TRUE);
        this.waitForTagReports(expectedTags.size() * 2, this.readDurationProperty);
        this.writeTagReading(Boolean.FALSE);
        this.verifyExpectedTagsReceived(expectedTags, expectedDataExtensions, noDuplicatesAllowed);
        this.verifyNoAggregationReceived();
    }

    protected Map readDataExtensions() throws InterruptedException {
        return (Map)this.readMeasurement(this.rfidInventoryProfileServiceDataExtensionsExternalKey);
    }

    protected Boolean readDuplicateFiltering() throws InterruptedException {
        return (Boolean)this.readMeasurement(this.rfidInventoryProfileServiceDuplicateFilteringExternalKey);
    }

    protected String readDuplicateFilteringExpression() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidInventoryProfileServiceDuplicateFilteringExpressionExternalKey);
    }

    protected Boolean readTagAggregating() throws InterruptedException {
        return (Boolean)this.readMeasurement(this.rfidInventoryProfileServiceTagAggregatingExternalKey);
    }

    protected String readTagAggregatingExpression() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidInventoryProfileServiceTagAggregatingExpressionExternalKey);
    }

    protected String readTagMaskSetting() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidInventoryProfileServiceTagMaskSettingExternalKey);
    }

    protected Boolean readTagReading() throws InterruptedException {
        return (Boolean)this.readMeasurement(this.rfidInventoryProfileServiceTagReadingExternalKey);
    }

    protected String readTagReadingExpression() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidInventoryProfileServiceTagReadingExpressionExternalKey);
    }

    protected void reportBits(Map dataValue) {
        this.reportMeasurement(this.controlProfileServiceBitsExternalKey, dataValue);
    }

    protected void reportInput(Map dataValue) {
        this.reportMeasurement(this.gpioProfileServiceInputExternalKey, dataValue);
    }

    protected void reportLongs(Map dataValue) {
        this.reportMeasurement(this.controlProfileServiceLongsExternalKey, dataValue);
    }

    private void setConfiguredTags() {
        String[] tags = RfidInventoryProfileAbstractTestCase.parseDelimitedByToken((String)this.tagListProperty, (String)",");
        this.configuredTags = new HashSet(tags.length);
        this.configuredTags.addAll(Arrays.asList(tags));
    }

    private void setInterestedTags() {
        String[] tags = RfidInventoryProfileAbstractTestCase.parseDelimitedByToken((String)this.tagListProperty, (String)",");
        String[] maskConfigs = RfidInventoryProfileAbstractTestCase.parseDelimitedByToken((String)this.tagMaskProperty, (String)";");
        this.interestedTags = new HashSet(tags.length);
        InterestMasks interestMasks = new InterestMasks();
        int i = 0;
        while (i < maskConfigs.length) {
            InterestService interestMask = RfidInventoryProfileAbstractTestCase.parseInterestMask((String)maskConfigs[i]);
            interestMasks.add(interestMask);
            ++i;
        }
        i = 0;
        while (i < tags.length) {
            String tag = tags[i];
            byte[] data = RfidInventoryProfileAbstractTestCase.toBytes((String)tag);
            if (interestMasks.isInterested(data)) {
                this.interestedTags.add(tag);
            }
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        this.writeTagAggregatingExpression("");
        this.writeTagReadingExpression("");
        this.writeDuplicateFilteringExpression("");
        this.writeTagMaskSetting("");
        this.writeAggregationMaskSetting("");
        this.writeTagReading(Boolean.FALSE);
        this.writeTagAggregating(Boolean.FALSE);
        this.writeDuplicateFiltering(Boolean.FALSE);
        super.tearDown();
    }

    protected void verifyAggregationReceived(Set expectedTags, Map expectedDataExtensions, boolean noDuplicatesAllowed) throws InterruptedException {
        int count = this.waitForTagAggregationReports(1, this.maxResponseWaitingTimeProperty);
        RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7520)), (int)1, (int)count);
        List receivedTags = this.getTagsFromTagAggregationReports(expectedDataExtensions);
        HashSet receivedTagSet = new HashSet(receivedTags);
        if (noDuplicatesAllowed) {
            RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7521)), (int)receivedTagSet.size(), (int)receivedTags.size());
        }
        RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7522)), (Object)expectedTags, receivedTagSet);
    }

    public void verifyDuplicateFiltering(Set expectedTags) throws InterruptedException {
        this.writeDuplicateFiltering(Boolean.TRUE);
        this.writeTagAggregating(Boolean.TRUE);
        this.readAndVerifyTags(expectedTags, null, true);
        this.writeDuplicateFiltering(Boolean.FALSE);
        this.writeTagAggregating(Boolean.FALSE);
        this.verifyAggregationReceived(expectedTags, null, true);
    }

    public void verifyDuplicateFilteringExpression(Set expectedTags) throws InterruptedException {
        this.writeDuplicateFilteringExpression(OR_EXPRESSION);
        this.reportInput(this.getInputsData(Integer.MIN_VALUE));
        this.writeTagAggregating(Boolean.TRUE);
        this.readAndVerifyTags(expectedTags, null, true);
        this.reportInput(this.getInputsData(0L));
        this.writeTagAggregating(Boolean.FALSE);
        this.verifyAggregationReceived(expectedTags, null, true);
    }

    protected void verifyExpectedTagsReceived(Set expectedTags, Map expectedDataExtensions, boolean noDuplicatesAllowed) {
        List receivedTags = this.getTagsFromTagReports(expectedDataExtensions);
        HashSet receivedTagSet = new HashSet(receivedTags);
        if (noDuplicatesAllowed) {
            RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7523)), (int)receivedTagSet.size(), (int)receivedTags.size());
        }
        RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7524)), (Object)expectedTags, receivedTagSet);
    }

    protected void verifyNoAggregationReceived() {
        int count = this.countTagAggregationReports();
        RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7520)), (int)0, (int)count);
    }

    public void verifyTagAggregatingExpression(Set expectedTags) throws InterruptedException {
        this.writeTagAggregatingExpression(AND_EXPRESSION);
        this.writeTagReadingExpression(OR_EXPRESSION);
        this.reportInput(this.getInputsData(1L));
        this.reportBits(this.getBitsData(-2147483647L));
        this.reportLongs(this.getLongsData(2L));
        this.waitForTagReports(2, this.readDurationProperty);
        this.reportBits(this.getBitsData(Integer.MIN_VALUE));
        this.verifyExpectedTagsReceived(expectedTags, null, false);
        this.verifyNoAggregationReceived();
        this.reportInput(this.getInputsData(0L));
        this.verifyAggregationReceived(expectedTags, null, false);
        this.reportBits(this.getBitsData(0L));
        this.reportLongs(this.getLongsData(0L));
    }

    public void verifyTagReadingAndAggregation(Set expectedTags) throws InterruptedException {
        this.verifyTagReadingAndAggregation(expectedTags, null);
    }

    public void verifyTagReadingAndAggregation(Set expectedTags, Map expectedDataExtensions) throws InterruptedException {
        this.writeTagAggregating(Boolean.TRUE);
        this.readAndVerifyTags(expectedTags, expectedDataExtensions, false);
        this.writeTagAggregating(Boolean.FALSE);
        this.verifyAggregationReceived(expectedTags, expectedDataExtensions, false);
    }

    public void verifyTagReadingExpression(Set expectedTags) throws InterruptedException {
        this.writeTagAggregatingExpression(AND_EXPRESSION);
        this.writeTagReadingExpression(OR_EXPRESSION);
        this.reportInput(this.getInputsData(-2147483647L));
        this.waitForTagReports(2, this.readDurationProperty);
        this.reportInput(this.getInputsData(0L));
        this.verifyExpectedTagsReceived(expectedTags, null, false);
        this.verifyNoAggregationReceived();
    }

    protected List verifyTagReads(ArrayList tagReports, Map expectedDataExtensions) {
        ArrayList<String> tagList = new ArrayList<String>();
        Iterator iter = tagReports.iterator();
        while (iter.hasNext()) {
            Map tagReport = (Map)iter.next();
            Map tagReads = (Map)tagReport.get("tags");
            Iterator tags = tagReads.keySet().iterator();
            while (tags.hasNext()) {
                String tag = (String)tags.next();
                tagList.add(tag);
                Map tagData = (Map)tagReads.get(tag);
                Integer antenna = (Integer)tagData.get("antenna");
                if (antenna != null) {
                    RfidInventoryProfileAbstractTestCase.assertTrue((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7525)), (antenna >= 0 ? 1 : 0) != 0);
                }
                Integer count = (Integer)tagData.get("count");
                RfidInventoryProfileAbstractTestCase.assertTrue((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7526)), (count > 0 ? 1 : 0) != 0);
                String reader = (String)tagData.get("reader");
                RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7527)), (String)this.readerIdProperty, (String)reader);
                Long timestampFirst = (Long)tagData.get("timestampFirst");
                RfidInventoryProfileAbstractTestCase.assertTrue((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7528)), (timestampFirst > 0L ? 1 : 0) != 0);
                Long timestampLast = (Long)tagData.get("timestampLast");
                RfidInventoryProfileAbstractTestCase.assertTrue((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7529)), (timestampLast >= timestampFirst ? 1 : 0) != 0);
            }
            Map dataExtensions = (Map)tagReport.get("dataExtensions");
            if (expectedDataExtensions == null) {
                RfidInventoryProfileAbstractTestCase.assertNotNull((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7530)), (Object)dataExtensions);
                RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7531)), (int)0, (int)dataExtensions.size());
                continue;
            }
            RfidInventoryProfileAbstractTestCase.assertEquals((String)RfidInventoryProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7530)), (Object)expectedDataExtensions, (Object)dataExtensions);
        }
        return tagList;
    }

    protected int waitForTagAggregationReports(int expectedCount, int duration) throws InterruptedException {
        return this.waitForSignalIgnoringErrors(this.rfidInventoryProfileServiceTagAggregationReportExternalKey, expectedCount, duration);
    }

    protected int waitForTagReports(int expectedCount, int duration) throws InterruptedException {
        return this.waitForSignalIgnoringErrors(this.rfidInventoryProfileServiceTagReportExternalKey, expectedCount, duration);
    }

    protected void writeAggregationMaskSetting(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceAggregationMaskSettingExternalKey, dataValue);
    }

    protected void writeDataExtensions(Map dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceDataExtensionsExternalKey, dataValue);
    }

    protected void writeDuplicateFiltering(Boolean dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceDuplicateFilteringExternalKey, dataValue);
    }

    protected void writeDuplicateFilteringExpression(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceDuplicateFilteringExpressionExternalKey, dataValue);
    }

    protected void writeTagAggregating(Boolean dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceTagAggregatingExternalKey, dataValue);
    }

    protected void writeTagAggregatingExpression(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceTagAggregatingExpressionExternalKey, dataValue);
    }

    protected void writeTagMaskSetting(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceTagMaskSettingExternalKey, dataValue);
    }

    protected void writeTagReading(Boolean dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceTagReadingExternalKey, dataValue);
    }

    protected void writeTagReadingExpression(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidInventoryProfileServiceTagReadingExpressionExternalKey, dataValue);
    }

    protected int waitForSignalIgnoringErrors(String topicKey, int expectedCount, int duration) throws InterruptedException {
        NotificationProbe probe = this.getProbe();
        int count = probe.waitKeyPublished(topicKey, expectedCount, duration);
        return count;
    }
}

