/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.device.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.device.servlet.DeviceDeviceServletContext;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceRegistryService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.signal.service.SignalService;

public class DeviceDeviceServlet
extends DeviceServlet
implements DeviceServletService,
Servlet {
    private static final long serialVersionUID = 3261854308887373271L;
    private DeviceRegistryService deviceRegistryService;

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceDeviceServletContext context = new DeviceDeviceServletContext(request, response, this.getServletAlias());
        return context;
    }

    public DeviceRegistryService getDeviceRegistryService() {
        return this.deviceRegistryService;
    }

    public void processDevice(DeviceDeviceServletContext context, DeviceService device) {
        int signalsSize;
        int commandsSize;
        ArrayList measurementList = new ArrayList(101);
        ArrayList commandList = new ArrayList(101);
        ArrayList signalList = new ArrayList(101);
        context.addEntity("Name", device.getKey());
        context.addEntity("DeviceName", device.getKey());
        context.template("devicebegin");
        Enumeration enumeration = device.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof MeasurementService) {
                measurementList.add(object);
            }
            if (object instanceof CommandService) {
                commandList.add(object);
            }
            if (!(object instanceof SignalService)) continue;
            signalList.add(object);
        }
        int measurementsSize = measurementList.size();
        if (measurementsSize > 0) {
            MeasurementService[] measurements = new MeasurementService[measurementsSize];
            measurements = measurementList.toArray(measurements);
            context.sort((ControlService[])measurements);
            context.template("measurementbegin");
            int i = 0;
            while (i < measurementsSize) {
                MeasurementService measurement = measurements[i];
                context.addEntity("Name", measurement.getKey());
                context.addEntity("Value", measurement.getValue());
                String timestamp = Nls.formatTimestamp((Object)measurement.getTimestamp());
                context.addEntity("Timestamp", timestamp);
                context.template("measuremententry");
                ++i;
            }
            context.template("measurementend");
        }
        if ((commandsSize = commandList.size()) > 0) {
            CommandService[] commands = new CommandService[commandsSize];
            commands = commandList.toArray(commands);
            context.sort((ControlService[])commands);
            context.template("commandbegin");
            int i = 0;
            while (i < commandsSize) {
                CommandService command = commands[i];
                context.addEntity("Name", command.getKey());
                context.template("commandentry");
                ++i;
            }
            context.template("commandend");
        }
        if ((signalsSize = signalList.size()) > 0) {
            SignalService[] signals = new SignalService[signalsSize];
            signals = signalList.toArray(signals);
            context.sort((ControlService[])signals);
            context.template("signalbegin");
            int i = 0;
            while (i < signalsSize) {
                SignalService signal = signals[i];
                context.addEntity("Name", signal.getKey());
                context.template("signalentry");
                ++i;
            }
            context.template("signalend");
        }
        context.template("deviceend");
    }

    public void processDeviceRegistry(DeviceDeviceServletContext context) {
        try {
            DeviceRegistryService deviceRegistryService = this.getDeviceRegistryService();
            if (deviceRegistryService != null) {
                ArrayList deviceList = new ArrayList(101);
                Enumeration enumeration = deviceRegistryService.elements();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    if (!(object instanceof DeviceService)) continue;
                    deviceList.add(object);
                }
                int devicesSize = deviceList.size();
                if (devicesSize > 0) {
                    DeviceService[] devices = new DeviceService[devicesSize];
                    devices = deviceList.toArray(devices);
                    context.sort((ControlService[])devices);
                    int i = 0;
                    while (i < devicesSize) {
                        DeviceService device = devices[i];
                        if (context.filter(device.getKey())) {
                            this.processDevice(context, device);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processRequest(DeviceServletContext context) {
        this.processDeviceRegistry((DeviceDeviceServletContext)context);
    }

    public void setDeviceRegistryService(DeviceRegistryService deviceRegistryService) {
        this.deviceRegistryService = deviceRegistryService;
    }
}

