/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.property.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.property.servlet.DevicePropertyServletContext;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;

public class DevicePropertyServlet
extends DeviceServlet
implements DeviceServletService,
Servlet {
    private static final long serialVersionUID = -5444106761941903290L;
    private int colorValue = 0xFFFFFF;

    public void changeProperty(DeviceServletContext context, Properties table) {
        block6: {
            String name = context.getPath();
            if (name.equals("System")) {
                System.setProperties(table);
            } else {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(name);
                    BufferedOutputStream os = new BufferedOutputStream(fos);
                    table.store(os, "Device Property Servlet Update");
                    fos.close();
                }
                catch (Exception exception) {
                    if (fos == null) break block6;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public Object convert(Object value) {
        return this.getTextDataFix(String.valueOf(value));
    }

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DevicePropertyServletContext context = new DevicePropertyServletContext(request, response, this.getServletAlias());
        return context;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DeviceServletContext context = this.createContext(request, response);
        this.setup(context);
        context.begin();
        Enumeration enumeration = request.getParameterNames();
        Properties table = new Properties();
        while (enumeration.hasMoreElements()) {
            String key = String.valueOf(enumeration.nextElement());
            String value = request.getParameter(key);
            Object rvalue = this.convert(value);
            table.put(key, rvalue);
        }
        this.changeProperty(context, table);
        context.template("updatebegin");
        this.processRequest(context);
        context.end();
    }

    public int getColorValue() {
        return this.colorValue;
    }

    public String getTextDataFix(String string) {
        if (string == null) {
            return new String();
        }
        int length = string.length();
        if (length < 2) {
            return string;
        }
        StringBuffer result = new StringBuffer(length);
        char[] array = string.toCharArray();
        int i = 0;
        block11: while (i < array.length) {
            if (array[i] == '\\') {
                if (++i > array.length) {
                    throw new IllegalArgumentException();
                }
                switch (array[i]) {
                    case 'b': {
                        result.append('\b');
                        ++i;
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        ++i;
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        ++i;
                        break;
                    }
                    case '\'': {
                        result.append('\'');
                        ++i;
                        break;
                    }
                    case '\"': {
                        result.append('\"');
                        ++i;
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        ++i;
                        break;
                    }
                    case 'u': {
                        throw new IllegalArgumentException();
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        result.append(array[i]);
                        if (++i < array.length) {
                            if (Character.isDigit(array[i])) {
                                result.append(array[i]);
                                ++i;
                            }
                        } else {
                            throw new IllegalArgumentException();
                        }
                        if (i < array.length) {
                            if (!Character.isDigit(array[i])) continue block11;
                            result.append(array[i]);
                            ++i;
                            break;
                        }
                        throw new IllegalArgumentException();
                    }
                }
                continue;
            }
            result.append(array[i]);
            ++i;
        }
        return result.toString();
    }

    public void processMap(DevicePropertyServletContext context, Map map, String name) {
        context.addEntity("Name", name);
        Set keys = map.keySet();
        int keySize = keys.size();
        String[] skeys = new String[keySize];
        skeys = keys.toArray(skeys);
        context.sort(skeys);
        context.template("propertybegin");
        int j = 0;
        while (j < keySize) {
            String svalue;
            String key = skeys[j];
            Object value = map.get(key);
            if (value != null && (svalue = context.formatData(value)).length() > 0) {
                context.addEntity("Key", context.formatData(key));
                context.addEntity("Description", context.formatData(key));
                context.addEntity("Value", svalue);
                context.template("propertyentry");
            }
            ++j;
        }
        context.template("propertyend");
    }

    public void processProperties(DevicePropertyServletContext context) {
        Properties systemProperties = System.getProperties();
        this.processMap(context, systemProperties, "System");
        String home = System.getProperty("user.dir");
        File file = new File(home);
        String[] filenames = file.list();
        context.sort(filenames);
        int i = 0;
        while (i < filenames.length) {
            block7: {
                String filename = filenames[i];
                if (filename.endsWith(".properties")) {
                    BufferedInputStream is = null;
                    try {
                        Properties properties = new Properties();
                        FileInputStream fis = new FileInputStream(filename);
                        is = new BufferedInputStream(fis);
                        properties.load(is);
                        if (properties.size() > 0) {
                            this.processMap(context, properties, filename);
                        }
                    }
                    catch (Exception exception) {
                        if (is == null) break block7;
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++i;
        }
    }

    public void processRequest(DeviceServletContext context) {
        this.processProperties((DevicePropertyServletContext)context);
    }

    public void resetColorValue() {
        this.colorValue = 0xFFFFFF;
    }

    public void setColorValue(int colorValue) {
        this.colorValue = colorValue;
    }

    public void updateColorValue() {
        this.colorValue -= 526344;
        if (this.colorValue == 0x808080) {
            this.colorValue = 0xFFFFFF;
        }
    }
}

