/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.agent.managed;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.agent.service.AgentService;
import org.eclipse.soda.dk.connection.bundle.ServiceInterestBundle;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public abstract class AgentManaged
extends ServiceInterestBundle
implements ManagedService {
    private AgentService agent;

    public Object createService() {
        this.agent.start();
        return this.agent;
    }

    public AgentService createService(DeviceService device) {
        return null;
    }

    protected void deactivate() {
        if (this.getAgent() != null) {
            try {
                this.getAgent().exit();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
        }
    }

    public AgentService getAgent() {
        if (this.getService() instanceof AgentService) {
            return (AgentService)this.getService();
        }
        return null;
    }

    public DeviceService getDevice() {
        Object intest = this.getInterest();
        if (intest instanceof DeviceService) {
            return (DeviceService)intest;
        }
        return null;
    }

    public String getDeviceServiceName() {
        return "";
    }

    public String getInterestServiceName() {
        return this.getDeviceServiceName();
    }

    public String[] getMatchAgentClasses() {
        return new String[0];
    }

    public String getServiceName() {
        return AgentService.SERVICE_NAME;
    }

    public void setInterest(Object interest) {
        super.setInterest(interest);
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        if (from != null) {
            Enumeration enumeration = from.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = from.get(key);
                table.put(key, value);
            }
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        AgentService object;
        AgentService agentOld = this.getAgent();
        if (agentOld != null) {
            this.removeExportedService(AgentService.SERVICE_NAME);
            agentOld.exit();
            this.setService(null);
        }
        if ((object = this.createService(null)) instanceof AgentService) {
            AgentService agentService = object;
            agentService.setConfigurationInformation(properties);
            try {
                agentService.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setService(object);
            String[] names = this.getExportedServiceNames();
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            this.addExportedServices(names, object, serviceProperties);
        }
    }
}

