/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.notification.NotificationListeners;
import org.eclipse.soda.dk.notification.NotificationQueue;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;

public class Notification
implements NotificationService,
Runnable {
    protected static final NotificationService Broker = Notification.createBroker();
    protected NotificationQueue queue = new NotificationQueue(128);
    protected Thread thread = null;
    protected Hashtable topicListeners = new Hashtable(101);
    protected Hashtable beginTopicListeners = null;
    protected Hashtable endTopicListeners = null;
    protected NotificationListener globalTopicListeners = null;
    private boolean running = false;

    public static NotificationService createBroker() {
        Notification broker = new Notification();
        broker.start();
        return broker;
    }

    public static NotificationService getBroker() {
        return Broker;
    }

    public static String getExternalKey(String prefix, String key) {
        if (prefix == null) {
            return key;
        }
        int plength = prefix.length();
        if (plength == 0) {
            return key;
        }
        int klength = key.length();
        StringBuffer buffer = new StringBuffer(plength + 1 + klength);
        buffer.append(prefix);
        buffer.append('/');
        buffer.append(key);
        return buffer.toString().intern();
    }

    public static String[] getExternalKeys(String prefix, String[] keys) {
        if (prefix == null) {
            return keys;
        }
        int plength = prefix.length();
        if (plength == 0) {
            return keys;
        }
        int size = keys.length;
        if (size == 0) {
            return keys;
        }
        StringBuffer buffer = new StringBuffer(plength + 1 + 128);
        buffer.append(prefix);
        buffer.append('/');
        String[] newKeys = new String[size];
        int i = 0;
        while (i < size) {
            String key = keys[i];
            buffer.append(key);
            newKeys[i] = buffer.toString().intern();
            buffer.delete(plength + 1, buffer.length());
            ++i;
        }
        return newKeys;
    }

    public void broadcast(String key, Dictionary value) {
        this.getInformationBroker().broadcast(key, value);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void exit() {
        this.stop();
    }

    public NotificationQueue getInformationBroker() {
        return this.queue;
    }

    public void register(String subscription, NotificationListener listener) {
        if ("*".equals(subscription) || "#".equals(subscription)) {
            this.globalTopicListeners = NotificationListeners.add(this.globalTopicListeners, listener);
        } else if (subscription.startsWith("*") || subscription.startsWith("#")) {
            if (this.beginTopicListeners == null) {
                this.beginTopicListeners = new Hashtable(101);
            }
            this.beginTopicListeners.put(subscription.substring(2), NotificationListeners.add((NotificationListener)this.beginTopicListeners.get(subscription), listener));
        } else if (subscription.endsWith("*") || subscription.endsWith("#")) {
            if (this.endTopicListeners == null) {
                this.endTopicListeners = new Hashtable(101);
            }
            this.endTopicListeners.put(subscription.substring(0, subscription.length() - 2), NotificationListeners.add((NotificationListener)this.endTopicListeners.get(subscription), listener));
        } else {
            if (this.topicListeners == null) {
                this.topicListeners = new Hashtable(101);
            }
            this.topicListeners.put(subscription, NotificationListeners.add((NotificationListener)this.topicListeners.get(subscription), listener));
        }
    }

    public void register(String[] subscriptions, NotificationListener listener) {
        int i = 0;
        while (i < subscriptions.length) {
            this.register(subscriptions[i], listener);
            ++i;
        }
    }

    public void run() {
        int idleCount = 0;
        while (this.running) {
            long delay = 10000L;
            Object[] information = this.queue.dequeue(delay);
            if (!this.running) continue;
            if (information != null) {
                String subTopic;
                int index;
                String topic = (String)information[0];
                Dictionary data = (Dictionary)information[1];
                Object listener = this.topicListeners.get(topic);
                if (listener instanceof NotificationListener) {
                    ((NotificationListener)listener).notificationReceived(topic, data);
                }
                if (this.globalTopicListeners != null) {
                    this.globalTopicListeners.notificationReceived(topic, data);
                }
                if (this.beginTopicListeners != null) {
                    index = 0;
                    while (index >= 0) {
                        subTopic = topic.substring(index);
                        Object beginListener = this.beginTopicListeners.get(subTopic);
                        if (beginListener instanceof NotificationListener) {
                            ((NotificationListener)beginListener).notificationReceived(topic, data);
                        }
                        if ((index = topic.indexOf(47, index + 1)) < 0) continue;
                        ++index;
                    }
                }
                if (this.endTopicListeners != null) {
                    index = topic.length();
                    while (index >= 0) {
                        subTopic = topic.substring(0, index);
                        Object endListener = this.endTopicListeners.get(subTopic);
                        if (endListener instanceof NotificationListener) {
                            ((NotificationListener)endListener).notificationReceived(topic, data);
                        }
                        index = subTopic.lastIndexOf(47);
                    }
                }
                idleCount = 0;
                continue;
            }
            if (++idleCount % 100 == 99) {
                System.gc();
                System.gc();
            }
            long l = 1000L;
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "InformationBrokerService");
            this.thread.setPriority(6);
            this.running = true;
            this.thread.start();
        }
    }

    public void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException exception) {
                exception.printStackTrace();
            }
        }
        this.thread = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.queue);
        return buffer.toString();
    }

    public void unregister(NotificationListener listener) {
        NotificationListener listenersNew;
        NotificationListener listeners;
        Object value;
        Map.Entry entry;
        int i;
        Map.Entry[] entries;
        int size;
        Set beginTopicSet;
        this.globalTopicListeners = NotificationListeners.remove(this.globalTopicListeners, listener);
        if (this.topicListeners != null) {
            beginTopicSet = this.topicListeners.entrySet();
            size = beginTopicSet.size();
            entries = new Map.Entry[size];
            entries = beginTopicSet.toArray(entries);
            i = 0;
            while (i < size) {
                entry = entries[i];
                value = entry.getValue();
                if (value == listener) {
                    this.topicListeners.remove(entry.getKey());
                } else if (value instanceof NotificationListener) {
                    listeners = (NotificationListener)value;
                    listenersNew = NotificationListeners.remove(listeners, listener);
                    entry.setValue(listenersNew);
                }
                ++i;
            }
        }
        if (this.beginTopicListeners != null) {
            beginTopicSet = this.beginTopicListeners.entrySet();
            size = beginTopicSet.size();
            entries = new Map.Entry[size];
            entries = beginTopicSet.toArray(entries);
            i = 0;
            while (i < size) {
                entry = entries[i];
                value = entry.getValue();
                if (value == listener) {
                    this.beginTopicListeners.remove(entry.getKey());
                } else if (value instanceof NotificationListener) {
                    listeners = (NotificationListener)value;
                    listenersNew = NotificationListeners.remove(listeners, listener);
                    entry.setValue(listenersNew);
                }
                ++i;
            }
            if (this.beginTopicListeners.size() == 0) {
                this.beginTopicListeners = null;
            }
        }
        if (this.endTopicListeners != null) {
            Set endTopicSet = this.endTopicListeners.entrySet();
            size = endTopicSet.size();
            entries = new Map.Entry[size];
            entries = endTopicSet.toArray(entries);
            i = 0;
            while (i < size) {
                entry = entries[i];
                value = entry.getValue();
                if (value == listener) {
                    this.endTopicListeners.remove(entry.getKey());
                } else if (value instanceof NotificationListener) {
                    listeners = (NotificationListener)value;
                    listenersNew = NotificationListeners.remove(listeners, listener);
                    entry.setValue(listenersNew);
                }
                ++i;
            }
            if (this.endTopicListeners.size() == 0) {
                this.endTopicListeners = null;
            }
        }
    }
}

