/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;

public class NotificationQueue {
    protected Object[][] elements;
    int length;
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    public NotificationQueue() {
        this(2);
    }

    public NotificationQueue(int size) {
        this.elements = new Object[size][2];
        this.length = size;
    }

    public void broadcast(String topic, Dictionary data) {
        this.enqueue(topic, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] dequeue(long time) {
        NotificationQueue notificationQueue;
        if (this.size == 0) {
            notificationQueue = this;
            synchronized (notificationQueue) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
        notificationQueue = this;
        synchronized (notificationQueue) {
            if (this.size <= 0) {
                return null;
            }
            Object[] info = this.elements[this.head];
            ++this.head;
            if (this.head >= this.length) {
                this.head -= this.length;
            }
            --this.size;
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(String topic, Object data) {
        try {
            NotificationQueue notificationQueue = this;
            synchronized (notificationQueue) {
                if (this.size == 0) {
                    this.head = 0;
                    this.tail = 1;
                    this.elements[this.head][0] = topic;
                    this.elements[this.head][1] = data;
                } else {
                    int high;
                    if (this.size >= this.length) {
                        this.handleFull();
                    }
                    if ((high = this.tail - 1) < 0) {
                        high = this.length + high;
                    }
                    this.elements[this.tail][0] = topic;
                    this.elements[this.tail][1] = data;
                    ++this.tail;
                    if (this.tail >= this.length) {
                        this.tail -= this.length;
                    }
                }
                ++this.size;
                this.notify();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.toString());
            System.exit(0);
        }
    }

    public int getMaxSize() {
        return this.length;
    }

    public synchronized void handleFull() {
        Object[][] newElements = new Object[this.size << 1][2];
        if (this.head == 0) {
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
        } else {
            int delta = this.size - this.head;
            System.arraycopy(this.elements, this.head, newElements, 0, delta);
            System.arraycopy(this.elements, 0, newElements, delta, this.size - delta);
            this.head = 0;
        }
        this.tail = this.size;
        this.elements = newElements;
        this.length = this.elements.length;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('{');
        boolean first = true;
        int count = 0;
        while (count < this.size) {
            Object topic;
            int i = this.head + count;
            if (i >= this.length) {
                i -= this.length;
            }
            if ((topic = this.elements[i][0]) != null) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                buffer.append(topic);
                buffer.append('=');
                Object data = this.elements[i][1];
                buffer.append(data);
            } else {
                buffer.append(", NULL");
            }
            ++count;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

