/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.event.admin;

import java.util.Hashtable;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventAdminHandler
implements EventHandler {
    protected NotificationListener notificationListener = null;
    protected String[] topics = new String[0];
    protected ServiceRegistration serviceRegistration = null;

    public EventAdminHandler(NotificationListener notificationListener, String[] topics) {
        this.notificationListener = notificationListener;
        this.topics = topics;
    }

    public void addTopics(String[] externalKeys) {
        int size = this.topics.length;
        String[] newTopics = new String[size + externalKeys.length];
        System.arraycopy(this.topics, 0, newTopics, 0, size);
        System.arraycopy(externalKeys, 0, newTopics, size, externalKeys.length);
        this.topics = newTopics;
        if (this.serviceRegistration != null) {
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>(3);
            properties.put("event.topics", this.topics);
            this.serviceRegistration.setProperties(properties);
        }
    }

    public ServiceRegistration getServiceRegistration() {
        return this.serviceRegistration;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void handleEvent(Event event) {
        if (this.notificationListener != null) {
            String[] topics = event.getPropertyNames();
            if (topics.length == 0) {
                this.notificationListener.notificationReceived(event.getTopic(), null);
            } else {
                Hashtable<String, Object> data = new Hashtable<String, Object>(topics.length * 2 + 1);
                int i = 0;
                while (i < topics.length) {
                    String key = topics[i];
                    Object value = event.getProperty(key);
                    data.put(key, value);
                    ++i;
                }
                this.notificationListener.notificationReceived(event.getTopic(), data);
            }
        }
    }

    public void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    public void setTopics(String[] topics) {
        this.topics = topics;
    }
}

