/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.event.admin;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.notification.event.admin.EventAdminHandler;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class NotificationEventAdmin
implements NotificationService {
    protected EventAdmin eventAdmin;
    protected BundleContext bundleContext;
    protected Hashtable notificationListeners = new Hashtable();
    static /* synthetic */ Class class$0;

    public void addData(Dictionary data) {
        if (data.get("timestamp") == null) {
            data.put("timestamp", EscObject.getCurrentTimestamp());
        }
        if (data.get("bundle.symbolicName") == null) {
            data.put("bundle.symbolicName", this.bundleContext.getBundle().getSymbolicName());
        }
    }

    public void broadcast(String externalKey, Dictionary data) {
        if (this.eventAdmin != null) {
            if (data == null) {
                Event event = new Event(externalKey, null);
                this.eventAdmin.postEvent(event);
            } else {
                this.addData(data);
                Event event = new Event(externalKey, data);
                this.eventAdmin.postEvent(event);
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public void register(String externalKey, NotificationListener listener) {
        this.register(new String[]{externalKey}, listener);
    }

    public void register(String[] externalKeys, NotificationListener listener) {
        EventAdminHandler eventAdminHandler = (EventAdminHandler)this.notificationListeners.get(listener);
        if (this.bundleContext != null) {
            if (eventAdminHandler == null) {
                EventAdminHandler eventAdminHandlerNew = new EventAdminHandler(listener, externalKeys);
                this.notificationListeners.put(listener, eventAdminHandlerNew);
                Hashtable<String, String[]> properties = new Hashtable<String, String[]>(3);
                properties.put("event.topics", externalKeys);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.event.EventHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ServiceRegistration serviceRegistration = this.bundleContext.registerService(clazz.getName(), (Object)eventAdminHandlerNew, properties);
                eventAdminHandlerNew.setServiceRegistration(serviceRegistration);
            } else {
                eventAdminHandler.addTopics(externalKeys);
            }
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unregister(NotificationListener listener) {
        EventAdminHandler eventAdminHandler = (EventAdminHandler)this.notificationListeners.get(listener);
        if (this.bundleContext != null && eventAdminHandler != null) {
            ServiceRegistration serviceRegistration = eventAdminHandler.getServiceRegistration();
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            this.notificationListeners.remove(listener);
        }
    }
}

