/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile;

import java.util.ResourceBundle;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.ProfileResourceBundle;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Profile
extends Device
implements ProfileService,
CommandListener,
SignalListener,
MeasurementListener,
DeviceListener {
    private static ResourceBundle DefaultResourceBundle;
    protected DeviceService device;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.profile.ProfileResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public Profile() {
        this.initialize("Profile/Capabilities", "Profile/Status", "Profile/Configuration");
    }

    protected Profile(String capabilities, String status, String configuration) {
        this.initialize(capabilities, status, configuration);
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
    }

    public void controlChanged(DeviceService device, Object timestamp, ControlService control, int code) {
    }

    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
        int mystate = this.getState();
        if (mystate != newState) {
            if (mystate > 1) {
                if (newState == 5) {
                    this.setState(5);
                } else if (newState > 1) {
                    super.setState(newState);
                } else {
                    super.setState(2);
                }
            }
            this.deviceChangedCustom(source, timestamp, newState, oldState);
        }
    }

    public void deviceChangedCustom(DeviceService source, Object timestamp, int newState, int oldState) {
    }

    public void exit() {
        this.removeListeners(this.getDevice());
        this.setDevice(null);
        super.exit();
    }

    public Boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value != null) {
            String valueString = value.toString();
            if (valueString.equals("1") || valueString.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (valueString.equals("0") || valueString.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "Profile";
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public Object getLogDetails6() {
        return String.valueOf(this.getDevice());
    }

    public Long getLongValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        if (value != null) {
            String valueString = value.toString();
            return Long.valueOf(valueString, 10);
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public String getResource(int resourceId) {
        try {
            if (resourceId >= 3000 && resourceId < 4000) {
                return DefaultResourceBundle.getString(ProfileResourceBundle.getKey(resourceId + 2000));
            }
            return DefaultResourceBundle.getString(ProfileResourceBundle.getKey(resourceId));
        }
        catch (Exception exception) {
            return super.getResource(resourceId);
        }
    }

    public TransportService getTransport() {
        DeviceService device = this.getDevice();
        if (device != null) {
            return device.getTransport();
        }
        return super.getTransport();
    }

    protected void initialize(String capabilities, String status, String configuration) {
        this.capabilities = new Measurement(capabilities);
        this.status = new Measurement(status);
        this.configuration = new Measurement(configuration);
        this.put((ControlService)this.configuration);
        this.put((ControlService)this.status);
        this.put((ControlService)this.capabilities);
    }

    public void initializeCommand(CommandService command) {
        if (command != null) {
            command.addCommandListener((CommandListener)this);
        }
    }

    public void initializeMeasurement(MeasurementService measurement) {
        if (measurement != null) {
            measurement.addMeasurementListener((MeasurementListener)this);
            measurement.executeRead();
        }
    }

    public void initializeSignal(SignalService signal) {
        if (signal != null) {
            signal.addSignalListener((SignalListener)this);
        }
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public boolean isStarted() {
        return this.getState() >= 5;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    public void setDevice(DeviceService device) {
        if (this == device) {
            throw new RuntimeException(String.valueOf(device));
        }
        if (this.device != null) {
            this.device.removeDeviceListener((DeviceListener)this);
        }
        this.device = device;
        if (this.device != null) {
            this.device.addDeviceListener((DeviceListener)this);
        }
        this.setDeviceCustom(device);
    }

    public void setDeviceCustom(DeviceService device) {
    }

    public void setState(int state) {
        if (this.isDeviceNeeded()) {
            int deviceState;
            if (state < 2) {
                super.setState(state);
                return;
            }
            DeviceService device = this.getDevice();
            if (device != null && (deviceState = device.getState()) > 2) {
                super.setState(deviceState);
                return;
            }
            super.setState(2);
        } else {
            super.setState(state);
        }
    }

    public void setup() {
        super.setup();
        if (this.getDevice() == null) {
            this.setDevice(this.getDefaultDevice());
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
    }
}

