/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.profile;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.core.Worker;
import org.eclipse.soda.dk.core.service.WorkerService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.service.RfidInventoryProfileService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class RfidInventoryProfile
extends Profile
implements ProfileService,
RfidInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile";
    public static final String GPIO_PROFILE_PREFIX = "GpioProfilePrefix";
    protected String gpioProfileServiceInputExternalKey;
    protected String gpioProfileServiceInputGetExternalKey;
    public static final String CONTROL_PROFILE_PREFIX = "ControlProfilePrefix";
    protected String controlProfileServiceBitsExternalKey;
    protected String controlProfileServiceBitsGetExternalKey;
    protected String controlProfileServiceLongsExternalKey;
    protected String controlProfileServiceLongsGetExternalKey;
    protected final MethodMeasurement tagReadingExpression = new MethodMeasurement("RfidInventory/TagReadingExpression");
    protected final MethodMeasurement tagReading = new MethodMeasurement("RfidInventory/TagReading", (Object)Boolean.FALSE);
    protected final MethodMeasurement tagAggregatingExpression = new MethodMeasurement("RfidInventory/TagAggregatingExpression");
    protected final MethodMeasurement tagAggregating = new MethodMeasurement("RfidInventory/TagAggregating", (Object)Boolean.FALSE);
    protected final MethodMeasurement tagMaskSetting = new MethodMeasurement("RfidInventory/TagMaskSetting");
    protected final MethodMeasurement duplicateFilteringExpression = new MethodMeasurement("RfidInventory/DuplicateFilteringExpression");
    protected final MethodMeasurement duplicateFiltering = new MethodMeasurement("RfidInventory/DuplicateFiltering", (Object)Boolean.FALSE);
    protected final MethodMeasurement aggregationMaskSetting = new MethodMeasurement("RfidInventory/AggregationMaskSetting");
    protected final MethodMeasurement dataExtensions = new MethodMeasurement("RfidInventory/DataExtensions");
    protected final Signal tagReport = new Signal("RfidInventory/TagReport");
    protected final Signal tagAggregationReport = new Signal("RfidInventory/TagAggregationReport");
    private int readStopTimeout = 2000;
    protected String gpioInput;
    private Filter tagAggregatingLdapFilter;
    private Filter tagReadingLdapFilter;
    private Filter duplicateFilteringLdapFilter;
    private Dictionary ldapMap = new Hashtable(67);
    protected InterestMasks tagInterest = new InterestMasks();
    protected InterestMasks aggregationInterest = new InterestMasks();
    private Map cachedTags = new Hashtable(1031);
    private Map aggregatedTags = new Hashtable(1031);
    private final Object waitForReadStop = new Object();
    private Worker ldapEvalWorker;
    private boolean localReadState = false;

    public RfidInventoryProfile() {
        super("RfidInventoryProfile/Capabilities", "RfidInventoryProfile/Status", "RfidInventoryProfile/Configuration");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public String getGpioProfilePrefix() {
        return this.getString(GPIO_PROFILE_PREFIX, this.getPrefix());
    }

    public String getControlProfilePrefix() {
        return this.getString(CONTROL_PROFILE_PREFIX, this.getPrefix());
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.gpioProfileServiceInputExternalKey)) {
            this.handleGpioProfileServiceInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceBitsExternalKey)) {
            this.handleControlProfileServiceBits(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceLongsExternalKey)) {
            this.handleControlProfileServiceLongs(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    public void setupNotification() {
        String gpioProfilePrefix = this.getGpioProfilePrefix();
        this.gpioProfileServiceInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input");
        this.gpioProfileServiceInputGetExternalKey = this.prependPrefix("Gpio/Input/get");
        String controlProfilePrefix = this.getControlProfilePrefix();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits");
        this.controlProfileServiceBitsGetExternalKey = this.prependPrefix("Control/Bits/get");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs");
        this.controlProfileServiceLongsGetExternalKey = this.prependPrefix("Control/Longs/get");
        this.register(new String[]{this.gpioProfileServiceInputExternalKey, this.controlProfileServiceBitsExternalKey, this.controlProfileServiceLongsExternalKey});
        super.setupNotification();
        this.broadcast(this.gpioProfileServiceInputGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceBitsGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceLongsGetExternalKey, new Hashtable());
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.tagReading == source) {
            this.handleTagReading(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.tagAggregating == source) {
            this.handleTagAggregating(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.duplicateFiltering == source) {
            this.handleDuplicateFiltering(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    public String getDefaultKey() {
        return "RfidInventoryProfile";
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public int getControlCapacity() {
        return 17;
    }

    public int getMessageCapacity() {
        return 2;
    }

    public MeasurementService getTagReadingExpression() {
        return this.tagReadingExpression;
    }

    public MeasurementService getTagReading() {
        return this.tagReading;
    }

    public MeasurementService getTagAggregatingExpression() {
        return this.tagAggregatingExpression;
    }

    public MeasurementService getTagAggregating() {
        return this.tagAggregating;
    }

    public MeasurementService getTagMaskSetting() {
        return this.tagMaskSetting;
    }

    public MeasurementService getDuplicateFilteringExpression() {
        return this.duplicateFilteringExpression;
    }

    public MeasurementService getDuplicateFiltering() {
        return this.duplicateFiltering;
    }

    public MeasurementService getAggregationMaskSetting() {
        return this.aggregationMaskSetting;
    }

    public MeasurementService getDataExtensions() {
        return this.dataExtensions;
    }

    public SignalService getTagReport() {
        return this.tagReport;
    }

    public SignalService getTagAggregationReport() {
        return this.tagAggregationReport;
    }

    private void initialize() {
        this.put((ControlService)this.tagReadingExpression);
        this.put((ControlService)this.tagReading);
        this.tagReading.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.tagAggregatingExpression);
        this.put((ControlService)this.tagAggregating);
        this.tagAggregating.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.tagMaskSetting);
        this.put((ControlService)this.duplicateFilteringExpression);
        this.put((ControlService)this.duplicateFiltering);
        this.duplicateFiltering.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.aggregationMaskSetting);
        this.put((ControlService)this.dataExtensions);
        this.put((ControlService)this.tagReport);
        this.put((ControlService)this.tagAggregationReport);
    }

    public void setReadStopTimeout(int readStopTimeout) {
        this.readStopTimeout = readStopTimeout;
    }

    public int getReadStopTimeout() {
        return this.readStopTimeout;
    }

    public void setup() {
        super.setup();
        this.setReadStopTimeout(this.getInt("rfidinventoryprofile.readStopTimeout", this.getReadStopTimeout()));
    }

    protected boolean getTagReadingValue() {
        if (this.getTagReading() == null || this.getTagReading().getValue() == null) {
            return false;
        }
        return (Boolean)this.getTagReading().getValue();
    }

    public static String[] parseDelimitedByToken(String target, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(target, delimiter);
        String[] values = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            values[index++] = tokenizer.nextToken().trim();
        }
        return values;
    }

    public static byte[] parseHexSpaceDelimited(String spaceDelimitedHex) {
        StringTokenizer tokenizer = new StringTokenizer(spaceDelimitedHex);
        byte[] value = new byte[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String byteHex = tokenizer.nextToken();
            byte byteValue = 0;
            byteValue = (byte)Integer.parseInt(byteHex, 16);
            value[index++] = byteValue;
        }
        return value;
    }

    public static InterestMasks parseInterestMasks(String targetTagConfig) {
        InterestMasks interests = new InterestMasks();
        if (targetTagConfig != null) {
            try {
                String[] masksConfig = RfidInventoryProfile.parseDelimitedByToken(targetTagConfig, ";");
                int i = 0;
                while (i < masksConfig.length) {
                    String[] configParam = RfidInventoryProfile.parseDelimitedByToken(masksConfig[i], ",");
                    int offset = Integer.parseInt(configParam[1]);
                    int length = Integer.parseInt(configParam[2]);
                    byte[] pattern = RfidInventoryProfile.parseHexSpaceDelimited(configParam[3]);
                    InterestMask interest = new InterestMask(offset, length, pattern);
                    interests.add((InterestService)interest);
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("parseInterestMasks: " + targetTagConfig);
            }
        }
        return interests;
    }

    public static byte[] toBytes(String string) throws RuntimeException {
        char[] characters = string.toCharArray();
        int length = characters.length + 1 >> 1;
        byte[] tag = new byte[length];
        int index = characters.length % 2;
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            int digit = character - 48;
            if (digit < 0) {
                throw new NumberFormatException();
            }
            if (digit > 9 && ((digit = character - 87) & 0xFFFFFFF0) != 0 && ((digit = character - 55) & 0xFFFFFFF0) != 0) {
                throw new NumberFormatException();
            }
            tag[index >> 1] = index % 2 == 0 ? (byte)(digit << 4) : (byte)((tag[index >> 1] & 0xF0) + digit);
            ++index;
            ++i;
        }
        return tag;
    }

    protected void addTagToCache(String key, Map reads, Map cache) {
        cache.put(key, reads);
    }

    protected void applyDataExtensions(Map rfidData) {
        Map extensions = (Map)this.dataExtensions.getValue();
        if (extensions == null || extensions.isEmpty()) {
            rfidData.put("dataExtensions", new Hashtable(11));
        } else {
            Map existingDataExtensions = (Map)rfidData.get("dataExtensions");
            Map mergedDataExt = this.mergeMapOverMap(extensions, existingDataExtensions);
            rfidData.put("dataExtensions", mergedDataExt);
        }
    }

    protected abstract boolean autonomousModeOff();

    protected abstract boolean autonomousModeOn();

    protected Map buildOuterTagMessage(Map tags) {
        Hashtable<String, Map> tagMap = new Hashtable<String, Map>(13);
        tagMap.put("tags", tags);
        this.applyDataExtensions(tagMap);
        return tagMap;
    }

    protected Map buildTagMessage(String key, Map reads) {
        Hashtable<String, Map> tags = new Hashtable<String, Map>(7);
        tags.put(key, reads);
        Map tagMap = this.buildOuterTagMessage(tags);
        return tagMap;
    }

    protected Filter createLdapFilter(String filterString) throws InvalidSyntaxException {
        Filter result = null;
        result = this.createFilter(filterString);
        return result;
    }

    protected void evaluateDuplicateFilteringLdapFilter() {
        if (this.duplicateFilteringLdapFilter != null) {
            boolean duplicateFilteringResult = this.duplicateFilteringLdapFilter.match(this.ldapMap);
            this.duplicateFiltering.setValue((Object)new Boolean(duplicateFilteringResult), RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateLdapFilters() throws InterruptedException {
        boolean evaluateReadingLast = true;
        Object object = this.waitForReadStop;
        synchronized (object) {
            if (this.getTagReadingValue() && this.tagReadingLdapFilter != null && !this.tagReadingLdapFilter.match(this.ldapMap)) {
                evaluateReadingLast = false;
                long readTimeout = this.getReadStopTimeout();
                boolean requiresWait = this.autonomousModeOff();
                this.localReadState = false;
                if (requiresWait && readTimeout > 0L) {
                    this.waitForReadStop.wait(readTimeout);
                }
                this.tagReading.setValue((Object)Boolean.FALSE, RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        object = this;
        synchronized (object) {
            this.evaluateDuplicateFilteringLdapFilter();
            this.evaluateTagAggregatingLdapFilter();
            if (evaluateReadingLast) {
                this.evaluateTagReadingLdapFilter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReadStop() {
        Object object = this.waitForReadStop;
        synchronized (object) {
            this.waitForReadStop.notifyAll();
        }
    }

    private void applyLdap() {
        WorkerService work = this.getLdapEvaluatorWorker();
        this.ldapEvalWorker = new Worker("RfidInventoryProfile", work);
        this.ldapEvalWorker.start();
    }

    public void deactivate() {
        if (this.ldapEvalWorker != null && this.ldapEvalWorker.isRunning()) {
            this.ldapEvalWorker.stop();
        }
        this.ldapEvalWorker = null;
        super.deactivate();
    }

    private WorkerService getLdapEvaluatorWorker() {
        WorkerService work = new WorkerService(){

            public boolean doWork() throws InterruptedException {
                RfidInventoryProfile.this.evaluateLdapFilters();
                return false;
            }
        };
        return work;
    }

    protected void evaluateTagAggregatingLdapFilter() {
        if (this.tagAggregatingLdapFilter != null) {
            boolean tagAggregatingResult = this.tagAggregatingLdapFilter.match(this.ldapMap);
            this.tagAggregating.setValue((Object)new Boolean(tagAggregatingResult), RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    protected void evaluateTagReadingLdapFilter() {
        if (this.tagReadingLdapFilter != null) {
            boolean tagReadingResult = this.tagReadingLdapFilter.match(this.ldapMap);
            this.tagReading.setValue((Object)new Boolean(tagReadingResult), RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    public void flushAggregatorCache() {
        this.aggregatedTags = new Hashtable(1031);
    }

    public void flushTagCache() {
        this.cachedTags = new Hashtable(1031);
    }

    protected void handleSetAggregationMaskSetting(Measurement measurement, Object data) {
        if (!(data instanceof String)) {
            throw new IllegalArgumentException("handleSetAggregationMaskSetting: " + data);
        }
        this.aggregationInterest = RfidInventoryProfile.parseInterestMasks((String)data);
        measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
    }

    public Object handleMethodAggregationMaskSetting(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetAggregationMaskSetting(measurement, data);
            }
        }
        return null;
    }

    protected void handleControlProfileServiceBits(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleControlProfileServiceLongs(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleDuplicateFiltering(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (!newState) {
            this.flushTagCache();
        }
    }

    public Object handleMethodDuplicateFilteringExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetDuplicateFilteringExpression(measurement, data);
            }
        }
        return null;
    }

    protected void handleSetDuplicateFilteringExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter dupFilter = this.createLdapFilter((String)data);
                    this.setFilterDuplicatesLdapFilter(dupFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setFilterDuplicatesLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetDuplicateFilteringExpression: " + data);
    }

    protected void handleGpioProfileServiceInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    public Object handleMethodDataExtensions(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetDataExtensions(measurement, data);
            }
        }
        return null;
    }

    protected void handleSetDataExtensions(Measurement measurement, Object newValue) {
        Map newExtensions = null;
        if (newValue instanceof Map) {
            Map additionalExtensions = (Map)newValue;
            if (additionalExtensions.isEmpty()) {
                newExtensions = new Hashtable(11);
            } else {
                Map existingExtensions = (Map)measurement.getValue();
                newExtensions = this.mergeMapOverMap(additionalExtensions, existingExtensions);
            }
        } else if (newValue == null) {
            newExtensions = new Hashtable(11);
        }
        if (newExtensions == null) {
            throw new IllegalArgumentException("handleSetDataExtensions: " + newValue);
        }
        measurement.setValue(newExtensions, RfidInventoryProfile.getCurrentTimestamp());
    }

    public Object handleMethodDuplicateFiltering(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.duplicateFilteringLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodDuplicateFiltering");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagAggregating(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagAggregatingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagAggregating");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagReading(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagReadingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagReading");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    protected void handleTagAggregating(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (oldValue != null) {
            this.applyDataExtensions(this.cachedTags);
            if (!newState) {
                this.notifyTagAggregation();
                this.flushAggregatorCache();
            }
        }
    }

    public Object handleMethodTagAggregatingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagAggregatingExpression(measurement, data);
            }
        }
        return null;
    }

    protected void handleSetTagAggregatingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter aggFilter = this.createLdapFilter((String)data);
                    this.setTagAggregatingLdapFilter(aggFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagAggregatingLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleTagAggregatingExpression: " + data);
    }

    public Object handleMethodTagMaskSetting(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagMaskSetting(measurement, data);
            }
        }
        return null;
    }

    protected void handleSetTagMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.tagInterest = RfidInventoryProfile.parseInterestMasks((String)data);
            measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagMaskSetting: " + data);
    }

    public void handleTagReading(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        this.applyTagReading(newState);
    }

    private void applyTagReading(boolean reading) {
        if (reading) {
            if (this.isStarted()) {
                if (!this.localReadState) {
                    this.autonomousModeOn();
                    this.localReadState = true;
                }
            } else {
                this.tagReading.setValue((Object)new Boolean(false), RfidInventoryProfile.getCurrentTimestamp());
            }
        } else if (this.localReadState) {
            this.autonomousModeOff();
            this.localReadState = false;
        }
    }

    public Object handleMethodTagReadingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagReadingExpression(measurement, data);
            }
        }
        return null;
    }

    protected void handleSetTagReadingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter readFilter = this.createLdapFilter((String)data);
                    this.setTagReadingLdapFilter(readFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagReadingLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetTagReadingExpression: " + data);
    }

    protected boolean isDuplicateTag(String key) {
        return this.cachedTags.containsKey(key);
    }

    protected Map mergeMapOverMap(Map additionalValues, Map existingValues) {
        Object value;
        Object key;
        Iterator i;
        Hashtable newExtensions = new Hashtable(17);
        if (existingValues != null) {
            i = existingValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = existingValues.get(key);
                newExtensions.put(key, value);
            }
        }
        if (additionalValues != null) {
            i = additionalValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = additionalValues.get(key);
                newExtensions.put(key, value);
            }
        }
        return newExtensions;
    }

    public void notifyTagAggregation() {
        Map tagMap = this.buildOuterTagMessage(this.aggregatedTags);
        this.triggerTagAggregationReport(tagMap, false);
    }

    public void notifyTagRead(String key, Map reads) {
        boolean sendTag = false;
        sendTag = this.applyFiltering(key, reads);
        this.applyAggregating(key, reads);
        if (sendTag) {
            Map tagMap = this.buildTagMessage(key, reads);
            this.triggerTagReport(tagMap, false);
        }
    }

    private void applyAggregating(String key, Map reads) {
        byte[] tagBytes = RfidInventoryProfile.toBytes(key);
        boolean isAggregating = (Boolean)this.getTagAggregating().getValue();
        if (isAggregating && this.aggregationInterest.isInterested(tagBytes)) {
            if (this.getTagReadingValue()) {
                this.updateTagInCache(key, reads, this.aggregatedTags);
            } else {
                Map tagErrorMap = this.buildTagMessage(key, reads);
                this.triggerTagAggregationReport(tagErrorMap, true);
            }
        }
    }

    private boolean applyFiltering(String key, Map reads) {
        boolean passesFilter = false;
        byte[] tagBytes = RfidInventoryProfile.toBytes(key);
        if (this.tagInterest.isInterested(tagBytes)) {
            boolean isDuplicateFiltering = (Boolean)this.getDuplicateFiltering().getValue();
            if (isDuplicateFiltering) {
                if (!this.isDuplicateTag(key)) {
                    passesFilter = true;
                    this.addTagToCache(key, reads, this.cachedTags);
                }
            } else {
                passesFilter = true;
            }
        }
        return passesFilter;
    }

    public void notifyTagRead(Map tags) {
        Hashtable<String, Map> publishTags = new Hashtable<String, Map>(13);
        Iterator i = tags.keySet().iterator();
        while (i.hasNext()) {
            String tagKey = (String)i.next();
            Map tagReads = (Map)tags.get(tagKey);
            boolean sendTag = false;
            sendTag = this.applyFiltering(tagKey, tagReads);
            this.applyAggregating(tagKey, tagReads);
            if (!sendTag) continue;
            publishTags.put(tagKey, tagReads);
        }
        if (!publishTags.isEmpty()) {
            Map tagMap = this.buildOuterTagMessage(publishTags);
            this.triggerTagReport(tagMap, false);
        }
    }

    private void triggerTagAggregationReport(Map tagMap, boolean withError) {
        if (withError) {
            this.tagAggregationReport.fireErrorOccurred(RfidInventoryProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagAggregationReport.trigger((Object)tagMap);
        }
    }

    private void triggerTagReport(Map tagMap, boolean withError) {
        if (withError || !this.getTagReadingValue()) {
            this.tagReport.fireErrorOccurred(RfidInventoryProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagReport.trigger((Object)tagMap);
        }
    }

    protected void setFilterDuplicatesLdapFilter(Filter filterDuplicatesLdapFilter) {
        this.duplicateFilteringLdapFilter = filterDuplicatesLdapFilter;
        this.evaluateDuplicateFilteringLdapFilter();
    }

    protected void setTagAggregatingLdapFilter(Filter tagAggregatingLdapFilter) {
        this.tagAggregatingLdapFilter = tagAggregatingLdapFilter;
        this.evaluateTagAggregatingLdapFilter();
    }

    protected void setTagReadingLdapFilter(Filter tagReadingLdapFilter) {
        this.tagReadingLdapFilter = tagReadingLdapFilter;
        this.evaluateTagReadingLdapFilter();
    }

    private synchronized void storeMapInLdap(Dictionary data) {
        Map values = (Map)data.get("value");
        if (values == null) {
            return;
        }
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = values.get(key);
            this.ldapMap.put(key, value);
        }
        this.applyLdap();
    }

    protected void updateTagInCache(String key, Map reads, Map cache) {
        Map oldReadData = (Map)cache.get(key);
        if (oldReadData == null) {
            this.addTagToCache(key, reads, cache);
            return;
        }
        oldReadData.put("timestampLast", reads.get("timestampLast"));
        int newCount = (Integer)reads.get("count");
        int previousCount = (Integer)oldReadData.get("count");
        oldReadData.put("count", new Integer(newCount + previousCount));
    }

    public void activate() {
        this.applyTagReading(this.getTagReadingValue());
        super.activate();
    }
}

