/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.adapter.bundle;

import java.util.Hashtable;
import org.eclipse.soda.dk.adapter.Adapter;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.service.log.LogService;

public abstract class AdapterBundle
extends BaseBundleActivator
implements BundleActivator {
    public static final String[] OPTIONAL_SERVICES = BaseBundleActivator.NO_SERVICES;
    private DeviceService device = null;
    private AdapterService adapter;

    public void activate() {
        NotificationService notificationService;
        DeviceService device = this.getDevice();
        if (this.adapter == null) {
            this.setAdapter(this.createService(device));
            if (this.adapter != null) {
                Hashtable properties = this.createProperties();
                String[] names = this.getExportedServiceNames();
                if (this.adapter instanceof Adapter) {
                    ((Adapter)this.adapter).setBundleContext(this.getBundleContext());
                }
                this.addExportedServices(names, this.adapter, properties);
            }
        } else {
            this.adapter.setDevice(device);
        }
        if ((notificationService = (NotificationService)this.getOptionalImportedService("org.eclipse.soda.dk.notification.service.NotificationService")) != null) {
            this.adapter.setNotificationService(notificationService);
        }
        this.adapter.start();
    }

    public Hashtable createProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(37);
        properties.put("id", "#");
        return properties;
    }

    public abstract AdapterService createService(DeviceService var1);

    protected void deactivate() {
        AdapterService adapter = this.getAdapter();
        if (adapter != null) {
            adapter.exit();
            this.setAdapter(null);
        }
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    public DeviceService getDevice() {
        if (this.device == null) {
            return (DeviceService)this.getImportedService(this.getInterestServiceName());
        }
        return this.device;
    }

    public abstract String[] getExportedServiceNames();

    public String getInterestServiceName() {
        return "";
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICES;
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        if (this.adapter != null && service instanceof NotificationService) {
            this.adapter.setNotificationService((NotificationService)service);
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        if (this.adapter != null && service instanceof NotificationService) {
            this.adapter.setNotificationService(null);
        }
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable exception) {
        LogService logService = EscObject.getDefaultLogService();
        logService.log(severity, message, exception);
    }

    public void setAdapter(AdapterService adapter) {
        this.adapter = adapter;
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }
}

