/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testagent.bundle;

import java.util.Hashtable;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.testagent.TestAgent;
import org.eclipse.soda.dk.testagent.service.TestAgentService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.framework.BundleActivator;

public abstract class TestAgentBundle
extends BaseBundleActivator
implements BundleActivator {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.testagent.bundle.TestAgentBundle";
    public static final String[] EXPORTED_SERVICE_NAMES = new String[]{TestAgentService.SERVICE_NAME};
    public static final String[] IMPORTED_SERVICE_NAMES = BaseBundleActivator.NO_SERVICES;
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    private TestAgent testAgent;

    public void activate() {
        NotificationService notificationService;
        if (this.testAgent == null) {
            this.setService(this.createService());
            if (this.testAgent != null) {
                Hashtable properties = this.createProperties();
                String[] names = this.getExportedServiceNames();
                this.addExportedServices(names, this.testAgent, properties);
            }
        }
        if ((notificationService = (NotificationService)this.getOptionalImportedService("org.eclipse.soda.dk.notification.service.NotificationService")) != null) {
            this.testAgent.setNotificationService(notificationService);
        }
    }

    public Hashtable createProperties() {
        Hashtable properties = new Hashtable(37);
        return properties;
    }

    public abstract TestAgent createService();

    protected void deactivate() {
        TestAgent agent = this.getService();
        if (agent != null) {
            this.setService(null);
        }
    }

    public String[] getExportedServiceNames() {
        return EXPORTED_SERVICE_NAMES;
    }

    public String[] getImportedServiceNames() {
        return IMPORTED_SERVICE_NAMES;
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICES;
    }

    public TestAgent getService() {
        return this.testAgent;
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        if (this.testAgent != null && service instanceof NotificationService) {
            this.testAgent.setNotificationService((NotificationService)service);
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        if (this.testAgent != null && service instanceof NotificationService) {
            this.testAgent.setNotificationService(null);
        }
    }

    public void setService(TestAgent agent) {
        this.testAgent = agent;
    }
}

