/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testagent;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.testagent.TestAgent;
import org.eclipse.soda.dk.testagent.framework.TestContext;
import org.eclipse.soda.dk.testagent.service.TestAgentService;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;

public class ConfiguredTestContext
implements TestContext {
    private TestAgent testAgent;
    private TestSynchronizationService syncService;
    private ConfigurationService configurationService;

    ConfiguredTestContext(TestAgent agent, TestSynchronizationService syncService, Dictionary properties) {
        this.testAgent = agent;
        this.syncService = syncService;
        Dictionary agentProperties = agent.getConfigurationService() == null ? new Hashtable() : agent.getConfigurationService().getProperties();
        this.configurationService = new EscConfiguration(this.updateProperties(agentProperties, properties));
    }

    public Dictionary getConfigurationInformation() {
        return this.configurationService.getProperties();
    }

    public Object getConfigurationInformation(String propertyName) {
        return this.getConfigurationInformation().get(propertyName);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public NotificationService getNotificationService() {
        return this.testAgent.getNotificationService();
    }

    public TestSynchronizationService getSynchronizationService() {
        return this.syncService;
    }

    public TestAgentService getTestAgent() {
        return this.testAgent;
    }

    public void log(int severity, String message) {
        this.testAgent.log(severity, message);
    }

    public void log(int severity, String message, Throwable exception) {
        this.testAgent.log(severity, message, exception);
    }

    private Dictionary updateProperties(Dictionary defaultProperties, Dictionary properties) {
        Object key;
        if (properties == null) {
            return defaultProperties;
        }
        Hashtable mergedProperties = new Hashtable(defaultProperties.size() + properties.size());
        Enumeration e = defaultProperties.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            ((Dictionary)mergedProperties).put(key, defaultProperties.get(key));
        }
        e = properties.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            ((Dictionary)mergedProperties).put(key, properties.get(key));
        }
        return mergedProperties;
    }
}

