/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testagent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.ResourceBundle;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.testagent.ConfiguredTestContext;
import org.eclipse.soda.dk.testagent.ConsoleSynchronization;
import org.eclipse.soda.dk.testagent.framework.TestContext;
import org.eclipse.soda.dk.testagent.service.TestAgentService;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;

public class TestAgent
extends ConfigurableObject
implements TestAgentService {
    public static final int NOTIFICATION_SEVICE_NOT_AVAILABLE = 7000;
    public static final int MISSING_CONFIGURATION = 7001;
    public static final int MISSING_SYNCHRONIZATION = 7002;
    public static final int METHODE_SUITE_MUST_BE_STATIC = 7003;
    public static final int FAILED_TO_INVOLE_SUITE = 7004;
    public static final int FAILED_TO_RUN_TEST = 7005;
    public static final int USAGE = 7006;
    public static final int OK_CANCEL_PROMPT = 7007;
    public static final int PROMPT = 7008;
    public static final int YES_CHAR = 7009;
    public static final int NO_CHAR = 7010;
    public static final int INVALID_REPLY = 7011;
    private static ThreadLocal threadLocal = new ThreadLocal();
    public static ResourceBundle DefaultResourceBundle;
    private Class testClass;
    private NotificationService notificationService;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.testagent.TestAgentResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public TestAgent() {
        this.setConfigurationInformation(EscConfiguration.getConfiguration().getProperties());
        this.setTestClass(this.loadTestClass());
    }

    public static TestContext getTestContext() {
        return (TestContext)threadLocal.get();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                TestAgent testAgent = new TestAgent();
                testAgent.setTestClass(Class.forName(args[0]));
                Notification notification = new Notification();
                testAgent.setNotificationService((NotificationService)notification);
                notification.start();
                testAgent.runTest(new ConsoleSynchronization(), null);
                notification.stop();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println(DefaultResourceBundle.getString(Integer.toString(7006)));
        }
    }

    public static void setTestContext(TestContext context) {
        threadLocal.set(context);
    }

    private TestContext createTestContext(TestSynchronizationService syncService, Dictionary properties) {
        return new ConfiguredTestContext(this, syncService, properties);
    }

    public String getDescription() {
        return this.testClass.toString();
    }

    public String getId() {
        return this.getString("id", "");
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    private Test getSuite() {
        Method suiteMethod = null;
        try {
            suiteMethod = this.getTestClass().getMethod("suite", new Class[0]);
        }
        catch (Exception exception) {
            return new TestSuite(this.getTestClass());
        }
        if (!Modifier.isStatic(suiteMethod.getModifiers())) {
            this.log(1, DefaultResourceBundle.getString(Integer.toString(7003)));
            return null;
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException e) {
            this.log(1, DefaultResourceBundle.getString(Integer.toString(7004)), e.getTargetException());
            return null;
        }
        catch (IllegalAccessException e) {
            this.log(1, DefaultResourceBundle.getString(Integer.toString(7004)), e);
            return null;
        }
        return test;
    }

    public Class getTestClass() {
        return this.testClass;
    }

    protected Class loadTestClass() {
        return null;
    }

    public void runTest(TestSynchronizationService syncService, Dictionary properties, TestResult result) {
        TestAgent.setTestContext(this.createTestContext(syncService, properties));
        Test suite = this.getSuite();
        if (suite != null) {
            try {
                this.setUp();
                suite.run(result);
                this.tearDown();
            }
            catch (Exception e) {
                this.log(1, DefaultResourceBundle.getString(Integer.toString(7005)), e);
            }
        }
        TestAgent.setTestContext(null);
    }

    public TestResult runTest(TestSynchronizationService syncService, Dictionary properties) {
        TestResult result = null;
        TestAgent.setTestContext(this.createTestContext(syncService, properties));
        Test suite = this.getSuite();
        if (suite != null) {
            try {
                this.setUp();
                result = TestRunner.run((Test)suite);
                this.tearDown();
            }
            catch (Exception e) {
                this.log(1, DefaultResourceBundle.getString(Integer.toString(7005)), e);
            }
        }
        TestAgent.setTestContext(null);
        return result;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setTestClass(Class testClass) {
        this.testClass = testClass;
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }
}

