/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testagent.framework;

import java.util.Dictionary;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.testagent.TestAgent;
import org.eclipse.soda.dk.testagent.framework.ConfiguredTestCase;
import org.eclipse.soda.dk.testagent.util.NotificationProbe;

public abstract class NotificationClientTestCase
extends ConfiguredTestCase {
    private NotificationProbe probe = null;

    public NotificationClientTestCase() {
    }

    public NotificationClientTestCase(String name) {
        super(name);
    }

    public void broadcast(String topic, Dictionary data) {
        this.getNotificationService().broadcast(topic, data);
    }

    public void broadcast(String topic, Object dataKey, Object dataValue) {
        this.getNotificationService().broadcast(topic, NotificationProbe.toData(dataKey, dataValue));
    }

    protected String[] getExternalKeys() {
        return null;
    }

    public NotificationService getNotificationService() {
        NotificationService notificationService = this.getContext().getNotificationService();
        NotificationClientTestCase.assertNotNull((String)TestAgent.DefaultResourceBundle.getString(Integer.toString(7000)), (Object)notificationService);
        return notificationService;
    }

    public NotificationProbe getProbe() {
        return this.probe;
    }

    public void register(String topic) {
        this.getNotificationService().register(topic, (NotificationListener)this.probe);
    }

    public void register(String[] topics) {
        this.getNotificationService().register(topics, (NotificationListener)this.probe);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.probe = new NotificationProbe();
        String[] externalKeys = this.getExternalKeys();
        if (externalKeys != null) {
            this.register(externalKeys);
        }
    }

    protected void tearDown() throws Exception {
        this.unregister();
        super.tearDown();
    }

    public void unregister() {
        this.getNotificationService().unregister((NotificationListener)this.probe);
    }
}

