/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.nls.testcase;

import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;

public class EscConfigurationTestcase
extends TestCase {
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public EscConfigurationTestcase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.nls.testcase.EscConfigurationTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testBoolean() {
        ConfigurationService configuration = EscConfiguration.getConfiguration();
        boolean result = configuration.getBoolean("foo", true);
        EscConfigurationTestcase.assertEquals((boolean)true, (boolean)result);
        result = configuration.getBoolean("foo", false);
        EscConfigurationTestcase.assertEquals((boolean)false, (boolean)result);
        result = configuration.getBoolean("bt", false);
        EscConfigurationTestcase.assertEquals((boolean)true, (boolean)result);
        result = configuration.getBoolean("bf", true);
        EscConfigurationTestcase.assertEquals((boolean)false, (boolean)result);
        Properties properties = System.getProperties();
        properties.setProperty("bar", "true");
        System.setProperties(properties);
        result = configuration.getBoolean("bar", false);
        EscConfigurationTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void testInt() {
        ConfigurationService configuration = EscConfiguration.getConfiguration();
        int result = configuration.getInt("fooint", 10);
        EscConfigurationTestcase.assertEquals((int)20, (int)result);
        result = configuration.getInt("fooint_not", 10);
        EscConfigurationTestcase.assertEquals((int)10, (int)result);
    }

    public void testInt2() {
        System.getProperties().put("fooint", new Integer(20));
        ConfigurationService configuration = EscConfiguration.getConfiguration();
        int result = configuration.getInt("fooint", 10);
        EscConfigurationTestcase.assertEquals((int)20, (int)result);
        result = configuration.getInt("fooint_not", 10);
        EscConfigurationTestcase.assertEquals((int)10, (int)result);
    }

    public void testString() {
        ConfigurationService configuration = EscConfiguration.getConfiguration();
        String result = configuration.getString("foostring", "default");
        EscConfigurationTestcase.assertEquals((String)"ok", (String)result);
        result = configuration.getString("fooint_s", "default");
        EscConfigurationTestcase.assertEquals((String)"default", (String)result);
    }
}

