/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.AsciiMessage;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.ListParameters;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class ListParametersTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public ListParametersTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.parameter.testcase.ListParametersTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testEncodeInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        ListParameters parameters = new ListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(1));
        values.add(new Integer(5));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParametersTestcase.assertEquals((byte)result.getBytes()[1], (byte)1);
        ListParametersTestcase.assertEquals((byte)result.getBytes()[2], (byte)5);
    }

    public void testEncodeInteger8() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        ListParameters parameters = new ListParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Vector<Integer> values = new Vector<Integer>();
        values.add(new Integer(2));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParametersTestcase.assertEquals((byte)result.getBytes()[1], (byte)2);
    }

    public void testEncodeLong() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 225);
        ListParameters parameters = new ListParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[9];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Vector<Long> values = new Vector<Long>();
        values.add(new Long(Long.MAX_VALUE));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParametersTestcase.assertEquals((byte)result.getBytes()[1], (byte)127);
    }

    public void testEncodeString() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        SimpleParameter parameterThree = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        ListParameters parameters = new ListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo, parameterThree});
        AsciiMessage message = new AsciiMessage("09");
        Vector<String> values = new Vector<String>();
        values.add("abc");
        values.add(null);
        values.add("def");
        MessageService result = parameters.encodeValue((MessageService)message, values);
        ListParametersTestcase.assertEquals((int)result.getBytes()[1], (int)97);
        ListParametersTestcase.assertEquals((int)result.getBytes()[2], (int)98);
        ListParametersTestcase.assertEquals((String)new String(result.getBytes()), (String)"0abcdef9");
    }

    public void testInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter(EMPTY_STRING, null, 2, 1, 1);
        ListParameters parameters = new ListParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, 10, 1});
        Object result = parameters.decodeValue((MessageService)message);
        ListParametersTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        ListParametersTestcase.assertEquals(value, (Object)new Integer(10));
        Object valueTwo = ((List)result).get(1);
        ListParametersTestcase.assertEquals(valueTwo, (Object)new Integer(1));
    }

    public void testTrue() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 48);
        ListParameters parameters = new ListParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        byArray[1] = 8;
        Message message = new Message(byArray);
        Object result = parameters.decodeValue((MessageService)message);
        ListParametersTestcase.assertEquals((boolean)true, (boolean)(result instanceof List));
        Object value = ((List)result).get(0);
        ListParametersTestcase.assertEquals(value, (Object)Boolean.TRUE);
    }
}

