/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.util.Hashtable;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MapParameters;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class MapParametersTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public MapParametersTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.parameter.testcase.MapParametersTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testEncodeInteger() {
        SimpleParameter parameter = new SimpleParameter("One", null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter("Two", null, 2, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, -1, -1});
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put(parameter.getKey(), new Integer(1));
        values.put(parameterTwo.getKey(), new Integer(5));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        MapParametersTestcase.assertEquals((byte)1, (byte)result.getBytes()[1]);
        MapParametersTestcase.assertEquals((byte)5, (byte)result.getBytes()[2]);
    }

    public void testEncodeInteger8() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        values.put(parameter.getKey(), new Integer(2));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        MapParametersTestcase.assertEquals((byte)2, (byte)result.getBytes()[1]);
    }

    public void testEncodeLong() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 225);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[9];
        byArray[0] = 90;
        Message message = new Message(byArray);
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        values.put(parameter.getKey(), new Long(Long.MAX_VALUE));
        MessageService result = parameters.encodeValue((MessageService)message, values);
        MapParametersTestcase.assertEquals((byte)127, (byte)result.getBytes()[1]);
    }

    public void testInteger() {
        SimpleParameter parameter = new SimpleParameter("One", null, 1, 1, 1);
        SimpleParameter parameterTwo = new SimpleParameter("Two", null, 2, 1, 1);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter, parameterTwo});
        Message message = new Message(new byte[]{90, 10, 1});
        Object result = parameters.decodeValue((MessageService)message);
        MapParametersTestcase.assertEquals((boolean)true, (boolean)(result instanceof Map));
        Object value = ((Map)result).get(parameter.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(10), value);
        Object valueTwo = ((Map)result).get(parameterTwo.getKey());
        MapParametersTestcase.assertEquals((Object)new Integer(1), valueTwo);
    }

    public void testTrue() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 48);
        MapParameters parameters = new MapParameters(EMPTY_STRING, new ParameterService[]{parameter});
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        byArray[1] = 8;
        Message message = new Message(byArray);
        Object result = parameters.decodeValue((MessageService)message);
        MapParametersTestcase.assertEquals((boolean)true, (boolean)(result instanceof Map));
        Object value = ((Map)result).get(parameter.getKey());
        MapParametersTestcase.assertEquals((Object)Boolean.TRUE, value);
    }
}

