/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.transform.NotTransform;

public class NotTransformTestcase
extends TestCase {
    private Object obj;
    private NotTransform transform;
    static /* synthetic */ Class class$0;

    public NotTransformTestcase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transform.testcase.NotTransformTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testNotTransformDecodeException() {
        this.obj = new Object();
        this.transform = new NotTransform();
        Exception ee = null;
        try {
            this.transform.decode(this.obj);
        }
        catch (Exception e) {
            ee = e;
        }
        NotTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        NotTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testNotTransformDecodeFalseToTrue() {
        this.obj = Boolean.FALSE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be True", (boolean)((Boolean)this.transform.decode(this.obj)));
    }

    public void testNotTransformDecodeTrueToFalse() {
        this.obj = Boolean.TRUE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be False", ((Boolean)this.transform.decode(this.obj) == false ? 1 : 0) != 0);
    }

    public void testNotTransformDecodeTypeTestWithFalse() {
        this.obj = Boolean.FALSE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be Instance of Boolean", (boolean)(this.transform.decode(this.obj) instanceof Boolean));
    }

    public void testNotTransformDecodeTypeTestWithTrue() {
        this.obj = Boolean.TRUE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be Instance of Boolean", (boolean)(this.transform.decode(this.obj) instanceof Boolean));
    }

    public void testNotTransformEncodeException() {
        this.obj = new Object();
        this.transform = new NotTransform();
        Exception ee = null;
        try {
            this.transform.encode(this.obj);
        }
        catch (Exception e) {
            ee = e;
        }
        NotTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        NotTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testNotTransformEncodeFalseToTrue() {
        this.obj = Boolean.FALSE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be True", (boolean)((Boolean)this.transform.encode(this.obj)));
    }

    public void testNotTransformEncodeTrueToFalse() {
        this.obj = Boolean.TRUE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be False", ((Boolean)this.transform.encode(this.obj) == false ? 1 : 0) != 0);
    }

    public void testNotTransformEncodeTypeTestWithFalse() {
        this.obj = Boolean.FALSE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be Instance of Boolean", (boolean)(this.transform.encode(this.obj) instanceof Boolean));
    }

    public void testNotTransformEncodeTypeTestWithTrue() {
        this.obj = Boolean.TRUE;
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"Should Be Instance of Boolean", (boolean)(this.transform.encode(this.obj) instanceof Boolean));
    }

    public void testTransformConstruction() {
        this.transform = new NotTransform();
        NotTransformTestcase.assertTrue((String)"NotTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
    }
}

