/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.transform.XorTransform;

public class XorTransformTestcase
extends TestCase {
    private Object obj;
    private XorTransform transform;
    static /* synthetic */ Class class$0;

    public XorTransformTestcase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transform.testcase.XorTransformTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDecodeForException() {
        this.transform = new XorTransform(0);
        this.obj = new Object();
        Exception ee = null;
        try {
            this.transform.decode(this.obj);
        }
        catch (Exception e) {
            ee = e;
        }
        XorTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        XorTransformTestcase.assertTrue((String)"Unknown Exception Thrown", (boolean)(ee instanceof ClassCastException));
    }

    public void testDecodeForType() {
        this.transform = new XorTransform(0);
        this.obj = this.transform.decode((Object)new Integer(1000));
        XorTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testDecodeXorWith0x7FFFFFFF() {
        this.transform = new XorTransform(Integer.MAX_VALUE);
        XorTransformTestcase.assertEquals((int)2147482647, (int)((Integer)this.transform.decode((Object)new Integer(1000))));
    }

    public void testDecodeXorWithZero() {
        this.transform = new XorTransform(0);
        XorTransformTestcase.assertEquals((int)1000, (int)((Integer)this.transform.decode((Object)new Integer(1000))));
    }

    public void testEncodeForException() {
        this.transform = new XorTransform(0);
        this.obj = new Object();
        Exception ee = null;
        try {
            this.transform.encode(this.obj);
        }
        catch (Exception e) {
            ee = e;
        }
        XorTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        XorTransformTestcase.assertTrue((String)"Unknown Exception Thrown", (boolean)(ee instanceof ClassCastException));
    }

    public void testEncodeForType() {
        this.transform = new XorTransform(0);
        this.obj = this.transform.encode((Object)new Integer(1000));
        XorTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testEncodeXorWith0x7FFFFFFF() {
        this.transform = new XorTransform(Integer.MAX_VALUE);
        XorTransformTestcase.assertEquals((int)2147482647, (int)((Integer)this.transform.encode((Object)new Integer(1000))));
    }

    public void testEncodeXorWithZero() {
        this.transform = new XorTransform(0);
        XorTransformTestcase.assertEquals((int)1000, (int)((Integer)this.transform.encode((Object)new Integer(1000))));
    }

    public void testTransformIntConstructor() {
        this.transform = new XorTransform(0);
        XorTransformTestcase.assertTrue((String)"XorTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new XorTransform(1);
        XorTransformTestcase.assertTrue((String)"XorTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new XorTransform(-1);
        XorTransformTestcase.assertTrue((String)"XorTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new XorTransform(Integer.MAX_VALUE);
        XorTransformTestcase.assertTrue((String)"XorTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new XorTransform(Integer.MIN_VALUE);
        XorTransformTestcase.assertTrue((String)"XorTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
    }
}

