/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager;

import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testcontroller.TestController;
import org.eclipse.soda.dk.testcontroller.service.TestControllerService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.console.TestManagerConsole;
import org.eclipse.soda.dk.testmanager.parser.ContentHandler;
import org.eclipse.soda.dk.testmanager.service.TestManagerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;

public class TestManager
extends ConfigurableObject
implements TestManagerService {
    public static final int UNEXPECTED_XML_START = 7150;
    public static final int UNEXPECTED_XML_END = 7151;
    public static final int USAGE = 7152;
    public static final int UPDATING_WITH_FILTER = 7153;
    public static final int UPDATE_LC = 7154;
    public static final int UPDATE_UC = 7155;
    public static final int SEQUENTIAL_LC = 7156;
    public static final int SEQUENTIAL_UC = 7157;
    public static final int PARALLEL_LC = 7158;
    public static final int PARALLEL_UC = 7159;
    public static final int START_ALL_TESTS_MATCH = 7160;
    public static final int START_SINGLE_TEST_MATCH = 7161;
    public static final int INVALID_FILTER = 7162;
    public static final int COMMUNICATION_ERROR = 7163;
    public static final int TEST_ACTION = 7164;
    public static final int UPDATING_CONFIG_W_FILTER = 7165;
    public static final int CREATING_CONFIG = 7166;
    public static final int CREATE_UPDATE = 7167;
    public static final int UPDATE_CREATE_CONFIG = 7168;
    public static final int CREATE_UPDATE_CONFIG = 7169;
    public static final int CREATE_LC = 7170;
    public static final int CREATE_UC = 7171;
    public static final int CONFIGURATION_REQUEST = 7172;
    public static final int CREATE_UPDATE_ONE_WORD = 7173;
    public static final int DELETE_LC = 7174;
    public static final int DELETE_UC = 7175;
    public static final int TEST_ACTION_W_DASH = 7176;
    public static final int DELETING_CONFIGS = 7177;
    public static final int ERRORS = 7178;
    public static final int SCRIPT_ACTION_ENDED = 7179;
    public static final int ERROR_EXECUTING = 7180;
    public static final int SCRIPT_ACTION_STARTING = 7181;
    public static final int CONFIG_CHANGES = 7182;
    public static final int TESTS = 7183;
    public static final int TEST_CASES = 7184;
    public static final int TEST_COMPLETED = 7185;
    public static final int ERROR_RUNNING_SCRIPT = 7186;
    public static final int UNTITLED = 7187;
    public static final int INVALID_MATCH_TYPE = 7188;
    public static final int ACTION_REQUIRES_FILTER = 7189;
    public static final int ACTION_REQUIRES = 7190;
    public static final int TEST_SCRIPT_RUNNER = 7191;
    public static final int RUNNING_SCRIPT = 7192;
    public static final int MULTIPLE_SINGLE_EXPECTED = 7193;
    public static final int CANNOT_PROCESS = 7194;
    public static int UNEXPECTED_ATTR_VALUE = 7195;
    public static ResourceBundle DefaultResourceBundle;
    private SAXParserFactory saxParserFactory;
    private TestControllerService testController;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.testmanager.TestManagerResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public TestManager() {
        ConfigurationService defaultConfiguration = EscConfiguration.getConfiguration();
        this.setConfigurationInformation(defaultConfiguration.getProperties());
    }

    public static void main(String[] args) {
        String fileOrUrl;
        if (args.length == 0) {
            fileOrUrl = EscObject.getStaticString((String)"testscript", (String)"test.xml");
        } else if (args.length == 1) {
            fileOrUrl = args[0];
        } else {
            fileOrUrl = null;
            System.err.println(DefaultResourceBundle.getString(Integer.toString(7152)));
        }
        if (fileOrUrl != null) {
            try {
                InputStreamReader in;
                try {
                    URL url = new URL(fileOrUrl);
                    in = new InputStreamReader(url.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    in = new FileReader(fileOrUrl);
                }
                TestController testController = new TestController();
                TestManager testManager = new TestManager();
                testManager.setTestController((TestControllerService)testController);
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                testManager.setSaxParserFactory(saxParserFactory);
                TestScriptService testScript = testManager.parse(in);
                testScript.getAttributes().put("url", fileOrUrl);
                TestManagerConsole console = new TestManagerConsole();
                TestSessionService testSession = testManager.createTestSession((TestSynchronizationService)console);
                testSession.addGlobalTestRunListener((TestRunListenerService)console);
                NotificationService notificationService = Notification.getBroker();
                testController.setNotificationService(notificationService);
                testScript.run(testSession, console, false);
                ((Notification)notificationService).stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TestSessionService createTestSession(TestSynchronizationService syncService) {
        return this.testController.createTestSession(syncService);
    }

    public String getDefaultKey() {
        return null;
    }

    public TestScriptService parse(Reader in) throws Exception {
        return ContentHandler.parse(this.saxParserFactory, in);
    }

    public void setSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public void setTestController(TestControllerService testController) {
        this.testController = testController;
    }
}

