/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.ActionContainer;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.service.ScriptRunListenerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;

public class TestScript
implements TestScriptService,
ActionContainer,
Runnable {
    private TestSessionService testSession;
    private ScriptRunListenerService scriptListener;
    private Map attributes;
    private Map testStatistics;
    private List actions = new ArrayList();

    public TestScript() {
        this.attributes = new Hashtable();
        this.testStatistics = new Hashtable();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void run(TestSessionService testSession, ScriptRunListenerService scriptListener, boolean asynchronous) throws InterruptedException {
        this.testSession = testSession;
        this.scriptListener = scriptListener;
        if (asynchronous) {
            new Thread((Runnable)this, TestManager.DefaultResourceBundle.getString(Integer.toString(7191))).start();
        } else {
            this.execute();
        }
    }

    public TestSessionService getTestSession() {
        return this.testSession;
    }

    public ScriptRunListenerService getScriptListener() {
        return this.scriptListener;
    }

    public synchronized void incrementStatistic(String statsKey) {
        Integer count = (Integer)this.testStatistics.get(statsKey);
        count = new Integer(count == null ? 1 : count + 1);
        this.testStatistics.put(statsKey, count);
    }

    public synchronized Map getTestStatistics() {
        return this.testStatistics;
    }

    public void add(Action action) {
        this.actions.add(action);
    }

    public void run() {
        try {
            this.execute();
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute() throws InterruptedException {
        try {
            try {
                this.scriptListener.scriptRunStarted(this);
                Iterator iter = this.actions.iterator();
                while (iter.hasNext()) {
                    Object var3_5;
                    Action action = (Action)iter.next();
                    this.scriptListener.scriptActionStarted(action.getDescription());
                    try {
                        action.execute(this);
                    }
                    catch (Throwable throwable) {
                        var3_5 = null;
                        this.scriptListener.scriptActionEnded(action.getDescription());
                        throw throwable;
                    }
                    {
                        var3_5 = null;
                        this.scriptListener.scriptActionEnded(action.getDescription());
                    }
                }
            }
            catch (RuntimeException e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.incrementStatistic("TEST_SCRIPT_ERROR_COUNT");
                this.scriptListener.scriptRunError(e.toString(), writer.toString());
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.scriptListener.scriptRunEnded(this.testStatistics);
            this.testSession.close();
            this.testSession = null;
            throw throwable;
        }
        {
            Object var5_9 = null;
            this.scriptListener.scriptRunEnded(this.testStatistics);
        }
        this.testSession.close();
        this.testSession = null;
    }
}

