/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.action.ConfigurationTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.InvalidSyntaxException;

public abstract class ConfigurationAction
implements Action {
    private List configurationTemplates = new ArrayList();

    public void addConfiguration(String pid, String factoryPid, String bundleLocation, String filter, Dictionary properties) {
        ConfigurationTemplate template = new ConfigurationTemplate(pid, factoryPid, bundleLocation, filter, properties);
        this.configurationTemplates.add(template);
    }

    public void execute(TestScriptService testScript) {
        Iterator iterator = this.getConfigurationTemplates().iterator();
        while (iterator.hasNext()) {
            ConfigurationTemplate template = (ConfigurationTemplate)iterator.next();
            try {
                testScript.incrementStatistic("CONFIGURATION_COUNT");
                this.execute(testScript, template);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                String filter = template.getFilter();
                Object[] parms = new Object[]{filter};
                LogUtility.logError((String)Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                testScript.getScriptListener().scriptActionError(this.getDescription(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                testScript.incrementStatistic("CONFIGURATION_ERROR_COUNT");
            }
            catch (IOException exception) {
                LogUtility.logError((Object)this, (String)TestManager.DefaultResourceBundle.getString(Integer.toString(7163)), (Throwable)exception);
                testScript.getScriptListener().scriptActionError(this.getDescription(), TestManager.DefaultResourceBundle.getString(Integer.toString(7163)));
                testScript.incrementStatistic("CONFIGURATION_ERROR_COUNT");
            }
        }
    }

    protected abstract void execute(TestScriptService var1, ConfigurationTemplate var2) throws InvalidSyntaxException, IOException;

    protected List getConfigurationTemplates() {
        return this.configurationTemplates;
    }

    public String getDescription() {
        Object[] parms = new Object[]{this.getName()};
        return Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7172)), (Object[])parms);
    }

    protected abstract String getName();

    protected void handleScriptActionError(TestScriptService testScript, String detail) {
        Object[] parms = new Object[]{this.getDescription()};
        testScript.getScriptListener().scriptActionError(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7194)), (Object[])parms), detail);
    }
}

