/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.Dictionary;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.action.ActionListener;
import org.eclipse.soda.dk.testmanager.action.TestAction;
import org.eclipse.soda.dk.testmanager.action.TestTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.osgi.framework.InvalidSyntaxException;

public class ParallelTestAction
extends TestAction {
    protected int execute(TestScriptService testScript, TestTemplate template) throws InvalidSyntaxException, IOException {
        String runId = template.getRunId();
        String filter = template.getFilter();
        String className = template.getClassName();
        String matchType = template.getMatchType();
        Dictionary properties = template.getProperties();
        if ("multiple".equals(matchType)) {
            Object[] parms = new Object[]{this.getMatchDescription(filter, className)};
            testScript.getScriptListener().scriptActionInfo(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7160)), (Object[])parms));
            testScript.getTestSession().runMultipleTests(runId, filter, className, properties, (TestRunListenerService)this);
        } else if (matchType == null || "single".equals(matchType)) {
            Object[] parms = new Object[]{this.getMatchDescription(filter, className)};
            testScript.getScriptListener().scriptActionInfo(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7161)), (Object[])parms));
            testScript.getTestSession().runSingleTest(runId, filter, className, properties, (TestRunListenerService)this);
        } else {
            Object[] parms1 = new Object[]{this.getDescription()};
            Object[] parms2 = new Object[]{matchType};
            testScript.getScriptListener().scriptActionError(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7188)), (Object[])parms1), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7193)), (Object[])parms2));
        }
        return 1;
    }

    protected int execute(final TestScriptService testScript, final Action action, final ActionListener actionListener) throws InterruptedException {
        Runnable async = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                actionListener.actionStarted(action);
                try {
                    try {
                        action.execute(testScript);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    actionListener.actionEnded(action);
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    actionListener.actionEnded(action);
                    return;
                }
            }
        };
        Object[] parms = new Object[]{action.getDescription()};
        Thread actionThread = new Thread(async, Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7176)), (Object[])parms));
        actionThread.start();
        return 0;
    }

    protected String getName() {
        return TestManager.DefaultResourceBundle.getString(Integer.toString(7159));
    }
}

