/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.Dictionary;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.action.ActionListener;
import org.eclipse.soda.dk.testmanager.action.TestAction;
import org.eclipse.soda.dk.testmanager.action.TestTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.osgi.framework.InvalidSyntaxException;

public class SequentialTestAction
extends TestAction {
    protected int execute(TestScriptService testScript, TestTemplate template) throws InvalidSyntaxException, IOException, InterruptedException {
        String runId = template.getRunId();
        String filter = template.getFilter();
        String className = template.getClassName();
        String matchType = template.getMatchType();
        Dictionary properties = template.getProperties();
        if ("multiple".equals(matchType)) {
            Object[] parms = new Object[]{this.getMatchDescription(filter, className)};
            testScript.getScriptListener().scriptActionInfo(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7160)), (Object[])parms));
            testScript.getTestSession().runMultipleTests(runId, filter, className, properties, (TestRunListenerService)this);
        } else if (matchType == null || "single".equals(matchType)) {
            Object[] parms = new Object[]{this.getMatchDescription(filter, className)};
            testScript.getScriptListener().scriptActionInfo(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7161)), (Object[])parms));
            testScript.getTestSession().runSingleTest(runId, filter, className, properties, (TestRunListenerService)this);
        } else {
            Object[] parms1 = new Object[]{this.getDescription()};
            Object[] parms2 = new Object[]{matchType};
            testScript.getScriptListener().scriptActionError(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7188)), (Object[])parms1), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7193)), (Object[])parms2));
        }
        this.waitForTests();
        return 0;
    }

    protected int execute(TestScriptService testScript, Action action, ActionListener actionListener) throws InterruptedException {
        actionListener.actionStarted(action);
        action.execute(testScript);
        actionListener.actionEnded(action);
        return 0;
    }

    protected String getName() {
        return TestManager.DefaultResourceBundle.getString(Integer.toString(7157));
    }
}

