/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testmanager.ActionContainer;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.action.ActionListener;
import org.eclipse.soda.dk.testmanager.action.TestTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.InvalidSyntaxException;

public abstract class TestAction
implements Action,
ActionContainer,
ActionListener,
TestRunListenerService {
    private List testTemplatesAndActions = new ArrayList();
    private Set runningTests = new HashSet();
    private TestScriptService testScript;

    public synchronized void actionEnded(Action action) {
        this.runningTests.remove(action);
        if (this.runningTests.isEmpty()) {
            this.notify();
        }
    }

    public synchronized void actionStarted(Action action) {
        this.runningTests.add(action);
    }

    public void add(Action action) {
        this.testTemplatesAndActions.add(action);
    }

    public void addTest(String runId, String filter, String className, String match, Dictionary properties) {
        TestTemplate template = new TestTemplate(runId, filter, className, match, properties);
        this.testTemplatesAndActions.add(template);
    }

    public void execute(TestScriptService testScript) throws InterruptedException {
        this.testScript = testScript;
        Iterator iterator = this.getTestTemplatesAndActions().iterator();
        int countTests = 0;
        while (iterator.hasNext() && !testScript.getTestSession().isInterrupted()) {
            Object templateOrAction = iterator.next();
            if (templateOrAction instanceof TestTemplate) {
                TestTemplate template = (TestTemplate)templateOrAction;
                try {
                    testScript.incrementStatistic("TEST_COUNT");
                    countTests += this.execute(testScript, template);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    String filter = template.getFilter();
                    Object[] parms = new Object[]{filter};
                    LogUtility.logError((String)Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                    testScript.getScriptListener().scriptActionError(this.getDescription(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                    testScript.incrementStatistic("TEST_ERROR_COUNT");
                }
                catch (IOException exception) {
                    LogUtility.logError((Object)this, (String)TestManager.DefaultResourceBundle.getString(Integer.toString(7163)), (Throwable)exception);
                    testScript.getScriptListener().scriptActionError(this.getDescription(), TestManager.DefaultResourceBundle.getString(Integer.toString(7163)));
                    testScript.incrementStatistic("TEST_ERROR_COUNT");
                }
                continue;
            }
            Action action = (Action)templateOrAction;
            countTests += this.execute(testScript, action, this);
        }
        if (countTests > 0) {
            this.waitForTests();
        }
    }

    protected abstract int execute(TestScriptService var1, TestTemplate var2) throws InvalidSyntaxException, IOException, InterruptedException;

    protected abstract int execute(TestScriptService var1, Action var2, ActionListener var3) throws InterruptedException;

    public String getDescription() {
        return String.valueOf(this.getName()) + TestManager.DefaultResourceBundle.getString(Integer.toString(7164));
    }

    protected String getMatchDescription(String filter, String className) {
        String description = null;
        if (filter != null) {
            description = filter;
        }
        if (className != null) {
            description = description == null ? className : String.valueOf(description) + " (" + className + ')';
        }
        return description;
    }

    protected abstract String getName();

    protected List getTestTemplatesAndActions() {
        return this.testTemplatesAndActions;
    }

    public void testEnded(String runId, String testName) {
    }

    public void testError(String runId, String testName, String trace) {
        this.testScript.incrementStatistic("TEST_CASE_ERROR_COUNT");
    }

    public void testFailed(String runId, String testName, String trace) {
        this.testScript.incrementStatistic("TEST_CASE_FAILED_COUNT");
    }

    public synchronized void testRunEnded(String runId) {
        this.runningTests.remove(runId);
        if (this.runningTests.isEmpty()) {
            this.notify();
        }
    }

    public void testRunError(String runId, String message, String detail) {
    }

    public synchronized void testRunStarted(String runId) {
        this.runningTests.add(runId);
    }

    public void testStarted(String runId, String testName) {
        this.testScript.incrementStatistic("TEST_CASE_COUNT");
    }

    protected synchronized void waitForTests() throws InterruptedException {
        do {
            this.wait();
        } while (!this.runningTests.isEmpty());
    }
}

