/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.console;

import java.util.Map;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.console.TestControllerConsole;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.service.ScriptRunListenerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;

public class TestManagerConsole
extends TestControllerConsole
implements ScriptRunListenerService {
    private static void appendAttribute(StringBuffer detail, String name, Object value) {
        if (value != null) {
            detail.append(name);
            detail.append(": ");
            detail.append(value);
            detail.append('\n');
        }
    }

    private static int getCount(Map testStatistics, String statKey) {
        Integer count = (Integer)testStatistics.get(statKey);
        return count == null ? 0 : count;
    }

    public void scriptActionEnded(String message) {
        Object[] parms = new Object[]{message};
        this.printEvent(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7179)), (Object[])parms));
    }

    public void scriptActionError(String message, String detail) {
        Object[] parms = new Object[]{message};
        this.printErrorEvent(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7180)), (Object[])parms), detail);
    }

    public void scriptActionInfo(String message) {
        this.printEvent(message);
    }

    public void scriptActionStarted(String message) {
        Object[] parms = new Object[]{message};
        this.printEvent(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7181)), (Object[])parms));
    }

    public void scriptRunEnded(Map testStatistics) {
        int testCount;
        int testActionCount;
        int configActionCount;
        boolean error = false;
        StringBuffer trace = new StringBuffer();
        int scriptErrorCount = TestManagerConsole.getCount(testStatistics, "TEST_SCRIPT_ERROR_COUNT");
        if (scriptErrorCount > 0) {
            error = true;
        }
        if ((configActionCount = TestManagerConsole.getCount(testStatistics, "CONFIGURATION_COUNT")) > 0) {
            int configActionErrorCount = TestManagerConsole.getCount(testStatistics, "CONFIGURATION_ERROR_COUNT");
            if (configActionErrorCount > 0) {
                error = true;
            }
            Object[] parms = new Object[]{new Integer(configActionCount), new Integer(configActionErrorCount)};
            trace.append(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7182)), (Object[])parms));
        }
        if ((testActionCount = TestManagerConsole.getCount(testStatistics, "TEST_COUNT")) > 0) {
            int testActionErrorCount = TestManagerConsole.getCount(testStatistics, "TEST_ERROR_COUNT");
            if (testActionErrorCount > 0) {
                error = true;
            }
            Object[] parms = new Object[]{new Integer(testActionCount), new Integer(testActionErrorCount)};
            trace.append(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7183)), (Object[])parms));
        }
        if ((testCount = TestManagerConsole.getCount(testStatistics, "TEST_CASE_COUNT")) > 0) {
            int testErrorCount = TestManagerConsole.getCount(testStatistics, "TEST_CASE_ERROR_COUNT");
            int testFailedCount = TestManagerConsole.getCount(testStatistics, "TEST_CASE_FAILED_COUNT");
            if (testErrorCount > 0 || testFailedCount > 0) {
                error = true;
            }
            Object[] parms = new Object[]{new Integer(testCount), new Integer(testErrorCount), new Integer(testFailedCount)};
            trace.append(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7184)), (Object[])parms));
        }
        this.printEvent(error, TestManager.DefaultResourceBundle.getString(Integer.toString(7185)), trace.toString());
    }

    public void scriptRunError(String message, String trace) {
        Object[] parms = new Object[]{message};
        this.printErrorEvent(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7186)), (Object[])parms), trace);
    }

    public void scriptRunStarted(TestScriptService script) {
        Object title = script.getAttributes().get("title");
        Object version = script.getAttributes().get("version");
        Object vendor = script.getAttributes().get("vendor");
        Object description = script.getAttributes().get("description");
        Object url = script.getAttributes().get("url");
        if (title == null) {
            title = TestManager.DefaultResourceBundle.getString(Integer.toString(7187));
        }
        StringBuffer detail = new StringBuffer();
        TestManagerConsole.appendAttribute(detail, "version", version);
        TestManagerConsole.appendAttribute(detail, "vendor", vendor);
        TestManagerConsole.appendAttribute(detail, "description", description);
        TestManagerConsole.appendAttribute(detail, "url", url);
        Object[] parms = new Object[]{title};
        this.printEvent(false, Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7192)), (Object[])parms), detail.toString());
    }
}

